/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.tabletree.DesignPageNavigationLocation;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.ViewerExpandCollapseAction;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorPluginImageHelper;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorActionBarContributor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeViewer;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLMultiPageEditorPart
extends MultiPageEditorPart
implements INavigationLocationProvider,
IPersistableEditor {
    private int fDesignPageIndex;
    IDesignViewer fDesignViewer;
    private Composite fDesignContainer;
    private ActivationListener fActivationListener;
    IPropertyListener fPropertyListener = null;
    int fSourcePageIndex;
    private StructuredTextEditor fTextEditor;
    private TextEditorPostSelectionAdapter fTextEditorSelectionListener;
    private ILabelProvider fStatusLineLabelProvider = new StatusLineLabelProvider();
    private PageInitializationData fPageInitializer;
    private ToolBarManager fToolbarManager;
    private ToolBarManager fEditorManager;
    private MenuManager fMenuManager;
    private boolean fAllocateToolbar = true;
    private TextInputListener fTextInputListener;

    void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    private void addSourcePage() throws PartInitException {
        this.fSourcePageIndex = this.addPage((IEditorPart)this.fTextEditor, this.getEditorInput());
        this.setPageText(this.fSourcePageIndex, XMLEditorMessages.XMLMultiPageEditorPart_0);
        this.firePropertyChange(1);
        this.fTextInputListener = new TextInputListener();
        this.fTextEditor.getTextViewer().addTextInputListener((ITextInputListener)this.fTextInputListener);
    }

    private void connectDesignPage() {
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(this.getDocument());
        }
        if (this.fDesignViewer.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.fDesignViewer.getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (XMLMultiPageEditorPart.this.getActivePage() != XMLMultiPageEditorPart.this.fSourcePageIndex) {
                        ((MultiPageSelectionProvider)XMLMultiPageEditorPart.this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
                    }
                }
            });
        }
        this.fDesignViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (XMLMultiPageEditorPart.this.getActivePage() != XMLMultiPageEditorPart.this.fSourcePageIndex) {
                    ((MultiPageSelectionProvider)XMLMultiPageEditorPart.this.getSite().getSelectionProvider()).fireSelectionChanged(event);
                }
            }
        });
        this.fDesignViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (XMLMultiPageEditorPart.this.getActivePage() != XMLMultiPageEditorPart.this.fSourcePageIndex) {
                    try {
                        XMLMultiPageEditorPart.this.updateStatusLine(event.getSelection());
                    }
                    catch (Exception exception) {
                        Logger.logException(exception);
                    }
                }
            }
        });
        this.fDesignViewer.getControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ISelection selection = XMLMultiPageEditorPart.this.fDesignViewer.getSelectionProvider().getSelection();
                int start = -1;
                int length = -1;
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object o = structuredSelection.getFirstElement();
                    Object o2 = null;
                    o2 = structuredSelection.size() > 1 ? structuredSelection.toArray()[structuredSelection.size() - 1] : o;
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o2).getEndOffset() - start;
                    } else if (o2 instanceof ITextRegion) {
                        start = ((ITextRegion)o).getStart();
                        length = ((ITextRegion)o2).getEnd() - start;
                    }
                } else if (selection instanceof ITextSelection) {
                    start = ((ITextSelection)selection).getOffset();
                    length = ((ITextSelection)selection).getLength();
                }
                if (start > -1 && length > -1) {
                    XMLMultiPageEditorPart.this.getTextEditor().selectAndReveal(start, length);
                }
            }
        });
        ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
        if (this.fTextEditorSelectionListener == null) {
            this.fTextEditorSelectionListener = new TextEditorPostSelectionAdapter();
        }
        if (provider instanceof IPostSelectionProvider) {
            this.fTextEditorSelectionListener.forcePostSelection = false;
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.fTextEditorSelectionListener);
        } else {
            this.fTextEditorSelectionListener.forcePostSelection = true;
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fTextEditorSelectionListener);
        }
    }

    private void createAndAddDesignPage() {
        IDesignViewer designViewer;
        this.fDesignViewer = designViewer = this.createDesignPage();
        this.fDesignPageIndex = this.fDesignContainer != null ? this.addPage((Control)this.fDesignContainer) : this.addPage(designViewer.getControl());
        this.setPageText(this.fDesignPageIndex, designViewer.getTitle());
    }

    protected IDesignViewer createDesignPage() {
        Composite container = this.getDesignContainer(this.getContainer());
        XMLTableTreeViewer tableTreeViewer = new XMLTableTreeViewer(container);
        tableTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        XMLUIPlugin.getInstance().getWorkbench().getHelpSystem().setHelp(tableTreeViewer.getControl(), "org.eclipse.wst.xml.ui.xmlm3000");
        if (this.fToolbarManager != null && this.fEditorManager != null) {
            this.addToolBarActions(tableTreeViewer);
            this.addEditorActions(tableTreeViewer);
        }
        return tableTreeViewer;
    }

    protected Composite getDesignContainer(Composite defaultContainer) {
        Composite container = defaultContainer;
        if (this.fAllocateToolbar) {
            container = new Composite(defaultContainer, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            container.setLayout((Layout)layout);
            Composite toolbarContainer = new Composite(container, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            layout.numColumns = 2;
            toolbarContainer.setLayout((Layout)layout);
            toolbarContainer.setLayoutData((Object)new GridData(3, 2, true, false));
            ToolBar tb = new ToolBar(toolbarContainer, 0x800000);
            this.fToolbarManager = new ToolBarManager(tb);
            tb.setLayoutData((Object)new GridData(3, 2, true, false));
            tb = new ToolBar(toolbarContainer, 0x800000);
            this.fEditorManager = new ToolBarManager(tb);
            tb.setLayoutData((Object)new GridData(3, 2, true, false));
            this.fDesignContainer = container;
        }
        return container;
    }

    private void addToolBarActions(IDesignViewer viewer) {
        if (viewer instanceof AbstractTreeViewer) {
            ViewerExpandCollapseAction expand = new ViewerExpandCollapseAction(true);
            ViewerExpandCollapseAction collapse = new ViewerExpandCollapseAction(false);
            this.fToolbarManager.add((IAction)expand);
            this.fToolbarManager.add((IAction)collapse);
            this.fToolbarManager.update(true);
            expand.setViewer((AbstractTreeViewer)viewer);
            collapse.setViewer((AbstractTreeViewer)viewer);
        }
    }

    private void addEditorActions(IDesignViewer viewer) {
        if (viewer instanceof AbstractTreeViewer) {
            final Tree tree = (Tree)((AbstractTreeViewer)viewer).getControl();
            this.fMenuManager = new MenuManager();
            this.fMenuManager.add((IAction)new Action(XMLEditorMessages.ConfigureColumns_label){

                public void run() {
                    ConfigureColumns.forTree((Tree)tree, (IShellProvider)new SameShellProvider((Control)tree));
                }
            });
            this.getSite().registerContextMenu("org.eclipse.wst.xml.ui.editor", this.fMenuManager, this.getSite().getSelectionProvider());
            this.fMenuManager.add((IContributionItem)new Separator("additions"));
            this.fEditorManager.add((IAction)new EditorActions(this.fEditorManager.getControl()));
            this.fEditorManager.update(true);
        }
    }

    protected void createPages() {
        try {
            int activePageIndex;
            this.createSourcePage();
            this.createAndAddDesignPage();
            this.addSourcePage();
            this.connectDesignPage();
            IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
            if (contributor instanceof MultiPageEditorActionBarContributor) {
                ((MultiPageEditorActionBarContributor)contributor).setActiveEditor((IEditorPart)this);
            }
            if ((activePageIndex = this.getPreferenceStore().getInt(String.valueOf(this.getEditorSite().getId()) + "." + "lastActivePage")) >= 0 && activePageIndex < this.getPageCount()) {
                this.setActivePage(activePageIndex);
            } else {
                this.setActivePage(this.fSourcePageIndex);
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
            throw new RuntimeException(e);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.fTextEditor ? new MultiPageEditorSite(this, editor){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = XMLMultiPageEditorPart.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof XMLMultiPageEditorActionBarContributor) {
                    contributor = ((XMLMultiPageEditorActionBarContributor)multiContributor).sourceViewerActionContributor;
                }
                return contributor;
            }

            public String getId() {
                return String.valueOf(ContentTypeIdForXML.ContentTypeID_XML) + ".source";
            }
        } : super.createSite(editor);
        return site;
    }

    protected void createSourcePage() throws PartInitException {
        this.fPageInitializer.sendInitializationData((IExecutableExtension)this.fTextEditor);
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
        }
        this.fTextEditor.addPropertyListener(this.fPropertyListener);
    }

    private StructuredTextEditor createTextEditor() {
        return new StructuredTextEditor();
    }

    private void disconnectDesignPage() {
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(null);
        }
    }

    public void dispose() {
        Logger.trace("Source Editor", "XMLMultiPageEditorPart::dispose entry");
        if (this.fTextInputListener != null) {
            this.fTextEditor.getTextViewer().removeTextInputListener((ITextInputListener)this.fTextInputListener);
            this.fTextInputListener = null;
        }
        this.disconnectDesignPage();
        this.fDesignViewer = null;
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        if (this.fMenuManager != null) {
            this.fMenuManager.removeAll();
            this.fMenuManager.dispose();
            this.fMenuManager = null;
        }
        if (this.fPropertyListener != null) {
            this.fTextEditor.removePropertyListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
        if (this.fEditorManager != null) {
            this.fEditorManager.dispose();
            this.fEditorManager = null;
        }
        if (this.fToolbarManager != null) {
            this.fToolbarManager.dispose();
            this.fToolbarManager = null;
        }
        super.dispose();
        this.fTextEditor = null;
        this.fPageInitializer = null;
        Logger.trace("Source Editor", "StructuredTextMultiPageEditorPart::dispose exit");
    }

    public void doSave(IProgressMonitor monitor) {
        this.fTextEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.fTextEditor.doSaveAs();
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(this.getDocument());
        }
    }

    public <T> T getAdapter(Class<T> key) {
        Object result = null;
        result = super.getAdapter(key);
        if (result == null) {
            if (key == IDesignViewer.class) {
                result = this.fDesignViewer;
            } else if (key.equals(IGotoMarker.class)) {
                result = marker -> this.gotoMarker(marker);
            } else if (this.fTextEditor != null) {
                result = this.fTextEditor.getAdapter(key);
            }
        }
        return (T)result;
    }

    private IDocument getDocument() {
        IDocumentProvider provider;
        IDocument document = null;
        if (this.fTextEditor != null && (provider = this.fTextEditor.getDocumentProvider()) != null) {
            document = provider.getDocument((Object)this.fTextEditor.getEditorInput());
        }
        return document;
    }

    private IPreferenceStore getPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    StructuredTextEditor getTextEditor() {
        return this.fTextEditor;
    }

    public String getTitle() {
        String title = null;
        if (this.getTextEditor() == null) {
            if (this.getEditorInput() != null) {
                title = this.getEditorInput().getName();
            }
        } else {
            title = this.getTextEditor().getTitle();
        }
        if (title == null) {
            title = this.getPartName();
        }
        return title;
    }

    void gotoMarker(IMarker marker) {
        this.setActivePage(this.fSourcePageIndex);
        IDE.gotoMarker((IEditorPart)this.fTextEditor, (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
            this.fTextEditor = this.createTextEditor();
            this.fTextEditor.setEditorPart((IEditorPart)this);
            this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
        }
        catch (Exception e) {
            Logger.logException("exception initializing " + ((Object)((Object)this)).getClass().getName(), e);
        }
        this.setPartName(input.getName());
    }

    public boolean isSaveAsAllowed() {
        return this.fTextEditor != null && this.fTextEditor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.fTextEditor != null) {
            return this.fTextEditor.isSaveOnCloseNeeded();
        }
        return this.isDirty();
    }

    protected final void noToolbar() {
        this.fAllocateToolbar = false;
    }

    protected void pageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        ISelectionProvider provider;
        if (newPageIndex == this.fSourcePageIndex && this.fDesignViewer != null && (provider = this.fDesignViewer.getSelectionProvider()) != null) {
            this.getTextEditor().getSelectionProvider().setSelection(provider.getSelection());
        }
        super.pageChange(newPageIndex);
        this.saveLastActivePageIndex(newPageIndex);
        if (newPageIndex == this.fDesignPageIndex && this.fDesignViewer != null && (selectionProvider = this.fDesignViewer.getSelectionProvider()) != null) {
            SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
            ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(event);
            ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
        }
    }

    private void saveLastActivePageIndex(int newPageIndex) {
        this.getPreferenceStore().setValue(String.valueOf(this.getEditorSite().getId()) + "." + "lastActivePage", newPageIndex);
    }

    public void setFocus() {
        super.setFocus();
        Control control = this.fDesignViewer.getControl();
        control.setFocus();
        control.forceFocus();
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        this.fPageInitializer = new PageInitializationData(cfig, propertyName, data);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(this.getDocument());
        }
        this.setPartName(input.getName());
    }

    void updateStatusLine(ISelection selection) {
        IStatusLineManager statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        if (this.fStatusLineLabelProvider != null && statusLineManager != null) {
            Object firstElement;
            String text = null;
            Image image = null;
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && (firstElement = ((IStructuredSelection)selection).getFirstElement()) != null) {
                text = this.fStatusLineLabelProvider.getText(firstElement);
                image = this.fStatusLineLabelProvider.getImage(firstElement);
            }
            if (image == null) {
                statusLineManager.setMessage(text);
            } else {
                statusLineManager.setMessage(image, text);
            }
        }
    }

    public INavigationLocation createEmptyNavigationLocation() {
        if (this.getActivePage() == this.fDesignPageIndex) {
            return new DesignPageNavigationLocation((IEditorPart)this, this.fDesignViewer, false);
        }
        return this.fTextEditor.createEmptyNavigationLocation();
    }

    public INavigationLocation createNavigationLocation() {
        if (this.getActivePage() == this.fDesignPageIndex) {
            return new DesignPageNavigationLocation((IEditorPart)this, this.fDesignViewer, true);
        }
        return this.fTextEditor.createNavigationLocation();
    }

    public void saveState(IMemento memento) {
        if (this.fTextEditor != null) {
            this.fTextEditor.saveState(memento);
        }
    }

    public void restoreState(IMemento memento) {
        if (this.fTextEditor != null) {
            this.fTextEditor.restoreState(memento);
        }
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private static final int MAX_NUM_CHILD_NODES_FOR_AUTO_EXPAND = 500;
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
            IDocument document;
            if (XMLMultiPageEditorPart.this.fDesignViewer instanceof AbstractTreeViewer && (document = XMLMultiPageEditorPart.this.getDocument()) != null) {
                IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                try {
                    if (model instanceof IDOMModel) {
                        IDOMDocument modelDocument = ((IDOMModel)model).getDocument();
                        NodeList rootChildren = modelDocument.getChildNodes();
                        boolean tooManyChildren = rootChildren.getLength() > 500;
                        int i = 0;
                        while (i < rootChildren.getLength() && !tooManyChildren) {
                            tooManyChildren = rootChildren.item(i).getChildNodes().getLength() > 500;
                            ++i;
                        }
                        if (!tooManyChildren) {
                            ((AbstractTreeViewer)XMLMultiPageEditorPart.this.fDesignViewer).expandToLevel(2);
                        }
                    }
                }
                finally {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                }
            }
        }

        void handleActivation() {
            if (this.fIsHandlingActivation || XMLMultiPageEditorPart.this.getTextEditor() == null) {
                return;
            }
            if (this.fActivePart == XMLMultiPageEditorPart.this) {
                this.fIsHandlingActivation = true;
                try {
                    XMLMultiPageEditorPart.this.getTextEditor().safelySanityCheckState(XMLMultiPageEditorPart.this.getEditorInput());
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == XMLMultiPageEditorPart.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(() -> this.handleActivation());
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    private class EditorActions
    extends Action {
        private ToolBar fToolbar;

        public EditorActions(ToolBar toolbar) {
            this.fToolbar = toolbar;
        }

        public ImageDescriptor getImageDescriptor() {
            return XMLEditorPluginImageHelper.getInstance().getImageDescriptor("editor.xml_tabletree.menu");
        }

        public String getToolTipText() {
            return XMLEditorMessages.EditorMenu_tooltip;
        }

        public void run() {
            Menu menu = XMLMultiPageEditorPart.this.fMenuManager.createContextMenu((Control)XMLMultiPageEditorPart.this.fDesignContainer);
            Point size = this.fToolbar.getSize();
            Point location = this.fToolbar.toDisplay(0, size.y);
            menu.setLocation(location.x, location.y);
            menu.setVisible(true);
        }
    }

    private class PageInitializationData {
        IConfigurationElement fElement;
        String fPropertyName;
        Object fData;

        PageInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
            this.fElement = cfig;
            this.fPropertyName = propertyName;
            this.fData = data;
        }

        void sendInitializationData(IExecutableExtension executableExtension) {
            if (this.fData != null) {
                try {
                    executableExtension.setInitializationData(this.fElement, this.fPropertyName, this.fData);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
    }

    class PropertyListener
    implements IPropertyListener {
        PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 258: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor() || !(XMLMultiPageEditorPart.this.fDesignViewer instanceof XMLTableTreeViewer)) break;
                    IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(XMLMultiPageEditorPart.this.getDocument());
                    try {
                        Object designInput;
                        IDOMDocument modelDocument;
                        if (!(model instanceof IDOMModel) || (modelDocument = ((IDOMModel)model).getDocument()) == (designInput = ((XMLTableTreeViewer)XMLMultiPageEditorPart.this.fDesignViewer).getInput())) break;
                        XMLMultiPageEditorPart.this.setInput(XMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                        break;
                    }
                    finally {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                    }
                }
                case 257: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor() || ((IEditorPart)source).getEditorInput() == XMLMultiPageEditorPart.this.getEditorInput()) break;
                    XMLMultiPageEditorPart.this.setInput(XMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                    ((Control)XMLMultiPageEditorPart.this.getTextEditor().getAdapter(Control.class)).getDisplay().asyncExec(() -> XMLMultiPageEditorPart.this._firePropertyChange(1));
                    break;
                }
                case 1: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor() || ((IEditorPart)source).getEditorInput() == XMLMultiPageEditorPart.this.getEditorInput()) break;
                    XMLMultiPageEditorPart.this.setInput(XMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                    break;
                }
                default: {
                    if (source != XMLMultiPageEditorPart.this.getTextEditor()) break;
                    XMLMultiPageEditorPart.this._firePropertyChange(propId);
                }
            }
        }
    }

    class StatusLineLabelProvider
    extends JFaceNodeLabelProvider {
        @Override
        public String getText(Object element) {
            if (element == null) {
                return null;
            }
            Node node = (Node)element;
            if (node.getNodeType() == 2) {
                return this.getText(((Attr)node).getOwnerElement());
            }
            StringBuilder s = new StringBuilder();
            if (node.getNodeType() != 9) {
                while (node instanceof INodeNotifier) {
                    IJFaceNodeAdapter adapter;
                    INodeNotifier notifier = (INodeNotifier)node;
                    if (node.getNodeType() != 9 && (adapter = (IJFaceNodeAdapter)notifier.getAdapterFor(IJFaceNodeAdapter.class)) != null) {
                        s.insert(0, adapter.getLabelText((Object)node));
                    }
                    if ((node = node.getParentNode()) == null || node.getNodeType() == 9) continue;
                    s.insert(0, '/');
                }
            }
            return s.toString();
        }

        @Override
        public Image getImage(Object element) {
            if (element == null) {
                return null;
            }
            Node node = (Node)element;
            if (node.getNodeType() == 2) {
                return this.getImage(((Attr)node).getOwnerElement());
            }
            return super.getImage(element);
        }
    }

    private class TextEditorPostSelectionAdapter
    extends UIJob
    implements ISelectionChangedListener {
        boolean forcePostSelection;
        ISelection selection;

        public TextEditorPostSelectionAdapter() {
            super(XMLMultiPageEditorPart.this.getTitle());
            this.forcePostSelection = false;
            this.selection = null;
            this.setUser(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.selection != null) {
                XMLMultiPageEditorPart.this.fDesignViewer.getSelectionProvider().setSelection(this.selection);
            }
            return Status.OK_STATUS;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(XMLMultiPageEditorPart.this.fDesignViewer == null || XMLMultiPageEditorPart.this.getActivePage() == XMLMultiPageEditorPart.this.fDesignPageIndex && ((Object)((Object)XMLMultiPageEditorPart.this)).equals(XMLMultiPageEditorPart.this.getSite().getPage().getActivePart()))) {
                if (this.forcePostSelection) {
                    this.selection = event.getSelection();
                    this.schedule(200L);
                } else {
                    XMLMultiPageEditorPart.this.fDesignViewer.getSelectionProvider().setSelection(event.getSelection());
                }
            }
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (XMLMultiPageEditorPart.this.fDesignViewer != null && newInput != null) {
                XMLMultiPageEditorPart.this.fDesignViewer.setDocument(newInput);
            }
        }
    }
}

