/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class PropertiesResources {
    private Map<String, Font> fonts = new HashMap<String, Font>();
    private Map<String, Color> colors = new HashMap<String, Color>();

    public Font getFont(String key) {
        return this.fonts.get(key);
    }

    public Color getColor(String key) {
        return this.colors.get(key);
    }

    public void put(String key, Font font) {
        Font oldFont = this.fonts.get(key);
        if (oldFont != null) {
            oldFont.dispose();
        }
        this.fonts.put(key, font);
    }

    public void put(String key, Color color) {
        Color oldColor = this.colors.get(key);
        if (oldColor != null) {
            oldColor.dispose();
        }
        this.colors.put(key, color);
    }

    public void removeFont(String key) {
        Font font = this.fonts.get(key);
        if (font != null) {
            this.fonts.remove(key);
            font.dispose();
        }
    }

    public void removeColor(String key) {
        Color color = this.colors.get(key);
        if (color != null) {
            this.colors.remove(key);
            color.dispose();
        }
    }

    public void dispose() {
        for (Map.Entry<String, Font> entry : this.fonts.entrySet()) {
            entry.getValue().dispose();
        }
        for (Map.Entry<String, Font> entry : this.colors.entrySet()) {
            ((Color)entry.getValue()).dispose();
        }
    }
}

