/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.ui.project.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.incubator.internal.opentracing.ui.project.handlers.SplitImportTracesOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SplitTracesHandler
extends AbstractHandler {
    private static final String TRACE_TYPE_ID = "org.eclipse.tracecompass.incubator.opentracing.core";
    private static final String DATA_KEY = "data";

    public boolean isEnabled() {
        TmfCommonProjectElement traceElem;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        Object firstElement = ((IStructuredSelection)selection).getFirstElement();
        Object object = traceElem = firstElement instanceof TmfTraceElement ? ((TmfTraceElement)firstElement).getElementUnderTraceFolder() : (TmfCommonProjectElement)firstElement;
        if (!traceElem.getTraceType().equals(TRACE_TYPE_ID)) {
            return false;
        }
        int arraySize = 0;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileReader fileReader = new FileReader(traceElem.getLocation().getPath());){
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (JsonReader reader = new JsonReader((Reader)fileReader);){
                    Gson gson = new Gson();
                    JsonObject object2 = (JsonObject)gson.fromJson(reader, JsonObject.class);
                    arraySize = object2.get(DATA_KEY).getAsJsonArray().size();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
        return arraySize > 1;
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object firstElement = ((IStructuredSelection)selection).getFirstElement();
        Object traceElem = firstElement instanceof TmfTraceElement ? ((TmfTraceElement)firstElement).getElementUnderTraceFolder() : (TmfCommonProjectElement)firstElement;
        TmfTraceFolder destinationFolder = traceElem.getProject().getTracesFolder();
        if (destinationFolder == null) {
            return null;
        }
        IPath traceElemPath = traceElem.getPath().removeFileExtension();
        String newTracesDestination = traceElemPath.makeRelativeTo(destinationFolder.getPath()).toString();
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(traceElemPath) != null) {
            String index = SplitTracesHandler.startImportConflictDialog(traceElemPath);
            if (index == null) {
                return null;
            }
            newTracesDestination = String.valueOf(newTracesDestination) + index;
        }
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileReader fileReader = new FileReader(traceElem.getLocation().getPath());){
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (JsonReader reader = new JsonReader((Reader)fileReader);){
                    Gson gson = new Gson();
                    JsonObject object = (JsonObject)gson.fromJson(reader, JsonObject.class);
                    SplitImportTracesOperation.splitAndImport(object, null, newTracesDestination, destinationFolder);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String startImportConflictDialog(IPath tracePath) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        final MessageDialog dialog = new MessageDialog(shell, "Confirmation", null, NLS.bind((String)"Folder with name {0} already exists in project. Do you want to rename, overwrite or skip?", (Object)tracePath.lastSegment()), 3, new String[]{"Rename", "Overwrite", "Skip"}, 2){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        final int[] returnValue = new int[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                returnValue[0] = dialog.open();
            }
        });
        switch (ImportConflictOptions.values()[returnValue[0]]) {
            case RENAME: {
                return SplitTracesHandler.nextIndex(tracePath);
            }
            case OVERWRITE: {
                return "";
            }
        }
        return null;
    }

    private static String nextIndex(IPath tracePath) {
        IResource existingResource = ResourcesPlugin.getWorkspace().getRoot().findMember(tracePath);
        IContainer folder = existingResource.getParent();
        int i = 2;
        while (true) {
            String index = String.valueOf('(') + Integer.toString(i) + ')';
            if (folder.findMember(String.valueOf(existingResource.getName()) + index) == null) {
                return index;
            }
            ++i;
        }
    }

    private static enum ImportConflictOptions {
        RENAME,
        OVERWRITE,
        SKIP;

    }
}

