/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractIntegerRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BigEndianAction
implements IObjectActionDelegate {
    AbstractIntegerRendering fRendering;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fRendering == null) {
            return;
        }
        if (this.fRendering.getDisplayEndianess() != 1) {
            this.fRendering.setDisplayEndianess(1);
            this.fRendering.refresh();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj == null) {
                return;
            }
            if (obj instanceof AbstractIntegerRendering) {
                this.fRendering = (AbstractIntegerRendering)obj;
            }
            int endianess = 2;
            if (this.fRendering.getDisplayEndianess() == 2) {
                MemoryByte[] selectedBytes = this.fRendering.getSelectedAsBytes();
                int i = 0;
                while (i < selectedBytes.length) {
                    if (!selectedBytes[i].isEndianessKnown()) {
                        endianess = 2;
                        break;
                    }
                    if (i == 0) {
                        endianess = selectedBytes[i].isBigEndian() ? 1 : 0;
                    } else {
                        int byteEndianess;
                        int n = byteEndianess = selectedBytes[i].isBigEndian() ? 1 : 0;
                        if (endianess != byteEndianess) {
                            endianess = 2;
                            break;
                        }
                    }
                    ++i;
                }
            } else {
                endianess = this.fRendering.getDisplayEndianess();
            }
            if (endianess == 1) {
                action.setChecked(true);
            } else {
                action.setChecked(false);
            }
        }
    }
}

