/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.vis.jfree;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.vis.jfree.ClaimScaling;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfiguration;
import org.jfree.data.Range;

public class TraceViewConfigurationIO {
    private static final String RANGE = "range";
    private static final String SHOW_CLAIMS = "showClaims";
    private static final String SHOW_EVENTS = "showEvents";
    private static final String SHOW_CLAIM_EVENTS = "showClaimEvents";
    private static final String SHOW_DEPENDENCIES = "showDependencies";
    private static final String SHOW_SIGNALS = "showSignals";
    private static final String SHOW_TIMESERIES = "showTimeSeries";
    private static final String SHOW_SIGNAL_MARKERS = "showSignalMarkers";
    private static final String SHOW_CLAIM_LABELS = "showClaimLabels";
    private static final String ACTIVITY_VIEW = "activityView";
    private static final String CLAIM_SCALING = "claimScaling";
    private static final String SORT_ALPHABETIC = "sortAlphabetic";
    private static final String GROUPING_CLAIMS = "claimGrouping";
    private static final String GROUPING_EVENTS = "eventGrouping";
    private static final String COLORING_CLAIMS = "claimColoring";
    private static final String COLORING_EVENTS = "eventColoring";
    private static final String COLORING_DEPENDENCIES = "dependencyColoring";
    private static final String COLORING_TIMESERIES = "timeSeriesColoring";
    private static final String FILTERING_CLAIMS = "claimFiltering";
    private static final String FILTERING_EVENTS = "eventFiltering";
    private static final String FILTERING_DEPENDENCIES = "dependencyFiltering";
    private static final String FILTERING_RESOURCES = "resourceFiltering";
    private static final String FILTERING_SIGNALS = "signalFiltering";
    private static final String FILTERING_TIMESERIES = "timeSeriesFiltering";
    private static final String DESCRIBING_CLAIMS = "claimDescribing";
    private static final String DESCRIBING_EVENTS = "eventDescribing";
    private static final String DESCRIBING_DEPENDENCIES = "dependencyDescribing";
    private static final String DESCRIBING_RESOURCES = "resourceDescribing";
    private static final String DESCRIBING_SIGNALS = "signalDescribing";
    private static final String DESCRIBING_TIMESERIES = "timeSeriesDescribing";

    private TraceViewConfigurationIO() {
    }

    public static void toFile(TraceViewConfiguration cfg, File out) throws IOException {
        try (BufferedWriter w = new BufferedWriter(new FileWriter(out));){
            w.write("showClaims : " + cfg.showClaims() + "\n");
            w.write("showEvents : " + cfg.showEvents() + "\n");
            w.write("showClaimEvents : " + cfg.showClaimEvents() + "\n");
            w.write("showDependencies : " + cfg.showDependencies() + "\n");
            w.write("showSignals : " + cfg.showSignals() + "\n");
            w.write("showTimeSeries : " + cfg.showTimeSeries() + "\n");
            w.write("showSignalMarkers : " + cfg.getShowSignalMarkers() + "\n");
            w.write("activityView : " + cfg.isActivityView() + "\n");
            w.write("claimScaling : " + String.valueOf((Object)cfg.getClaimScaling()) + "\n");
            w.write("sortAlphabetic : " + cfg.sortAlphabetic() + "\n");
            w.write("showClaimLabels : " + cfg.getShowClaimLabels() + "\n");
            TraceViewConfigurationIO.writeCollection(cfg, w, GROUPING_CLAIMS, cfg.getGroupingAttributes(TracePart.CLAIM));
            TraceViewConfigurationIO.writeCollection(cfg, w, GROUPING_EVENTS, cfg.getGroupingAttributes(TracePart.EVENT));
            TraceViewConfigurationIO.writeCollection(cfg, w, COLORING_CLAIMS, cfg.getColoringAttributes(TracePart.CLAIM));
            TraceViewConfigurationIO.writeCollection(cfg, w, COLORING_EVENTS, cfg.getColoringAttributes(TracePart.EVENT));
            TraceViewConfigurationIO.writeCollection(cfg, w, COLORING_DEPENDENCIES, cfg.getColoringAttributes(TracePart.DEPENDENCY));
            TraceViewConfigurationIO.writeCollection(cfg, w, COLORING_TIMESERIES, cfg.getColoringAttributes(TracePart.TIMESERIES));
            TraceViewConfigurationIO.writeCollection(cfg, w, DESCRIBING_CLAIMS, cfg.getDescribingAttributes(TracePart.CLAIM));
            TraceViewConfigurationIO.writeCollection(cfg, w, DESCRIBING_DEPENDENCIES, cfg.getDescribingAttributes(TracePart.DEPENDENCY));
            TraceViewConfigurationIO.writeCollection(cfg, w, DESCRIBING_EVENTS, cfg.getDescribingAttributes(TracePart.EVENT));
            TraceViewConfigurationIO.writeCollection(cfg, w, DESCRIBING_RESOURCES, cfg.getDescribingAttributes(TracePart.RESOURCE));
            TraceViewConfigurationIO.writeCollection(cfg, w, DESCRIBING_SIGNALS, cfg.getDescribingAttributes(TracePart.SIGNAL));
            TraceViewConfigurationIO.writeCollection(cfg, w, DESCRIBING_TIMESERIES, cfg.getDescribingAttributes(TracePart.TIMESERIES));
            TraceViewConfigurationIO.writeMap(cfg, w, FILTERING_CLAIMS, cfg.getFilters(TracePart.CLAIM));
            TraceViewConfigurationIO.writeMap(cfg, w, FILTERING_EVENTS, cfg.getFilters(TracePart.EVENT));
            TraceViewConfigurationIO.writeMap(cfg, w, FILTERING_DEPENDENCIES, cfg.getFilters(TracePart.DEPENDENCY));
            TraceViewConfigurationIO.writeMap(cfg, w, FILTERING_RESOURCES, cfg.getFilters(TracePart.RESOURCE));
            TraceViewConfigurationIO.writeMap(cfg, w, FILTERING_SIGNALS, cfg.getFilters(TracePart.SIGNAL));
            TraceViewConfigurationIO.writeMap(cfg, w, FILTERING_TIMESERIES, cfg.getFilters(TracePart.TIMESERIES));
            if (cfg.getRange() != null) {
                w.write("range : " + cfg.getRange().getLowerBound() + " ; " + cfg.getRange().getUpperBound() + "\n");
            }
        }
    }

    private static void writeCollection(TraceViewConfiguration cfg, BufferedWriter w, String key, Collection<String> atts) throws IOException {
        if (atts != null) {
            w.write(key + " : " + TraceViewConfigurationIO.toString(atts) + "\n");
        }
    }

    private static void writeMap(TraceViewConfiguration cfg, BufferedWriter w, String key, List<TraceViewConfiguration.DisjunctionFilter> filters) throws IOException {
        w.write(key + " : ");
        Iterator<TraceViewConfiguration.DisjunctionFilter> it = filters.iterator();
        while (it.hasNext()) {
            TraceViewConfiguration.DisjunctionFilter df = it.next();
            w.write(" { ");
            Iterator<TraceViewConfiguration.SimpleFilter> it2 = df.getPersistentFilters().iterator();
            while (it2.hasNext()) {
                TraceViewConfiguration.SimpleFilter sf = it2.next();
                String attName = sf.getAttName();
                Set<String> atts = sf.getIncludedValues();
                w.write(TraceViewConfigurationIO.escape(attName) + " = " + TraceViewConfigurationIO.toString(atts));
                if (!it2.hasNext()) continue;
                w.write(" ; ");
            }
            w.write(" } ");
            if (!it.hasNext()) continue;
            w.write(",");
        }
        w.write("\n");
    }

    private static String toString(Collection<String> atts) {
        StringBuilder b = new StringBuilder();
        Iterator<String> it = atts.iterator();
        while (it.hasNext()) {
            String att = it.next();
            b.append(TraceViewConfigurationIO.escape(att));
            if (!it.hasNext()) continue;
            b.append(" , ");
        }
        return b.toString();
    }

    public static TraceViewConfiguration fromFile(File in) throws TraceException, IOException {
        TraceViewConfiguration c = new TraceViewConfiguration();
        try (BufferedReader r = new BufferedReader(new FileReader(in));){
            String line = r.readLine();
            int lineNumber = 1;
            while (line != null) {
                int splitIdx = (line = line.trim()).indexOf(58);
                if (splitIdx <= 0) {
                    throw new TraceException("Syntax error in line " + lineNumber);
                }
                String key = line.substring(0, splitIdx).trim();
                String value = "";
                if (splitIdx < line.length() - 1) {
                    value = line.substring(splitIdx + 1).trim();
                }
                TraceViewConfigurationIO.processLine(c, lineNumber, key, value);
                line = r.readLine();
                ++lineNumber;
            }
            TraceViewConfiguration traceViewConfiguration = c;
            return traceViewConfiguration;
        }
    }

    private static void processLine(TraceViewConfiguration c, int lineNumber, String key, String value) throws TraceException {
        try {
            switch (key) {
                case "showClaims": {
                    c.setShowClaims(Boolean.parseBoolean(value));
                    break;
                }
                case "showEvents": {
                    c.setShowEvents(Boolean.parseBoolean(value));
                    break;
                }
                case "showClaimEvents": {
                    c.setShowClaimEvents(Boolean.parseBoolean(value));
                    break;
                }
                case "showDependencies": {
                    c.setShowDependencies(Boolean.parseBoolean(value));
                    break;
                }
                case "showSignalMarkers": {
                    c.setShowSignalMarkers(Boolean.parseBoolean(value));
                    break;
                }
                case "showSignals": {
                    c.setShowSignals(Boolean.parseBoolean(value));
                    break;
                }
                case "showTimeSeries": {
                    c.setShowTimeSeries(Boolean.parseBoolean(value));
                    break;
                }
                case "showClaimLabels": {
                    c.setShowClaimLabels(Boolean.parseBoolean(value));
                    break;
                }
                case "activityView": {
                    if (Boolean.parseBoolean(value)) {
                        c.setActivityView();
                    } else {
                        c.setResourceView();
                    }
                    break;
                }
                case "claimScaling": {
                    c.setClaimScaling(ClaimScaling.valueOf(value));
                    break;
                }
                case "sortAlphabetic": {
                    c.setSortAlphabetic(Boolean.parseBoolean(value));
                    break;
                }
                case "claimGrouping": {
                    c.setGroupingAttributes(TracePart.CLAIM, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "eventGrouping": {
                    c.setGroupingAttributes(TracePart.EVENT, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "claimColoring": {
                    c.setColoringAttributes(TracePart.CLAIM, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "eventColoring": {
                    c.setColoringAttributes(TracePart.EVENT, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "dependencyColoring": {
                    c.setColoringAttributes(TracePart.DEPENDENCY, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "timeSeriesColoring": {
                    c.setColoringAttributes(TracePart.TIMESERIES, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "claimDescribing": {
                    c.setDescribingAttributes(TracePart.CLAIM, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "dependencyDescribing": {
                    c.setDescribingAttributes(TracePart.DEPENDENCY, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "eventDescribing": {
                    c.setDescribingAttributes(TracePart.EVENT, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "resourceDescribing": {
                    c.setDescribingAttributes(TracePart.RESOURCE, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "signalDescribing": {
                    c.setDescribingAttributes(TracePart.SIGNAL, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "timeSeriesDescribing": {
                    c.setDescribingAttributes(TracePart.TIMESERIES, TraceViewConfigurationIO.fromString(value, lineNumber));
                    break;
                }
                case "claimFiltering": {
                    TraceViewConfigurationIO.parseFilter(c, TracePart.CLAIM, value, lineNumber);
                    break;
                }
                case "eventFiltering": {
                    TraceViewConfigurationIO.parseFilter(c, TracePart.EVENT, value, lineNumber);
                    break;
                }
                case "resourceFiltering": {
                    TraceViewConfigurationIO.parseFilter(c, TracePart.RESOURCE, value, lineNumber);
                    break;
                }
                case "dependencyFiltering": {
                    TraceViewConfigurationIO.parseFilter(c, TracePart.DEPENDENCY, value, lineNumber);
                    break;
                }
                case "signalFiltering": {
                    TraceViewConfigurationIO.parseFilter(c, TracePart.SIGNAL, value, lineNumber);
                    break;
                }
                case "timeSeriesFiltering": {
                    TraceViewConfigurationIO.parseFilter(c, TracePart.TIMESERIES, value, lineNumber);
                    break;
                }
                case "range": {
                    c.setRange(TraceViewConfigurationIO.parseRange(value, lineNumber));
                    break;
                }
                default: {
                    throw new TraceException("Unexpected property: " + key + " in line " + lineNumber);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new TraceException((Throwable)e);
        }
    }

    private static Range parseRange(String s, int lineNumber) throws TraceException {
        String[] tokens = s.split(";");
        if (tokens.length != 2) {
            throw new TraceException("Parse error in line " + lineNumber);
        }
        double lb = Double.parseDouble(tokens[0].trim());
        double ub = Double.parseDouble(tokens[1].trim());
        return new Range(lb, ub);
    }

    private static void parseFilter(TraceViewConfiguration cfg, TracePart part, String s, int lineNumber) throws TraceException {
        if (s.trim().length() == 0) {
            return;
        }
        boolean done = false;
        while (!done) {
            int i = TraceViewConfigurationIO.firstUnescaped(s, 0, '{');
            int j = TraceViewConfigurationIO.firstUnescaped(s, 0, '}');
            if (i < 0) {
                done = true;
                break;
            }
            if (j <= i + 1 || j >= s.length()) {
                throw new TraceException("Parse error in line " + lineNumber);
            }
            TraceViewConfiguration.DisjunctionFilter df = new TraceViewConfiguration.DisjunctionFilter();
            String simpleFilterString = s.substring(i + 1, j).trim();
            TraceViewConfigurationIO.parseSimpleFilters(df, simpleFilterString, lineNumber);
            cfg.addFilter(part, df);
            s = s.substring(j + 1);
        }
    }

    private static void parseSimpleFilters(TraceViewConfiguration.DisjunctionFilter df, String s, int lineNumber) throws TraceException {
        boolean done = false;
        while (!done) {
            String simpleFilterString;
            int idx = TraceViewConfigurationIO.firstUnescaped(s, 0, ';');
            if (idx < 0) {
                done = true;
                simpleFilterString = s;
            } else {
                simpleFilterString = s.substring(0, idx).trim();
                s = s.substring(idx + 1);
            }
            df.add(TraceViewConfigurationIO.parseSimpleFilter(simpleFilterString, lineNumber));
        }
    }

    private static TraceViewConfiguration.SimpleFilter parseSimpleFilter(String s, int lineNumber) throws TraceException {
        int i = TraceViewConfigurationIO.firstUnescaped(s, 0, '=');
        if (i <= 0 || i >= s.length() - 1) {
            throw new TraceException("Parse error in line " + lineNumber);
        }
        String attName = TraceViewConfigurationIO.unescape(s.substring(0, i).trim());
        s = s.substring(i + 1);
        List<String> includedValues = TraceViewConfigurationIO.fromString(s, lineNumber);
        return new TraceViewConfiguration.SimpleFilter(attName, includedValues);
    }

    private static List<String> fromString(String s, int lineNumber) throws TraceException {
        ArrayList<String> r = new ArrayList<String>();
        int i = 0;
        while (i < s.length()) {
            StringBuilder key = new StringBuilder();
            i = TraceViewConfigurationIO.readElement(s, i, key, lineNumber);
            r.add(key.toString().trim());
        }
        return r;
    }

    private static int readElement(String line, int i, StringBuilder b, int lineNumber) throws TraceException {
        int j = TraceViewConfigurationIO.firstUnescaped(line, i, ',');
        if (j == -1) {
            j = line.length();
        }
        if (j > i) {
            String key = TraceViewConfigurationIO.unescape(line.substring(i, j).trim());
            b.append(key.trim());
            return j + 1;
        }
        throw new TraceException("Failed to parse attribute list in line " + lineNumber);
    }

    private static int firstUnescaped(String line, int fromIndex, char c) {
        while (fromIndex < line.length()) {
            int r = line.indexOf(c, fromIndex);
            if (r >= 0) {
                if (r > 0 && line.charAt(r - 1) == '\\') {
                    fromIndex = r + 1;
                    continue;
                }
                return r;
            }
            return -1;
        }
        return -1;
    }

    private static String unescape(String str) {
        return str.replace("\\,", ",").replace("\\=", "=").replace("\\{", "{").replace("\\}", "}").replace("\\;", ";");
    }

    private static String escape(String str) {
        return str.replace(",", "\\,").replace("=", "\\=").replace("{", "\\{").replace("}", "\\}").replace(";", "\\;");
    }
}

