/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class TSRange extends AbstractTSPoints {
    private final BigDecimal start;
    private final BigDecimal step;
    private final List<Double> values;

    public TSRange(double start, double step, List<Double> values) {
        this.start = new BigDecimal(start);
        this.step = new BigDecimal(step);
        this.values = values;
    }

    @Override
    public Iterable<TimeValuePair> getData() {
        int index = 0;
        List<TimeValuePair> points = new ArrayList<>(values.size());
        for (Double val: values) {
            BigDecimal ind = new BigDecimal(index);
            BigDecimal tim = start.add(ind.multiply(step));
            points.add(new TimeValuePair(tim.doubleValue(), val.doubleValue()));
            index++;
        }
        return points;
    }

    @Override
    public int getSize() {
        return values.size();
    }

    @Override
    public Double getFirstTimeStamp() {
        return start.doubleValue();
    }

    @Override
    public Double getLastTimeStamp() {
        BigDecimal nSteps = new BigDecimal(values.size() > 0 ? values.size() - 1 : 0);
        BigDecimal last = start.add(nSteps.multiply(step));
        return last.doubleValue();
    }

    public Double getStep() {
        return step.doubleValue();
    }
}
