/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.behavior.Behavior;
import org.eclipse.trace4cps.core.IEvent;

public class BehavioralPartition
implements Iterable<List<Behavior>> {
    private final String idAtt;
    private final Set<String> uniquenessAtts;
    private final Map<Behavior, List<Behavior>> partition;

    BehavioralPartition(Iterable<IEvent> events, String idAtt, Set<String> uniquenessAtts) {
        if (!this.validateObjectId(events, idAtt)) {
            throw new IllegalArgumentException("not all events have an an attribute named " + idAtt + " with an integer value");
        }
        this.idAtt = idAtt;
        this.uniquenessAtts = uniquenessAtts;
        List<Integer> objectIds = this.getObjectIds(events);
        List<Behavior> bl = this.getSingleBehaviors(events, objectIds);
        this.partition = this.computeBehavioralPartition(bl);
    }

    public String getIdAtt() {
        return this.idAtt;
    }

    public int size() {
        return this.partition.size();
    }

    public Set<Behavior> getRepresentatives() {
        return this.partition.keySet();
    }

    @Override
    public Iterator<List<Behavior>> iterator() {
        return this.partition.values().iterator();
    }

    private Map<Behavior, List<Behavior>> computeBehavioralPartition(List<Behavior> bl) {
        HashMap<Behavior, List<Behavior>> freq = new HashMap<Behavior, List<Behavior>>();
        if (bl.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Behavior> cell = new ArrayList<Behavior>();
        Behavior first = bl.get(0);
        cell.add(first);
        freq.put(first, cell);
        int i = 1;
        while (i < bl.size()) {
            Behavior b = bl.get(i);
            boolean found = false;
            for (Map.Entry e : freq.entrySet()) {
                if (b.distanceTo((Behavior)e.getKey(), this.uniquenessAtts) != 0L) continue;
                ((List)e.getValue()).add(b);
                found = true;
                break;
            }
            if (!found) {
                cell = new ArrayList();
                cell.add(b);
                freq.put(b, cell);
            }
            ++i;
        }
        return freq;
    }

    private List<Behavior> getSingleBehaviors(Iterable<IEvent> events, List<Integer> objectIds) {
        ArrayList<Behavior> bl = new ArrayList<Behavior>();
        HashMap<Integer, Behavior> objectId2Behavior = new HashMap<Integer, Behavior>();
        int i = 0;
        while (i < objectIds.size()) {
            int theObjectId = objectIds.get(i);
            Behavior b = new Behavior(this.idAtt, theObjectId);
            bl.add(b);
            objectId2Behavior.put(theObjectId, b);
            ++i;
        }
        for (IEvent event : events) {
            Integer id = this.getId(event);
            Behavior b = (Behavior)objectId2Behavior.get(id);
            b.add(event);
        }
        return bl;
    }

    private boolean validateObjectId(Iterable<IEvent> events, String idAtt) {
        for (IEvent e : events) {
            String val = e.getAttributeValue(idAtt);
            if (val != null && BehavioralPartition.isInteger(val)) continue;
            return false;
        }
        return true;
    }

    static boolean isInteger(String val) {
        int i = 0;
        while (i < val.length()) {
            if (Character.digit(val.charAt(i), 10) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private List<Integer> getObjectIds(Iterable<IEvent> events) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (IEvent c : events) {
            Integer v = this.getId(c);
            if (v == null) continue;
            ids.add(v);
        }
        ArrayList<Integer> idList = new ArrayList<Integer>(ids.size());
        idList.addAll(ids);
        Collections.sort(idList);
        return idList;
    }

    private Integer getId(IEvent e) {
        String idString = e.getAttributeValue(this.idAtt);
        return Integer.parseInt(idString);
    }
}

