/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.views.AbstractDebugOutputView;
import org.eclipse.php.ui.util.PartListenerAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentLoader;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class DebugOutputView
extends AbstractDebugOutputView
implements ISelectionListener {
    public static final String ID_PHPDebugOutput = "org.eclipse.debug.ui.PHPDebugOutput";
    private IDebugEventSetListener fTerminateListener;
    private StructuredTextViewer fSourceViewer;
    private DebugViewPartListener fPartListener;
    private IPropertyChangeListener fPropertyChangeListener;

    public void createPartControl(Composite parent) {
        int styles = 66306;
        this.fSourceViewer = new StructuredTextViewer(parent, null, null, false, styles);
        this.fSourceViewer.setEditable(false);
        this.fSourceViewer.configure((SourceViewerConfiguration)new StructuredTextViewerConfigurationHTML());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.getSite().setSelectionProvider(this.fSourceViewer.getSelectionProvider());
        this.setBackgroundColor();
        this.fTerminateListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        Object obj = events[i].getSource();
                        if ((obj instanceof IPHPDebugTarget || obj instanceof PHPThread) && (events[i].getKind() == 8 || events[i].getKind() == 2)) {
                            final IPHPDebugTarget target = obj instanceof IPHPDebugTarget ? (IPHPDebugTarget)obj : (IPHPDebugTarget)((PHPThread)obj).getDebugTarget();
                            UIJob job = new UIJob(PHPDebugUIMessages.PHPDebugUIPlugin_1){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    DebugOutputView.this.update(target);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.fTerminateListener);
        if (this.fPartListener == null) {
            this.fPartListener = new DebugViewPartListener();
            this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        }
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener(this.fTerminateListener);
        if (this.fPartListener != null) {
            this.getSite().getPage().removePartListener((IPartListener2)this.fPartListener);
            this.fPartListener = null;
        }
        if (this.fPropertyChangeListener != null) {
            EditorsPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IPHPDebugTarget target = this.fDebugViewHelper.getSelectionElement(selection);
        this.update(target);
    }

    public void setFocus() {
    }

    @Override
    protected AbstractDebugOutputView.IUpdater createUpdater() {
        return new Updater();
    }

    private Color getBackgroundColor(IPreferenceStore store) {
        RGB color;
        String useDefault = store.getString("AbstractTextEditor.Color.Background.SystemDefault");
        Color dflt = Display.getDefault().getSystemColor(25);
        if ("true".equalsIgnoreCase(useDefault)) {
            return dflt;
        }
        String bgColor = store.getString("AbstractTextEditor.Color.Background");
        if (bgColor == null || bgColor.equals("")) {
            return dflt;
        }
        String[] rgb = bgColor.split(",");
        try {
            color = new RGB(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        catch (Throwable ex) {
            return dflt;
        }
        return new Color((Device)Display.getDefault(), color);
    }

    private void setBackgroundColor() {
        IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
        this.fSourceViewer.getTextWidget().setBackground(this.getBackgroundColor(store));
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
                    String prop = event.getProperty();
                    if (prop.equals("AbstractTextEditor.Color.Background.SystemDefault") || prop.equals("AbstractTextEditor.Color.Background")) {
                        if (DebugOutputView.this.fSourceViewer == null || DebugOutputView.this.fSourceViewer.getTextWidget() == null || DebugOutputView.this.fSourceViewer.getTextWidget().isDisposed()) {
                            return;
                        }
                        DebugOutputView.this.fSourceViewer.getTextWidget().setBackground(DebugOutputView.this.getBackgroundColor(store));
                    }
                }
            };
            store.addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    private final class DebugViewPartListener
    extends PartListenerAdapter {
        private DebugViewPartListener() {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == DebugOutputView.this) {
                IPHPDebugTarget target = DebugOutputView.this.fDebugViewHelper.getSelectionElement(null);
                DebugOutputView.this.update(target);
            }
        }
    }

    private final class Updater
    implements AbstractDebugOutputView.IUpdater {
        private int fUpdateCount;

        private Updater() {
        }

        @Override
        public void update(IPHPDebugTarget target) {
            int oldcount = this.fUpdateCount;
            HTMLDocumentLoader ss = new HTMLDocumentLoader();
            BasicStructuredDocument input = (BasicStructuredDocument)ss.createNewStructuredDocument();
            if (target != null) {
                if (target.isSuspended() || target.isTerminated() || target.isWaiting()) {
                    DebugOutput debugOutput = target.getOutputBuffer();
                    this.fUpdateCount = debugOutput.getUpdateCount();
                    if (this.fUpdateCount == oldcount) {
                        return;
                    }
                    String contentType = debugOutput.getContentType();
                    if (contentType != null && !contentType.startsWith("text")) {
                        return;
                    }
                    input.setText((Object)this, debugOutput.getOutput());
                } else {
                    return;
                }
            }
            try {
                DebugOutputView.this.fSourceViewer.setInput((Object)input);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DebugOutputView.this.fSourceViewer.refresh();
        }
    }
}

