/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;

public class TargetSourceRangeComputer {
    public SourceRange computeSourceRange(ASTNode node) {
        Program root = node.getProgramRoot();
        if (root instanceof Program) {
            Program cu = root;
            return new SourceRange(cu.getExtendedStartPosition(node), cu.getExtendedLength(node));
        }
        return new SourceRange(node.getStart(), node.getLength());
    }

    public static final class SourceRange {
        private int startPosition;
        private int length;

        public SourceRange(int startPosition, int length) {
            this.startPosition = startPosition;
            this.length = length;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getLength() {
            return this.length;
        }
    }
}

