/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class WTPToDLTKSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private ISelectionProvider parentProvider;

    public WTPToDLTKSelectionProvider(ISelectionProvider parentProvider) {
        this.parentProvider = parentProvider;
    }

    public void setSelection(ISelection selection) {
        this.parentProvider.setSelection(selection);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.transformSelection(this.parentProvider.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection sel = this.transformSelection(event.getSelection());
        SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, sel);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(newEvent);
        }
    }

    protected ISelection transformSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && selection instanceof ITextSelection) {
            selection = new TextSelection(((ITextSelection)selection).getOffset(), ((ITextSelection)selection).getLength());
            return selection;
        }
        return selection;
    }

    public void dispose() {
        this.parentProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void register() {
        this.parentProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }
}

