/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.text;

import org.eclipse.php.core.tests.TestSuiteWatcher;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class PHPTextSequenceUtilitiesTests {
    @ClassRule
    public static TestWatcher watcher = new TestSuiteWatcher();

    @Test
    public void emptyArgumentList() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"()");
        Assert.assertEquals((long)0L, (long)argNames.length);
    }

    @Test
    public void singleArgument() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"('MyArg')");
        Assert.assertEquals((long)1L, (long)argNames.length);
        Assert.assertEquals((Object)"MyArg", (Object)argNames[0]);
    }

    @Test
    public void singleArgumentDoubleQuote() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"(\"MyArg\")");
        Assert.assertEquals((long)1L, (long)argNames.length);
        Assert.assertEquals((Object)"MyArg", (Object)argNames[0]);
    }

    @Test
    public void singleArgumentIgnore() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"($anyElement)");
        Assert.assertEquals((long)1L, (long)argNames.length);
        Assert.assertNull((Object)argNames[0]);
    }

    @Test
    public void singleArgumentIgnoreParenthesis() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"'MyArg'");
        Assert.assertEquals((long)1L, (long)argNames.length);
        Assert.assertEquals((Object)"MyArg", (Object)argNames[0]);
    }

    @Test
    public void multiArgumentIgnore() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"('MyString', $anyElement)");
        Assert.assertEquals((long)2L, (long)argNames.length);
        Assert.assertEquals((Object)"MyString", (Object)argNames[0]);
        Assert.assertNull((Object)argNames[1]);
    }

    @Test
    public void multiArgumentIgnore2() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"($anyElement, 'MyString')");
        Assert.assertEquals((long)2L, (long)argNames.length);
        Assert.assertEquals((Object)"MyString", (Object)argNames[1]);
        Assert.assertNull((Object)argNames[0]);
    }

    @Test
    public void ignoreInternalCall() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"(call('something'), 'MyString')");
        Assert.assertEquals((long)2L, (long)argNames.length);
        Assert.assertEquals((Object)"MyString", (Object)argNames[1]);
        Assert.assertNull((Object)argNames[0]);
    }

    @Test
    public void nestedCall() {
        String[] argNames = PHPTextSequenceUtilities.getArgNames(null, (CharSequence)"(call('something', $this->callMe(\"Another\")), 'MyString')");
        Assert.assertEquals((long)2L, (long)argNames.length);
        Assert.assertEquals((Object)"MyString", (Object)argNames[1]);
        Assert.assertNull((Object)argNames[0]);
    }

    @Test
    public void suggestObjectOperator() {
        Assert.assertEquals((Object)">", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"$x-"));
        Assert.assertEquals((Object)">", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"$x -"));
        Assert.assertEquals((Object)"->", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"$x"));
        Assert.assertEquals((Object)"->", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"$x->field"));
        Assert.assertEquals((Object)"->", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"$x\n->call()\n"));
        Assert.assertEquals((Object)"->", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"X::$x"));
        Assert.assertEquals((Object)"->", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"$x[0]"));
    }

    @Test
    public void suggestStaticObjectOperator() {
        Assert.assertEquals((Object)":", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"X:"));
        Assert.assertEquals((Object)"::", (Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"X"));
    }

    @Test
    public void ignoreObjecOperator() {
        Assert.assertNull((Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"$x->"));
        Assert.assertNull((Object)PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)"X::"));
    }
}

