/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.model.PHPUnitSearchEngine;

public class PHPUnitValidator {
    public static final String CLASS_NAME_VALID_REGEXP = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final IType[] EMPTY_TYPES = new IType[0];

    public static String validateClassName(String className, IProject project, StatusInfo status) {
        IType[] typesByName;
        if ((className = className.trim()).length() == 0) {
            if (status != null) {
                status.setError(PHPUnitMessages.PHPUnitValidator_Empty_Class_Name);
            }
            return className;
        }
        Matcher matcher = Pattern.compile(CLASS_NAME_VALID_REGEXP).matcher(className);
        if (!matcher.matches()) {
            if (status != null) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Class_Invalid, className));
            }
            return className;
        }
        if (project != null && (typesByName = PHPUnitValidator.getTypesByName(className, project)) != null && typesByName.length > 0 && status != null) {
            status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Class_Exists, project.getName(), className));
        }
        return matcher.group();
    }

    private static IType[] getTypesByName(String className, IProject project) {
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IDLTKSearchScope searchScope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        return PHPModelAccess.getDefault().findTypes(className, ISearchEngine.MatchRule.EXACT, 0, 2056, searchScope, null);
    }

    public static IContainer validateContainer(Object container) {
        return PHPUnitValidator.validateContainer(container, false, null);
    }

    public static IContainer validateContainer(Object container, boolean validateProject) {
        return PHPUnitValidator.validateContainer(container, validateProject, null);
    }

    public static IContainer validateContainer(Object container, boolean validateProject, StatusInfo status) {
        Path containerPath;
        String containerName;
        if (container instanceof String) {
            containerName = (String)container;
        } else if (container instanceof IContainer) {
            IContainer theContainer = (IContainer)container;
            containerName = theContainer.getFullPath().toOSString();
            if (!theContainer.isAccessible() && status != null) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Not_Accessible, containerName));
            }
        } else {
            if (status != null) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Not_Folder, container));
            }
            return null;
        }
        if (containerName.length() == 0) {
            if (status != null) {
                status.setError(PHPUnitMessages.PHPUnitValidator_Folder_Name_Empty);
            }
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember((IPath)(containerPath = new Path(containerName)));
        if (resource == null) {
            if (status != null) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Folder_Not_Exists, containerName));
            }
            return null;
        }
        if (!(resource instanceof IContainer)) {
            if (status != null) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Not_Folder, containerName));
            }
            return null;
        }
        if (validateProject) {
            if (PHPUnitValidator.validateProject(resource.getProject(), status) == null) {
                return null;
            }
            resource = workspaceRoot.findMember((IPath)containerPath);
            if (resource == null || !resource.isAccessible()) {
                if (status != null) {
                    status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Folder_Not_Accessible, containerName));
                }
                return null;
            }
        }
        return (IContainer)resource;
    }

    public static IModelElement validateElement(Object element, IProject project, boolean validateProject, int elementType, StatusInfo status) {
        if (validateProject && PHPUnitValidator.validateProject(project, status) == null) {
            return null;
        }
        if (element instanceof IModelElement) {
            if (project == null) {
                return null;
            }
            IModelElement modelElement = (IModelElement)element;
            IScriptProject scriptProject = modelElement.getScriptProject();
            if (scriptProject.getProject() != project) {
                IDLTKSearchScope searchScope = SearchEngine.createSearchScope((IModelElement)scriptProject);
                IType[] foundClassElementsToTest = PHPModelAccess.getDefault().findTypes(modelElement.getElementName(), ISearchEngine.MatchRule.EXACT, 0, 8, searchScope, null);
                if (foundClassElementsToTest == null || foundClassElementsToTest.length < 1) {
                    if (status != null) {
                        status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Not_In_Project, modelElement.getElementName(), project.getName()));
                    }
                    return null;
                }
                modelElement = foundClassElementsToTest[0];
            }
            return modelElement;
        }
        if (element instanceof String) {
            if (project == null) {
                return null;
            }
            String elementName = ((String)element).trim();
            if (elementName.length() == 0) {
                if (status != null) {
                    status.setWarning(PHPUnitMessages.PHPUnitValidator_No_Element);
                }
                return null;
            }
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            IDLTKSearchScope searchScope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            Object[] foundClassElementsToTest = null;
            foundClassElementsToTest = elementType == 7 ? PHPModelAccess.getDefault().findTypes(elementName, ISearchEngine.MatchRule.EXACT, 0, 8, searchScope, null) : PHPModelAccess.getDefault().findMethods(elementName, ISearchEngine.MatchRule.PREFIX, 8192, 0, searchScope, null);
            if (foundClassElementsToTest == null || foundClassElementsToTest.length == 0) {
                if (status != null) {
                    status.setWarning(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_No_Element_In_Project, elementName, project.getName()));
                }
                return null;
            }
            if (foundClassElementsToTest.length > 1 && status != null) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Multiple_Elements, elementName, project.getName()));
                return null;
            }
            return foundClassElementsToTest[0];
        }
        if (status != null) {
            status.setWarning(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Unknown_Element, element));
        }
        return null;
    }

    public static String validateFileName(String fileName, IContainer container, StatusInfo status) {
        fileName = fileName.trim();
        if (container == null) {
            if (status != null) {
                status.setError(PHPUnitMessages.PHPUnitValidator_No_Container);
            }
            return fileName;
        }
        if (fileName.length() == 0) {
            if (status != null) {
                status.setError(PHPUnitMessages.PHPUnitValidator_No_FileName);
            }
            return fileName;
        }
        if (container.findMember((IPath)new Path(fileName)) != null) {
            if (status != null) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_File_Exists, fileName, container.getName()));
            }
            return fileName;
        }
        IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        if (!contentType.isAssociatedWith(fileName)) {
            if (status != null) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_File_Not_PHP, fileName));
            }
            return fileName;
        }
        return fileName;
    }

    public static IProject validateProject(Object project) {
        return PHPUnitValidator.validateProject(project, null);
    }

    public static IProject validateProject(Object project, StatusInfo status) {
        IProject theProject;
        block12: {
            String projectName;
            block11: {
                if (project instanceof IProject) {
                    theProject = (IProject)project;
                    projectName = theProject.getName();
                } else if (project instanceof String) {
                    projectName = (String)project;
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    theProject = workspaceRoot.getProject(projectName);
                } else {
                    if (status != null) {
                        status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Not_Project, project));
                    }
                    return null;
                }
                if (theProject.isAccessible()) break block11;
                if (status != null) {
                    status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Project_Not_Accessible, theProject.getName()));
                }
                return null;
            }
            try {
                if (!theProject.hasNature("org.eclipse.php.core.PHPNature")) {
                    if (status != null) {
                        status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Project_Not_PHP, theProject.getName()));
                    }
                    return null;
                }
            }
            catch (CoreException e) {
                if (status == null) break block12;
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_No_Project, projectName, e.getMessage()));
            }
        }
        return theProject;
    }

    public static IType[] validateTests(IType[] tests, IProject project, boolean validateProject, StatusInfo status) {
        if (validateProject && PHPUnitValidator.validateProject(project, status) == null) {
            return EMPTY_TYPES;
        }
        if (project == null) {
            return EMPTY_TYPES;
        }
        if (tests == null) {
            status.setWarning(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Folder_No_Suites, project.getName()));
            return EMPTY_TYPES;
        }
        if (tests.length == 0) {
            status.setWarning(PHPUnitMessages.PHPUnitValidator_No_Suites);
            return EMPTY_TYPES;
        }
        PHPUnitSearchEngine searchEngine = new PHPUnitSearchEngine(DLTKCore.create((IProject)project));
        int i = 0;
        while (i < tests.length) {
            IResource resource = tests[i].getResource();
            if (resource.getProject() != project) {
                if (status != null) {
                    status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Not_Exists, tests[i].getElementName(), project.getName()));
                }
                return EMPTY_TYPES;
            }
            if (!searchEngine.isTest(tests[i])) {
                status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Not_Test, tests[i].getElementName()));
                return EMPTY_TYPES;
            }
            ++i;
        }
        return tests;
    }
}

