/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.filenetwork;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.tests.filenetwork.DltkUtil;
import org.eclipse.php.core.tests.filenetwork.FileUtil;
import org.eclipse.php.core.tests.filenetwork.SuiteOfTestCases;
import org.osgi.framework.Bundle;

public abstract class AbstractModelTests
extends SuiteOfTestCases {
    protected boolean displayName = false;
    protected String endChar = ",";
    protected int tabs = 2;
    protected WorkingCopyOwner wcOwner;
    protected String fTestProjectName = "org.eclipse.dltk.core.tests";
    protected DeltaListener deltaListener = new DeltaListener();

    public AbstractModelTests(String testProjectName, String name) {
        super(name);
        this.fTestProjectName = testProjectName;
    }

    public AbstractModelTests(String testProjectName, String name, int tabs) {
        super(name);
        this.fTestProjectName = testProjectName;
        this.tabs = tabs;
    }

    public File getSourceWorkspacePath() {
        return new File(this.getPluginDirectoryPath(), "workspace");
    }

    protected File getPluginDirectoryPath() {
        try {
            Bundle bundle = Platform.getBundle((String)this.fTestProjectName);
            if (bundle == null) {
                throw new IllegalStateException(NLS.bind((String)"Bundle \"{0}\" with test data not found", (Object)this.fTestProjectName));
            }
            URL platformURL = bundle.getEntry("/");
            return new File(FileLocator.toFileURL((URL)platformURL).getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void copyDirectory(File source, File target) throws IOException {
        FileUtil.copyDirectory(source, target);
    }

    public static void copy(File src, File dest) throws IOException {
        FileUtil.copyFile(src, dest);
    }

    public IProject setUpProject(String projectName) throws CoreException, IOException {
        return this.setUpProjectTo(projectName, projectName);
    }

    protected IScriptProject setUpScriptProjectTo(String projectName, String fromName) throws CoreException, IOException {
        IProject project = this.setUpProjectTo(projectName, fromName);
        return DLTKCore.create((IProject)project);
    }

    protected IProject setUpProjectTo(String projectName, String fromName) throws CoreException, IOException {
        File sourceWorkspacePath = this.getSourceWorkspacePath();
        File targetWorkspacePath = AbstractModelTests.getWorkspaceRoot().getLocation().toFile();
        File source = new File(sourceWorkspacePath, fromName);
        if (!source.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)"Source directory \"{0}\" doesn't exist", (Object)source));
        }
        this.copyDirectory(source, new File(targetWorkspacePath, projectName));
        return this.createProject(projectName);
    }

    protected IScriptProject setUpScriptProject(String projectName) throws CoreException, IOException {
        IProject project = this.setUpProject(projectName);
        return DLTKCore.create((IProject)project);
    }

    public ISourceModule getSourceModule(String projectName, String rootPath, IPath path) throws ModelException {
        IScriptFolder folder = this.getScriptFolder(projectName, rootPath, path.removeLastSegments(1));
        if (folder == null) {
            return null;
        }
        return folder.getSourceModule(path.lastSegment());
    }

    public ISourceModule getSourceModule(String projectName, String rootPath, String path) throws ModelException {
        IScriptFolder folder = this.getScriptFolder(projectName, rootPath, new Path(path).removeLastSegments(1));
        if (folder == null) {
            return null;
        }
        return folder.getSourceModule(new Path(path).lastSegment().toString());
    }

    public IScriptFolder getScriptFolder(String projectName, String fragmentPath, IPath path) throws ModelException {
        IProjectFragment root = this.getProjectFragment(projectName, fragmentPath);
        if (root == null) {
            return null;
        }
        return root.getScriptFolder(path);
    }

    public IProjectFragment getProjectFragment(String projectName, String fragmentPath) throws ModelException {
        IScriptProject project = this.getScriptProject(projectName);
        if (project == null) {
            return null;
        }
        Path path = new Path(fragmentPath);
        if (path.isAbsolute()) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = workspaceRoot.findMember((IPath)path);
            IProjectFragment root = project.getProjectFragment(resource);
            return root;
        }
        IProjectFragment[] roots = project.getProjectFragments();
        if (roots == null || roots.length == 0) {
            return null;
        }
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            if (root.getUnderlyingResource().getProjectRelativePath().equals((Object)path)) {
                return root;
            }
            ++i;
        }
        return null;
    }

    public IScriptProject getScriptProject(String name) {
        IProject project = AbstractModelTests.getProject(name);
        return DLTKCore.create((IProject)project);
    }

    protected void discardWorkingCopies(ISourceModule[] units) throws ModelException {
        if (units == null) {
            return;
        }
        int i = 0;
        int length = units.length;
        while (i < length) {
            if (units[i] != null) {
                units[i].discardWorkingCopy();
            }
            ++i;
        }
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
    }

    @Override
    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    protected ISourceModule getSourceModule(String path) {
        return (ISourceModule)DLTKCore.create((IFile)this.getFile(path));
    }

    protected IFile getFile(String path) {
        return AbstractModelTests.getWorkspaceRoot().getFile((IPath)new Path(path));
    }

    protected IFolder getFolder(IPath path) {
        return AbstractModelTests.getWorkspaceRoot().getFolder(path);
    }

    protected void deleteFolder(IPath folderPath) throws CoreException {
        AbstractModelTests.deleteResource((IResource)this.getFolder(folderPath));
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return AbstractModelTests.getWorkspace().getRoot();
    }

    public static IProject getProject(String project) {
        return AbstractModelTests.getWorkspaceRoot().getProject(project);
    }

    protected IProject createProject(String projectName) throws CoreException {
        final IProject project = AbstractModelTests.getProject(projectName);
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(null);
                project.open(null);
            }
        };
        AbstractModelTests.getWorkspace().run(create, null);
        return project;
    }

    protected IScriptProject createScriptProject(String projectName, String[] natures, String[] sourceFolders) throws CoreException {
        return this.createScriptProject(projectName, natures, sourceFolders, null);
    }

    protected IScriptProject createScriptProject(String projectName, String[] natures, String[] sourceFolders, String[] projects) throws CoreException {
        return this.createScriptProject(projectName, natures, sourceFolders, projects, null);
    }

    protected IScriptProject createScriptProject(final String projectName, final String[] natures, final String[] sourceFolders, final String[] projects, final String[] containers) throws CoreException {
        final IScriptProject[] result = new IScriptProject[1];
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AbstractModelTests.this.createProject(projectName);
                IProject project = AbstractModelTests.getWorkspaceRoot().getProject(projectName);
                IProjectDescription description = project.getDescription();
                description.setNatureIds(natures);
                project.setDescription(description, null);
                IPath projectPath = project.getFullPath();
                int sourceLength = sourceFolders == null ? 0 : sourceFolders.length;
                int containersLength = containers == null ? 0 : containers.length;
                int projectLength = projects == null ? 0 : projects.length;
                IBuildpathEntry[] entries = new IBuildpathEntry[sourceLength + projectLength + containersLength];
                int i = 0;
                while (i < sourceLength) {
                    Path sourcePath = new Path(sourceFolders[i]);
                    int segmentCount = sourcePath.segmentCount();
                    if (segmentCount > 0) {
                        IProject container = project;
                        int j = 0;
                        while (j < segmentCount) {
                            IFolder folder = container.getFolder((IPath)new Path(sourcePath.segment(j)));
                            if (!folder.exists()) {
                                folder.create(true, true, null);
                            }
                            container = folder;
                            ++j;
                        }
                    }
                    entries[i] = DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)sourcePath));
                    ++i;
                }
                i = 0;
                while (i < projectLength) {
                    IPath[] accessibleFiles = new IPath[]{};
                    IPath[] nonAccessibleFiles = new IPath[]{};
                    entries[sourceLength + i] = DLTKCore.newProjectEntry((IPath)new Path(projects[i]), (IAccessRule[])BuildpathEntry.getAccessRules((IPath[])accessibleFiles, (IPath[])nonAccessibleFiles), (boolean)true, (IBuildpathAttribute[])new IBuildpathAttribute[0], (boolean)false);
                    ++i;
                }
                i = 0;
                while (i < containersLength) {
                    entries[sourceLength + projectLength + i] = DLTKCore.newContainerEntry((IPath)new Path(containers[i]));
                    ++i;
                }
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                scriptProject.setRawBuildpath(entries, null);
                result[0] = scriptProject;
            }
        };
        AbstractModelTests.getWorkspace().run(create, null);
        return result[0];
    }

    protected void assertSourceEquals(String message, String expected, String actual) {
        if (actual == null) {
            AbstractModelTests.assertEquals((String)message, (String)expected, null);
            return;
        }
        if (!(actual = DltkUtil.convertToIndependantLineDelimiter(actual)).equals(expected)) {
            System.out.print(DltkUtil.displayString(actual.toString(), 2));
            System.out.println(this.endChar);
        }
        AbstractModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    public static void deleteResource(IResource resource) throws CoreException {
        CoreException lastException = null;
        try {
            resource.delete(true, null);
        }
        catch (CoreException e) {
            lastException = e;
            System.out.println(e.getMessage());
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        int retryCount = 60;
        while (resource.isAccessible() && --retryCount >= 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                lastException = e;
                System.out.println("Retry " + retryCount + ": " + e.getMessage());
            }
            catch (IllegalArgumentException iae) {
                System.out.println("Retry " + retryCount + ": " + iae.getMessage());
            }
        }
        if (!resource.isAccessible()) {
            return;
        }
        System.err.println("Failed to delete " + resource.getFullPath());
        if (lastException != null) {
            throw lastException;
        }
    }

    protected IFolder createFolder(IPath path) throws CoreException {
        final IFolder folder = AbstractModelTests.getWorkspaceRoot().getFolder(path);
        AbstractModelTests.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IContainer parent = folder.getParent();
                if (parent instanceof IFolder && !parent.exists()) {
                    AbstractModelTests.this.createFolder(parent.getFullPath());
                }
                folder.create(true, true, null);
            }
        }, null);
        return folder;
    }

    public void deleteProject(String projectName) throws CoreException {
        IProject project = AbstractModelTests.getProject(projectName);
        if (project.exists() && !project.isOpen()) {
            project.open(null);
        }
        AbstractModelTests.deleteResource((IResource)project);
    }

    protected void deleteProjects(final String ... projectNames) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (projectNames != null) {
                    int i = 0;
                    int max = projectNames.length;
                    while (i < max) {
                        if (projectNames[i] != null) {
                            AbstractModelTests.this.deleteProject(projectNames[i]);
                        }
                        ++i;
                    }
                }
            }
        }, null);
    }

    public void startDeltas() {
        this.clearDeltas();
        DLTKCore.addElementChangedListener((IElementChangedListener)this.deltaListener);
    }

    public void stopDeltas() {
        DLTKCore.removeElementChangedListener((IElementChangedListener)this.deltaListener);
        this.clearDeltas();
    }

    public void clearDeltas() {
        this.deltaListener.deltas = new IModelElementDelta[0];
    }

    protected void sortElements(IModelElement[] elements) {
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object a, Object b) {
                ModelElement elementA = (ModelElement)a;
                ModelElement elementB = (ModelElement)b;
                return elementA.toStringWithAncestors().compareTo(elementB.toStringWithAncestors().toString());
            }
        };
        Util.sort((Object[])elements, (Util.Comparer)comparer);
    }

    protected void assertSortedElementsEqual(String message, String expected, IModelElement[] elements) {
        this.sortElements(elements);
        this.assertElementsEqual(message, expected, elements);
    }

    protected void assertElementsEqual(String message, String expected, IModelElement[] elements) {
        this.assertElementsEqual(message, expected, elements, false);
    }

    protected void assertElementsEqual(String message, String expected, IModelElement[] elements, boolean showResolvedInfo) {
        StringBuilder buffer = new StringBuilder();
        if (elements != null) {
            int i = 0;
            int length = elements.length;
            while (i < length) {
                ModelElement element = (ModelElement)elements[i];
                if (element == null) {
                    buffer.append("<null>");
                } else {
                    buffer.append(element.toStringWithAncestors(showResolvedInfo));
                }
                if (i != length - 1) {
                    buffer.append("\n");
                }
                ++i;
            }
        } else {
            buffer.append("<null>");
        }
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            if (this.displayName) {
                System.out.println(String.valueOf(this.getName()) + " actual result is:");
            }
            System.out.println(String.valueOf(DltkUtil.displayString(actual, this.tabs)) + this.endChar);
        }
        AbstractModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void sortResources(Object[] resources) {
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object a, Object b) {
                IResource resourceA = (IResource)a;
                IResource resourceB = (IResource)b;
                return resourceA.getFullPath().toString().compareTo(resourceB.getFullPath().toString());
            }
        };
        Util.sort((Object[])resources, (Util.Comparer)comparer);
    }

    protected void assertResourceNamesEqual(String message, String expected, Object[] resources) {
        this.sortResources(resources);
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int length = resources.length;
        while (i < length) {
            IResource resource = (IResource)resources[i];
            buffer.append(resource == null ? "<null>" : resource.getName());
            if (i != length - 1) {
                buffer.append("\n");
            }
            ++i;
        }
        if (!expected.equals(buffer.toString())) {
            System.out.print(DltkUtil.displayString(buffer.toString(), 2));
            System.out.println(this.endChar);
        }
        AbstractModelTests.assertEquals((String)message, (String)expected, (String)buffer.toString());
    }

    protected void assertDeltas(String message, String expected) {
        String actual = this.deltaListener.toString();
        if (!expected.equals(actual)) {
            System.out.println(actual);
        }
        AbstractModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertDeltas(String message, String expected, IModelElementDelta delta) {
        String actual;
        String string = actual = delta == null ? "<null>" : delta.toString();
        if (!expected.equals(actual)) {
            System.out.println(actual);
        }
        AbstractModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertMarkers(String message, String expectedMarkers, IScriptProject project) throws CoreException {
        IMarker[] markers = project.getProject().findMarkers("org.eclipse.dltk.core.buildpath_problem", false, 0);
        this.sortMarkers(markers);
        this.assertMarkers(message, expectedMarkers, markers);
    }

    protected void assertMarkers(String message, String expectedMarkers, IMarker[] markers) throws CoreException {
        String actual;
        StringBuilder buffer = new StringBuilder();
        if (markers != null) {
            int i = 0;
            int length = markers.length;
            while (i < length) {
                IMarker marker = markers[i];
                buffer.append(marker.getAttribute("message"));
                if (i != length - 1) {
                    buffer.append("\n");
                }
                ++i;
            }
        }
        if (!expectedMarkers.equals(actual = buffer.toString())) {
            System.out.println(DltkUtil.displayString(actual, 2));
        }
        AbstractModelTests.assertEquals((String)message, (String)expectedMarkers, (String)actual);
    }

    protected void sortMarkers(IMarker[] markers) {
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object a, Object b) {
                IMarker markerA = (IMarker)a;
                IMarker markerB = (IMarker)b;
                return markerA.getAttribute("message", "").compareTo(markerB.getAttribute("message", ""));
            }
        };
        Util.sort((Object[])markers, (Util.Comparer)comparer);
    }

    public void setBuildpath(IScriptProject scriptProject, IBuildpathEntry[] buildpath) {
        try {
            scriptProject.setRawBuildpath(buildpath, null);
        }
        catch (ModelException e) {
            AbstractModelTests.assertTrue((String)"failed to set buildpath", (boolean)false);
        }
    }

    protected IModelElementDelta getDeltaFor(IModelElement element) {
        return this.getDeltaFor(element, false);
    }

    protected IModelElementDelta getDeltaFor(IModelElement element, boolean returnFirst) {
        IModelElementDelta[] deltas = this.deltaListener.deltas;
        if (deltas == null) {
            return null;
        }
        IModelElementDelta result = null;
        int i = 0;
        while (i < deltas.length) {
            IModelElementDelta delta = this.searchForDelta(element, this.deltaListener.deltas[i]);
            if (delta != null) {
                if (returnFirst) {
                    return delta;
                }
                result = delta;
            }
            ++i;
        }
        return result;
    }

    protected IModelElementDelta searchForDelta(IModelElement element, IModelElementDelta delta) {
        if (delta == null) {
            return null;
        }
        if (delta.getElement().equals(element)) {
            return delta;
        }
        int i = 0;
        while (i < delta.getAffectedChildren().length) {
            IModelElementDelta child = this.searchForDelta(element, delta.getAffectedChildren()[i]);
            if (child != null) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public void assertCreation(IModelElement[] newElements) {
        int i = 0;
        while (i < newElements.length) {
            IModelElement newElement = newElements[i];
            AbstractModelTests.assertTrue((String)"Element should be present after creation", (boolean)newElement.exists());
            ++i;
        }
    }

    public void assertCreation(IModelElement newElement) {
        this.assertCreation(new IModelElement[]{newElement});
    }

    public void assertDeletion(IModelElement[] elementsToDelete) throws ModelException {
        IModelElement elementToDelete = null;
        int i = 0;
        while (i < elementsToDelete.length) {
            elementToDelete = elementsToDelete[i];
            AbstractModelTests.assertTrue((String)"Element must be present to be deleted", (boolean)elementToDelete.exists());
            ++i;
        }
        this.getScriptModel().delete(elementsToDelete, false, null);
        i = 0;
        while (i < elementsToDelete.length) {
            elementToDelete = elementsToDelete[i];
            AbstractModelTests.assertTrue((String)("Element should not be present after deletion: " + elementToDelete), (!elementToDelete.exists() ? 1 : 0) != 0);
            ++i;
        }
    }

    public IScriptModel getScriptModel() {
        return DLTKCore.create((IWorkspaceRoot)AbstractModelTests.getWorkspaceRoot());
    }

    public void ensureCorrectPositioning(IParent container, IModelElement sibling, IModelElement positioned) throws ModelException {
        IModelElement[] children = container.getChildren();
        if (sibling != null) {
            boolean found = false;
            int i = 0;
            while (i < children.length) {
                if (children[i].equals(sibling)) {
                    AbstractModelTests.assertTrue((String)"element should be before sibling", (i > 0 && children[i - 1].equals(positioned) ? 1 : 0) != 0);
                    found = true;
                    break;
                }
                ++i;
            }
            AbstractModelTests.assertTrue((String)"Did not find sibling", (boolean)found);
        }
    }

    public ISourceModule getWorkingCopy(String path, boolean computeProblems) throws ModelException {
        return this.getWorkingCopy(path, "", computeProblems);
    }

    public ISourceModule getWorkingCopy(String path, String source) throws ModelException {
        return this.getWorkingCopy(path, source, false);
    }

    public ISourceModule getWorkingCopy(String path, String source, boolean computeProblems) throws ModelException {
        if (this.wcOwner == null) {
            this.wcOwner = new WorkingCopyOwner(){};
        }
        return this.getWorkingCopy(path, source, this.wcOwner, computeProblems);
    }

    public ISourceModule getWorkingCopy(String path, String source, WorkingCopyOwner owner, boolean computeProblems) throws ModelException {
        IProblemRequestor problemRequestor = computeProblems ? new IProblemRequestor(){

            public void acceptProblem(IProblem problem) {
            }

            public void beginReporting() {
            }

            public void endReporting() {
            }

            public boolean isActive() {
                return true;
            }
        } : null;
        return this.getWorkingCopy(path, source, owner, problemRequestor);
    }

    public ISourceModule getWorkingCopy(String path, String source, WorkingCopyOwner owner, IProblemRequestor problemRequestor) throws ModelException {
        ISourceModule workingCopy = this.getSourceModule(path);
        if (owner != null) {
            workingCopy = workingCopy.getWorkingCopy(null);
        } else {
            workingCopy.becomeWorkingCopy(problemRequestor, null);
        }
        workingCopy.getBuffer().setContents(source);
        workingCopy.makeConsistent(null);
        return workingCopy;
    }

    public static void storeFile(File dest, URL url) throws IOException {
        BufferedInputStream input = null;
        OutputStream output = null;
        try {
            input = new BufferedInputStream(url.openStream());
            output = new BufferedOutputStream(new FileOutputStream(dest));
            int ch = -1;
            while ((ch = ((InputStream)input).read()) != -1) {
                output.write(ch);
            }
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static File storeToMetadata(Bundle bundle, String name, String path) throws IOException {
        File pathFile = DLTKCore.getDefault().getStateLocation().append(name).toFile();
        AbstractModelTests.storeFile(pathFile, FileLocator.resolve((URL)bundle.getEntry(path)));
        return pathFile;
    }

    class DeltaListener
    implements IElementChangedListener {
        IModelElementDelta[] deltas;

        DeltaListener() {
        }

        public void elementChanged(ElementChangedEvent ev) {
            IModelElementDelta[] copy = new IModelElementDelta[this.deltas.length + 1];
            System.arraycopy(this.deltas, 0, copy, 0, this.deltas.length);
            copy[this.deltas.length] = ev.getDelta();
            this.deltas = copy;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            int length = this.deltas.length;
            while (i < length) {
                int resourceDeltasLength;
                IModelElementDelta delta = this.deltas[i];
                IModelElementDelta[] children = delta.getAffectedChildren();
                int childrenLength = children.length;
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                int n = resourceDeltasLength = resourceDeltas == null ? 0 : resourceDeltas.length;
                if (childrenLength == 0 && resourceDeltasLength == 0) {
                    buffer.append(delta);
                } else {
                    this.sortDeltas(children);
                    int j = 0;
                    while (j < childrenLength) {
                        buffer.append(children[j]);
                        if (j != childrenLength - 1) {
                            buffer.append("\n");
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < resourceDeltasLength) {
                        if (j == 0 && buffer.length() != 0) {
                            buffer.append("\n");
                        }
                        buffer.append(resourceDeltas[j]);
                        if (j != resourceDeltasLength - 1) {
                            buffer.append("\n");
                        }
                        ++j;
                    }
                }
                if (i != length - 1) {
                    buffer.append("\n\n");
                }
                ++i;
            }
            return buffer.toString();
        }

        protected void sortDeltas(IModelElementDelta[] elementDeltas) {
            Util.Comparer comparer = new Util.Comparer(){

                public int compare(Object a, Object b) {
                    IModelElementDelta deltaA = (IModelElementDelta)a;
                    IModelElementDelta deltaB = (IModelElementDelta)b;
                    return deltaA.getElement().getElementName().compareTo(deltaB.getElement().getElementName());
                }
            };
            Util.sort((Object[])elementDeltas, (Util.Comparer)comparer);
        }
    }
}

