/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.astview.views;

import java.util.ArrayList;
import org.eclipse.php.astview.views.ASTAttribute;
import org.eclipse.php.astview.views.BindingProperty;
import org.eclipse.php.astview.views.Error;
import org.eclipse.php.astview.views.GeneralAttribute;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.swt.graphics.Image;

public class Binding
extends ASTAttribute {
    private final IBinding fBinding;
    private final String fLabel;
    private final Object fParent;
    private final boolean fIsRelevant;
    private static final int ARRAY_TYPE = 1;
    private static final int NULL_TYPE = 2;
    private static final int CLASS_TYPE = 4;
    private static final int INTERFACE_TYPE = 8;
    private static final int AMBIGOUS_TYPE = 16;
    private static final int PRIMITIVE_TYPE = 32;
    private static final int SYNTHETIC_TYPE = 64;
    private static final int GENERIC = 256;
    private static final int UNKNOWN_TYPE = 512;

    public Binding(Object parent, String label, IBinding binding, boolean isRelevant) {
        this.fParent = parent;
        this.fBinding = binding;
        this.fLabel = label;
        this.fIsRelevant = isRelevant;
    }

    @Override
    public Object getParent() {
        return this.fParent;
    }

    public IBinding getBinding() {
        return this.fBinding;
    }

    public boolean hasBindingProperties() {
        return this.fBinding != null;
    }

    public boolean isRelevant() {
        return this.fIsRelevant;
    }

    private static boolean isType(int typeKinds, int kind) {
        return (typeKinds & kind) != 0;
    }

    @Override
    public Object[] getChildren() {
        if (this.fBinding != null) {
            ArrayList<ASTAttribute> res = new ArrayList<ASTAttribute>();
            res.add(new BindingProperty(this, "NAME", this.fBinding.getName(), true));
            res.add(new BindingProperty(this, "KEY", this.fBinding.getKey(), true));
            switch (this.fBinding.getKind()) {
                case 3: {
                    IVariableBinding variableBinding = (IVariableBinding)this.fBinding;
                    res.add(new BindingProperty(this, "IS FIELD", variableBinding.isField(), true));
                    res.add(new BindingProperty(this, "IS PARAMETER", variableBinding.isParameter(), true));
                    res.add(new BindingProperty(this, "VARIABLE ID", variableBinding.getVariableId(), true));
                    res.add(new Binding(this, "TYPE", (IBinding)variableBinding.getType(), true));
                    res.add(new Binding(this, "DECLARING CLASS", (IBinding)variableBinding.getDeclaringClass(), true));
                    Object constVal = variableBinding.getConstantValue();
                    res.add(new BindingProperty(this, "CONSTANT VALUE", constVal == null ? "null" : constVal.toString(), true));
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ITypeBinding typeBinding = (ITypeBinding)this.fBinding;
                    int typeKind = this.getTypeKind(typeBinding);
                    boolean isRefType = true;
                    StringBuilder kinds = new StringBuilder("KIND:");
                    if (typeBinding.isArray()) {
                        kinds.append(" isArray");
                    }
                    if (typeBinding.isNullType()) {
                        kinds.append(" isNullType");
                    }
                    if (typeBinding.isPrimitive()) {
                        kinds.append(" isPrimitive");
                    }
                    if (typeBinding.isClass()) {
                        kinds.append(" isClass");
                    }
                    if (typeBinding.isInterface()) {
                        kinds.append(" isInterface");
                    }
                    res.add(new BindingProperty(this, kinds, true));
                    res.add(new Binding(this, "ELEMENT TYPE", (IBinding)typeBinding.getElementType(), Binding.isType(typeKind, 1)));
                    res.add(new Binding(this, "COMPONENT TYPE", (IBinding)typeBinding.getComponentType(), Binding.isType(typeKind, 1)));
                    res.add(new BindingProperty(this, "DIMENSIONS", typeBinding.getDimensions(), Binding.isType(typeKind, 1)));
                    String createArrayTypeLabel = "CREATE ARRAY TYPE (+1)";
                    try {
                        ITypeBinding arrayType = typeBinding.createArrayType(1);
                        res.add(new Binding(this, "CREATE ARRAY TYPE (+1)", (IBinding)arrayType, true));
                    }
                    catch (RuntimeException e) {
                        String msg = String.valueOf(e.getClass().getName()) + ": " + e.getLocalizedMessage();
                        boolean isRelevant = true;
                        if (isRelevant) {
                            res.add(new Error(this, "CREATE ARRAY TYPE (+1): " + msg, e));
                        }
                        res.add(new BindingProperty(this, "CREATE ARRAY TYPE (+1)", msg, false));
                    }
                    res.add(new BindingProperty(this, "BINARY NAME", typeBinding.getBinaryName(), true));
                    res.add(new Binding(this, "SUPERCLASS", (IBinding)typeBinding.getSuperclass(), isRefType));
                    res.add(new BindingProperty(this, "INTERFACES", (IBinding[])typeBinding.getInterfaces(), isRefType));
                    res.add(new BindingProperty(this, "DECLARED FIELDS", (IBinding[])typeBinding.getDeclaredFields(), isRefType));
                    res.add(new BindingProperty(this, "DECLARED METHODS", (IBinding[])typeBinding.getDeclaredMethods(), isRefType));
                    break;
                }
                case 4: {
                    IMethodBinding methodBinding = (IMethodBinding)this.fBinding;
                    res.add(new BindingProperty(this, "IS CONSTRUCTOR", methodBinding.isConstructor(), true));
                    res.add(new Binding(this, "DECLARING CLASS", (IBinding)methodBinding.getDeclaringClass(), true));
                    res.add(new BindingProperty(this, "IS VARARGS", methodBinding.isVarargs(), true));
                    res.add(new BindingProperty(this, "EXCEPTION TYPES", (IBinding[])methodBinding.getExceptionTypes(), true));
                }
            }
            return res.toArray();
        }
        return EMPTY;
    }

    private int getTypeKind(ITypeBinding typeBinding) {
        if (typeBinding.isArray()) {
            return 1;
        }
        if (typeBinding.isNullType()) {
            return 2;
        }
        if (typeBinding.isPrimitive()) {
            return 32;
        }
        if (typeBinding.isAmbiguous()) {
            return 16;
        }
        if (typeBinding.isClass()) {
            return 4;
        }
        if (typeBinding.isInterface()) {
            return 8;
        }
        if (typeBinding.isUnknown()) {
            return 512;
        }
        return 512;
    }

    @Override
    public String getLabel() {
        StringBuilder buf = new StringBuilder(this.fLabel);
        buf.append(": ");
        if (this.fBinding != null) {
            switch (this.fBinding.getKind()) {
                case 3: {
                    IVariableBinding variableBinding = (IVariableBinding)this.fBinding;
                    if (!variableBinding.isField()) {
                        buf.append(variableBinding.getName());
                        break;
                    }
                    if (variableBinding.getDeclaringClass() == null) {
                        buf.append("array type");
                        break;
                    }
                    buf.append(variableBinding.getDeclaringClass().getName());
                    buf.append('.');
                    buf.append(variableBinding.getName());
                    break;
                }
                case 2: {
                    ITypeBinding typeBinding = (ITypeBinding)this.fBinding;
                    buf.append(typeBinding.getName());
                    break;
                }
                case 4: {
                    IMethodBinding methodBinding = (IMethodBinding)this.fBinding;
                    buf.append(methodBinding.getDeclaringClass().getName());
                    buf.append('.');
                    buf.append(methodBinding.getName());
                    buf.append('(');
                    buf.delete(buf.length() - 2, buf.length() - 1);
                    buf.append(')');
                }
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    @Override
    public Image getImage() {
        return null;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Binding other = (Binding)obj;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        return !(this.fBinding == null ? other.fBinding != null : !this.fBinding.equals((Object)other.fBinding));
    }

    public int hashCode() {
        int result = this.fParent != null ? this.fParent.hashCode() : 0;
        return result += this.fBinding != null && this.fBinding.getKey() != null ? this.fBinding.getKey().hashCode() : 0;
    }

    public static String getBindingLabel(IBinding binding) {
        String label;
        if (binding == null) {
            label = ">binding";
        } else {
            switch (binding.getKind()) {
                case 3: {
                    label = "> variable binding";
                    break;
                }
                case 2: {
                    label = "> type binding";
                    break;
                }
                case 4: {
                    label = "> method binding";
                    break;
                }
                case 1: {
                    label = "> package binding";
                    break;
                }
                case 5: {
                    label = "> annotation binding";
                    break;
                }
                case 6: {
                    label = "> member value pair binding";
                    break;
                }
                default: {
                    label = "> unknown binding";
                }
            }
        }
        return label;
    }

    public static ASTAttribute createValueAttribute(ASTAttribute parent, String name, Object value) {
        ASTAttribute res;
        if (value instanceof IBinding) {
            IBinding binding = (IBinding)value;
            res = new Binding(parent, String.valueOf(name) + ": " + Binding.getBindingLabel(binding), binding, true);
        } else {
            res = value instanceof String ? new GeneralAttribute((Object)parent, name, "\"" + (String)value + "\"") : (value instanceof Object[] ? new GeneralAttribute((Object)parent, name, (Object[])value) : (value instanceof ASTAttribute ? (ASTAttribute)value : new GeneralAttribute((Object)parent, name, value)));
        }
        return res;
    }
}

