/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.model.commands;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.Transition;

public class ReconnectSourceCommand
extends Command {
    protected Activity source;
    protected Activity target;
    protected Transition transition;
    protected Activity oldSource;

    public boolean canExecute() {
        if (this.transition.target.equals(this.source)) {
            return false;
        }
        List transitions = this.source.getOutgoingTransitions();
        int i = 0;
        while (i < transitions.size()) {
            Transition trans = (Transition)transitions.get(i);
            if (trans.target.equals(this.target) && !trans.source.equals(this.oldSource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void execute() {
        if (this.source != null) {
            this.oldSource.removeOutput(this.transition);
            this.transition.source = this.source;
            this.source.addOutput(this.transition);
        }
    }

    public Activity getSource() {
        return this.source;
    }

    public Activity getTarget() {
        return this.target;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void setSource(Activity activity) {
        this.source = activity;
    }

    public void setTarget(Activity activity) {
        this.target = activity;
    }

    public void setTransition(Transition trans) {
        this.transition = trans;
        this.target = trans.target;
        this.oldSource = trans.source;
    }

    public void undo() {
        this.source.removeOutput(this.transition);
        this.transition.source = this.oldSource;
        this.oldSource.addOutput(this.transition);
    }
}

