/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.examples.text.actions.StyleListener;
import org.eclipse.gef.examples.text.actions.StyleProvider;

public class StyleService {
    public static final Object STATE_EDITABLE = new Object();
    public static final Object STATE_READ_ONLY = new Object();
    public static final Object UNDEFINED = new Object();
    private List listeners = new ArrayList();
    private StyleProvider provider;
    private StyleListener providerListener = new StyleListener(){

        public void styleChanged(String styleID) {
            StyleService.this.propogateChange(styleID);
        }
    };

    public void addStyleListener(StyleListener listener) {
        this.listeners.add(listener);
    }

    public Object getStyle(String styleID) {
        if (this.provider != null) {
            return this.provider.getStyle(styleID);
        }
        return UNDEFINED;
    }

    public Object getStyleState(String styleID) {
        if (this.provider != null) {
            return this.provider.getStyleState(styleID);
        }
        return UNDEFINED;
    }

    protected void propogateChange(String styleID) {
        int i = 0;
        while (i < this.listeners.size()) {
            StyleListener listener = (StyleListener)this.listeners.get(i);
            listener.styleChanged(styleID);
            ++i;
        }
    }

    public void removeStyleListener(StyleListener listener) {
        this.listeners.remove(listener);
    }

    public void setStyle(String styleID, Object value) {
        if (this.provider != null) {
            this.provider.setStyle(styleID, value);
        }
    }

    public void setStyleProvider(StyleProvider provider) {
        if (this.provider == provider) {
            return;
        }
        if (this.provider != null) {
            this.provider.removeStyleListener(this.providerListener);
        }
        this.provider = provider;
        if (this.provider != null) {
            this.provider.addStyleListener(this.providerListener);
        }
        this.propogateChange(null);
    }
}

