/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.actions;

import java.io.InputStream;
import java.io.ObjectInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.examples.logicdesigner.actions.PrintModeDialog;
import org.eclipse.gef.examples.logicdesigner.edit.GraphicalPartFactory;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class LogicPrintAction
extends Action
implements IObjectActionDelegate {
    private Object contents;
    private IFile selectedFile;

    protected Object getContents() {
        return this.contents;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        int style = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getStyle();
        Shell shell = new Shell((style & 0x8000000) != 0 ? 0x4000000 : 0);
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl((Composite)shell);
        viewer.setEditDomain((EditDomain)new DefaultEditDomain(null));
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        viewer.setContents(this.getContents());
        viewer.flush();
        int printMode = new PrintModeDialog(shell).open();
        if (printMode == -1) {
            return;
        }
        PrintDialog dialog = new PrintDialog(shell, 0);
        PrinterData data = dialog.open();
        if (data != null) {
            PrintGraphicalViewerOperation op = new PrintGraphicalViewerOperation(new Printer(data), (GraphicalViewer)viewer);
            op.setPrintMode(printMode);
            op.run(this.selectedFile.getName());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() != 1) {
            return;
        }
        this.selectedFile = (IFile)sel.getFirstElement();
        try {
            InputStream is = this.selectedFile.getContents(false);
            ObjectInputStream ois = new ObjectInputStream(is);
            this.setContents(ois.readObject());
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setContents(Object o) {
        this.contents = o;
    }
}

