/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.Wire;

public class DeleteCommand
extends Command {
    private LogicSubpart child;
    private LogicDiagram parent;
    private LogicGuide vGuide;
    private LogicGuide hGuide;
    private int vAlign;
    private int hAlign;
    private int index = -1;
    private List sourceConnections = new ArrayList();
    private List targetConnections = new ArrayList();

    public DeleteCommand() {
        super(LogicMessages.DeleteCommand_Label);
    }

    private void deleteConnections(LogicSubpart part) {
        if (part instanceof LogicDiagram) {
            List children = ((LogicDiagram)part).getChildren();
            int i = 0;
            while (i < children.size()) {
                this.deleteConnections((LogicSubpart)children.get(i));
                ++i;
            }
        }
        this.sourceConnections.addAll(part.getSourceConnections());
        int i = 0;
        while (i < this.sourceConnections.size()) {
            Wire wire = (Wire)this.sourceConnections.get(i);
            wire.detachSource();
            wire.detachTarget();
            ++i;
        }
        this.targetConnections.addAll(part.getTargetConnections());
        i = 0;
        while (i < this.targetConnections.size()) {
            Wire wire = (Wire)this.targetConnections.get(i);
            wire.detachSource();
            wire.detachTarget();
            ++i;
        }
    }

    private void detachFromGuides(LogicSubpart part) {
        if (part.getVerticalGuide() != null) {
            this.vGuide = part.getVerticalGuide();
            this.vAlign = this.vGuide.getAlignment(part);
            this.vGuide.detachPart(part);
        }
        if (part.getHorizontalGuide() != null) {
            this.hGuide = part.getHorizontalGuide();
            this.hAlign = this.hGuide.getAlignment(part);
            this.hGuide.detachPart(part);
        }
    }

    public void execute() {
        this.primExecute();
    }

    protected void primExecute() {
        this.deleteConnections(this.child);
        this.detachFromGuides(this.child);
        this.index = this.parent.getChildren().indexOf(this.child);
        this.parent.removeChild(this.child);
    }

    private void reattachToGuides(LogicSubpart part) {
        if (this.vGuide != null) {
            this.vGuide.attachPart(part, this.vAlign);
        }
        if (this.hGuide != null) {
            this.hGuide.attachPart(part, this.hAlign);
        }
    }

    public void redo() {
        this.primExecute();
    }

    private void restoreConnections() {
        Wire wire;
        int i = 0;
        while (i < this.sourceConnections.size()) {
            wire = (Wire)this.sourceConnections.get(i);
            wire.attachSource();
            wire.attachTarget();
            ++i;
        }
        this.sourceConnections.clear();
        i = 0;
        while (i < this.targetConnections.size()) {
            wire = (Wire)this.targetConnections.get(i);
            wire.attachSource();
            wire.attachTarget();
            ++i;
        }
        this.targetConnections.clear();
    }

    public void setChild(LogicSubpart c) {
        this.child = c;
    }

    public void setParent(LogicDiagram p) {
        this.parent = p;
    }

    public void undo() {
        this.parent.addChild(this.child, this.index);
        this.restoreConnections();
        this.reattachToGuides(this.child);
    }
}

