/*******************************************************************************
 * Copyright (c) 2000, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.gef.examples.logicdesigner.actions;

import org.eclipse.ui.IEditorPart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

import org.eclipse.gef.GraphicalEditPart;

/**
 * @author Eric Bordeau
 */
public class LogicPasteTemplateAction extends PasteTemplateAction {

	/**
	 * Constructor for LogicPasteTemplateAction.
	 * 
	 * @param editor
	 */
	public LogicPasteTemplateAction(IEditorPart editor) {
		super(editor);
	}

	/**
	 * @see PasteTemplateAction#getPasteLocation(GraphicalEditPart)
	 */
	protected Point getPasteLocation(GraphicalEditPart container) {
		Point result = new Point(10, 10);
		IFigure fig = container.getContentPane();
		result.translate(fig.getClientArea(Rectangle.SINGLETON).getLocation());
		fig.translateToAbsolute(result);
		return result;
	}

}
