/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class ChangeGuideCommand
extends Command {
    private LogicSubpart part;
    private LogicGuide oldGuide;
    private LogicGuide newGuide;
    private int oldAlign;
    private int newAlign;
    private boolean horizontal;

    public ChangeGuideCommand(LogicSubpart part, boolean horizontalGuide) {
        this.part = part;
        this.horizontal = horizontalGuide;
    }

    protected void changeGuide(LogicGuide oldGuide, LogicGuide newGuide, int newAlignment) {
        if (oldGuide != null && oldGuide != newGuide) {
            oldGuide.detachPart(this.part);
        }
        if (newGuide != null) {
            newGuide.attachPart(this.part, newAlignment);
        }
    }

    public void execute() {
        LogicGuide logicGuide = this.oldGuide = this.horizontal ? this.part.getHorizontalGuide() : this.part.getVerticalGuide();
        if (this.oldGuide != null) {
            this.oldAlign = this.oldGuide.getAlignment(this.part);
        }
        this.redo();
    }

    public void redo() {
        this.changeGuide(this.oldGuide, this.newGuide, this.newAlign);
    }

    public void setNewGuide(LogicGuide guide, int alignment) {
        this.newGuide = guide;
        this.newAlign = alignment;
    }

    public void undo() {
        this.changeGuide(this.newGuide, this.oldGuide, this.oldAlign);
    }
}

