/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.internal.behaviors;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.fx.internal.nodes.IBendableCurve;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.operations.AbstractCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.BendContentOperation;
import org.eclipse.gef.mvc.fx.operations.BendVisualOperation;
import org.eclipse.gef.mvc.fx.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;
import org.eclipse.gef.mvc.fx.providers.IAnchorProvider;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class BendCurvePolicy
extends AbstractPolicy {
    protected static final double DEFAULT_SEGMENT_OVERLAY_THRESHOLD = 6.0;
    protected static final double DEFAULT_OVERLAY_THRESHOLD = 10.0;
    private List<IBendableContentPart.BendPoint> initialBendPoints = new ArrayList<IBendableContentPart.BendPoint>();
    private List<IBendableContentPart.BendPoint> preMoveBendPoints = new ArrayList<IBendableContentPart.BendPoint>();
    private List<Integer> selectedIndices = new ArrayList<Integer>();
    private List<Point> selectedIndicesInitialPositions = new ArrayList<Point>();

    protected boolean canConnect(int explicitAnchorIndex) {
        return explicitAnchorIndex == 0 || explicitAnchorIndex == this.getBendOperation().getFinalBendPoints().size() - 1;
    }

    @Override
    public ITransactionalOperation commit() {
        ITransactionalOperation commitOperation = super.commit();
        if (commitOperation != null && !commitOperation.isNoOp() && this.getHost() instanceof IBendableContentPart) {
            ForwardUndoCompositeOperation composite = new ForwardUndoCompositeOperation("Bend Content");
            composite.add(commitOperation);
            BendContentOperation resizeOperation = new BendContentOperation((IBendableContentPart<? extends Node>)this.getHost(), this.getInitialBendPoints(), this.getCurrentBendPoints());
            composite.add(resizeOperation);
            commitOperation = composite;
        }
        this.initialBendPoints = null;
        return commitOperation;
    }

    public int createAfter(int explicitAnchorIndex, Point mouseInScene) {
        this.checkInitialized();
        int insertionIndex = explicitAnchorIndex + 1;
        this.insertExplicitAnchor(insertionIndex, mouseInScene);
        return insertionIndex;
    }

    public int createBefore(int explicitAnchorIndex, Point mouseInScene) {
        this.checkInitialized();
        int insertionIndex = explicitAnchorIndex;
        this.insertExplicitAnchor(insertionIndex, mouseInScene);
        return insertionIndex;
    }

    @Override
    protected ITransactionalOperation createOperation() {
        ForwardUndoCompositeOperation fwdOp = new ForwardUndoCompositeOperation("BendAndRoute");
        fwdOp.add(new BendVisualOperation((IBendableContentPart<? extends Node>)this.getHost()));
        return fwdOp;
    }

    private IBendableContentPart.BendPoint findOrCreateAnchor(int explicitAnchorIndex, Point positionInLocal, boolean canConnect) {
        IBendableContentPart.BendPoint anchor = null;
        if (canConnect) {
            Point selectedPointCurrentPositionInScene = FX2Geometry.toPoint((Point2D)this.getHost().getVisual().localToScene(Geometry2FX.toFXPoint((Point)positionInLocal)));
            List pickedNodes = NodeUtils.getNodesAt(this.getHost().getRoot().getVisual(), (double)selectedPointCurrentPositionInScene.x, (double)selectedPointCurrentPositionInScene.y);
            anchor = this.getCompatibleAnchor(explicitAnchorIndex, this.getParts(pickedNodes), selectedPointCurrentPositionInScene);
        }
        if (anchor == null) {
            anchor = new IBendableContentPart.BendPoint(positionInLocal);
        }
        return anchor;
    }

    protected BendVisualOperation getBendOperation() {
        return (BendVisualOperation)((AbstractCompositeOperation)super.getOperation()).getOperations().get(0);
    }

    private IBendableContentPart.BendPoint getCompatibleAnchor(int explicitAnchorIndex, List<IContentPart<? extends Node>> partsUnderMouse, Point positionInScene) {
        for (IContentPart<? extends Node> part : partsUnderMouse) {
            IAnchorProvider anchorProvider;
            if (part == this.getHost() || (anchorProvider = (IAnchorProvider)part.getAdapter(IAnchorProvider.class)) == null) continue;
            return new IBendableContentPart.BendPoint(part.getContent(), positionInScene);
        }
        return null;
    }

    protected List<IBendableContentPart.BendPoint> getCurrentBendPoints() {
        return this.getHost().getVisualBendPoints();
    }

    public IBendableContentPart<? extends Node> getHost() {
        return (IBendableContentPart)super.getHost();
    }

    protected List<IBendableContentPart.BendPoint> getInitialBendPoints() {
        return this.initialBendPoints;
    }

    public Orientation getOrientation() {
        if (this.selectedIndices.size() > 1) {
            Point p1 = this.getSelectedInitialPositions().get(0);
            Point p2 = this.getSelectedInitialPositions().get(1);
            Point delta = p1.getDifference(p2);
            if (Math.abs(delta.x) > Math.abs(delta.y)) {
                return Orientation.HORIZONTAL;
            }
            return Orientation.VERTICAL;
        }
        return null;
    }

    protected double getOverlayThreshold() {
        if (this.getSelectedIndices().size() > 1) {
            return 6.0;
        }
        return 10.0;
    }

    private List<IContentPart<? extends Node>> getParts(List<Node> nodesUnderMouse) {
        ArrayList<IContentPart<? extends Node>> parts = new ArrayList<IContentPart<? extends Node>>();
        IViewer viewer = this.getHost().getRoot().getViewer();
        for (Node node : nodesUnderMouse) {
            IVisualPart<? extends Node> part = PartUtils.retrieveVisualPart(viewer, node);
            if (!(part instanceof IContentPart)) continue;
            parts.add((IContentPart)part);
        }
        return parts;
    }

    protected List<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    public List<Point> getSelectedInitialPositions() {
        return this.selectedIndicesInitialPositions;
    }

    protected Point getVisualPoint(int bendPointIndex) {
        Object visual = this.getHost().getVisual();
        if (visual instanceof IBendableCurve) {
            return ((IBendableCurve)visual).getPoint(bendPointIndex);
        }
        if (visual instanceof Connection) {
            return ((Connection)visual).getPoint(bendPointIndex);
        }
        throw new IllegalStateException("Unsupported visual.");
    }

    @Override
    public void init() {
        this.selectedIndices.clear();
        this.selectedIndicesInitialPositions.clear();
        super.init();
        this.initialBendPoints = this.getCurrentBendPoints();
    }

    protected void insertExplicitAnchor(int insertionIndex, Point mouseInScene) {
        Point mouseInLocal = FX2Geometry.toPoint((Point2D)this.getHost().getVisual().sceneToLocal(Geometry2FX.toFXPoint((Point)mouseInScene)));
        this.getBendOperation().getFinalBendPoints().add(insertionIndex, new IBendableContentPart.BendPoint(mouseInLocal));
        this.locallyExecuteOperation();
    }

    private boolean isOverlay(int overlayingIndex, int overlainIndex) {
        return this.getVisualPoint(overlayingIndex).getDistance(this.getVisualPoint(overlainIndex)) <= this.getOverlayThreshold();
    }

    @Override
    protected void locallyExecuteOperation() {
        try {
            this.getBendOperation().execute(null, null);
        }
        catch (Exception x) {
            throw new IllegalStateException(x);
        }
    }

    public Point move(Point initialMouseInScene, Point currentMouseInScene) {
        this.checkInitialized();
        this.restorePreMoveBendpoints();
        Point mouseDeltaInLocal = FX2Geometry.toPoint((Point2D)this.getHost().getVisual().sceneToLocal(Geometry2FX.toFXPoint((Point)currentMouseInScene))).getTranslated(FX2Geometry.toPoint((Point2D)this.getHost().getVisual().sceneToLocal(Geometry2FX.toFXPoint((Point)initialMouseInScene))).getNegated());
        int i = 0;
        while (i < this.selectedIndices.size()) {
            int bendPointIndex = this.selectedIndices.get(i);
            boolean canConnect = this.canConnect(bendPointIndex);
            Point selectedPointCurrentPositionInLocal = this.selectedIndicesInitialPositions.get(i).getTranslated(mouseDeltaInLocal);
            this.getBendOperation().getFinalBendPoints().set(bendPointIndex, this.findOrCreateAnchor(bendPointIndex, selectedPointCurrentPositionInLocal, canConnect));
            ++i;
        }
        this.locallyExecuteOperation();
        this.removeOverlain();
        return currentMouseInScene;
    }

    protected void removeOverlain() {
        this.removeOverlainPoints();
    }

    private void removeOverlainPoints() {
        int explicitAnchorsSize = this.getBendOperation().getFinalBendPoints().size();
        int i = this.selectedIndices.size() - 1;
        while (i >= 0 && explicitAnchorsSize > 2) {
            boolean isRightOverlain;
            int index = this.selectedIndices.get(i);
            boolean isLeftOverlain = index > 0 && this.isOverlay(index, index - 1);
            boolean bl = isRightOverlain = index < explicitAnchorsSize - 1 && this.isOverlay(index, index + 1);
            if (isLeftOverlain || isRightOverlain) {
                int overlainIndex;
                int n = overlainIndex = isLeftOverlain ? index - 1 : index + 1;
                if (!this.selectedIndices.contains(overlainIndex)) {
                    this.getBendOperation().getFinalBendPoints().remove(index);
                    this.locallyExecuteOperation();
                }
            }
            --i;
        }
    }

    protected void restorePreMoveBendpoints() {
        this.getBendOperation().setFinalBendPoints(this.preMoveBendPoints);
        this.locallyExecuteOperation();
    }

    public void select(int index) {
        this.checkInitialized();
        this.selectedIndices.add(index);
        this.selectedIndicesInitialPositions.add(this.getVisualPoint(index));
        this.preMoveBendPoints.clear();
        this.preMoveBendPoints.addAll(this.getBendOperation().getFinalBendPoints());
    }

    public void selectSegment(int from, int to) {
        boolean isSecondConnected;
        int firstAnchorHandle = from;
        int secondAnchorHandle = to;
        boolean isFirstConnected = this.getHost().getVisual() instanceof Connection ? ((Connection)this.getHost().getVisual()).isConnected(from) : ((IBendableCurve)this.getHost().getVisual()).isConnected(from);
        boolean bl = isSecondConnected = this.getHost().getVisual() instanceof Connection ? ((Connection)this.getHost().getVisual()).isConnected(to) : ((IBendableCurve)this.getHost().getVisual()).isConnected(to);
        if (isFirstConnected) {
            firstAnchorHandle = this.createAfter(firstAnchorHandle, NodeUtils.localToScene(this.getHost().getVisual(), (Point)this.getVisualPoint(firstAnchorHandle)));
            ++secondAnchorHandle;
        }
        if (isSecondConnected) {
            secondAnchorHandle = this.createBefore(secondAnchorHandle, NodeUtils.localToScene(this.getHost().getVisual(), (Point)this.getVisualPoint(secondAnchorHandle)));
        }
        this.select(firstAnchorHandle);
        this.select(secondAnchorHandle);
    }
}

