/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.markoccurrences;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.occurrences.DefaultOccurrenceComputer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DotOccurrenceComputer
extends DefaultOccurrenceComputer {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    public Map<Annotation, Position> createAnnotationMap(XtextEditor editor, final ITextSelection selection, SubMonitor monitor) {
        final Map annotationMap = super.createAnnotationMap(editor, selection, monitor);
        final IXtextDocument document = editor.getDocument();
        if (document != null) {
            return (Map)document.readOnly((IUnitOfWork)new CancelableUnitOfWork<Map<Annotation, Position>, XtextResource>(){

                public Map<Annotation, Position> exec(XtextResource resource, CancelIndicator cancelIndicator) throws Exception {
                    if (resource != null && resource.getContents().size() > 0) {
                        ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)NodeModelUtils.getNode((EObject)((EObject)resource.getContents().get(0))), (int)selection.getOffset());
                        EObject target = DotOccurrenceComputer.this.eObjectAtOffsetHelper.resolveElementAt(resource, selection.getOffset());
                        List textRegions = new ArrayList();
                        if (target instanceof NodeId && !target.eIsProxy()) {
                            textRegions = DotOccurrenceComputer.this.nodeId((NodeId)target);
                        } else if (target instanceof Attribute && !target.eIsProxy()) {
                            textRegions = DotOccurrenceComputer.this.attribute((Attribute)target, (INode)node);
                        }
                        for (ITextRegion occurrence : textRegions) {
                            try {
                                DotOccurrenceComputer.this.addOccurrenceAnnotation("org.eclipse.xtext.ui.editor.defaultOccurrenceAnnotation", (IDocument)document, occurrence, annotationMap);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    return annotationMap;
                }
            });
        }
        return annotationMap;
    }

    private List<ITextRegion> nodeId(NodeId target) {
        return this.textRegions(DotAstHelper.getAllNodeIds((NodeId)target), DotPackage.Literals.NODE_ID__NAME);
    }

    private List<ITextRegion> attribute(Attribute target, INode node) {
        if (target.getName().toValue().equalsIgnoreCase(node.getText())) {
            return this.attributeName(target);
        }
        return this.attributeValue(target);
    }

    private List<ITextRegion> attributeValue(Attribute target) {
        return this.textRegions(DotAstHelper.getAllAttributesSameValue((Attribute)target), DotPackage.Literals.ATTRIBUTE__VALUE);
    }

    private List<ITextRegion> attributeName(Attribute target) {
        return this.textRegions(DotAstHelper.getAllAttributesSameName((Attribute)target), DotPackage.Literals.ATTRIBUTE__NAME);
    }

    private List<ITextRegion> textRegions(List<? extends EObject> allOccurrences, EAttribute feature) {
        ArrayList<ITextRegion> textRegions = new ArrayList<ITextRegion>();
        for (EObject eObject : allOccurrences) {
            try {
                ITextRegion textRegion = this.locationInFileProvider.getSignificantTextRegion(eObject, (EStructuralFeature)feature, -1);
                textRegions.add(textRegion);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return textRegions;
    }
}

