/*******************************************************************************
 * Copyright (c) 2000, 2022 IBM Corporation and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.gef.examples.logicdesigner.edit;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.commands.AddCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.CloneCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.CreateCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.ReorderPartCommand;

public class LogicFlowEditPolicy extends org.eclipse.gef.editpolicies.FlowLayoutEditPolicy {

	/**
	 * Override to return the <code>Command</code> to perform an
	 * {@link RequestConstants#REQ_CLONE CLONE}. By default, <code>null</code> is
	 * returned.
	 *
	 * @param request the Clone Request
	 * @return A command to perform the Clone.
	 */
	@Override
	protected Command getCloneCommand(ChangeBoundsRequest request) {
		CloneCommand clone = new CloneCommand();
		clone.setParent((LogicDiagram) getHost().getModel());

		EditPart after = getInsertionReference(request);
		int index = getHost().getChildren().indexOf(after);

		for (EditPart ep : request.getEditParts()) {
			GraphicalEditPart currPart = (GraphicalEditPart) ep;
			clone.addPart((LogicSubpart) currPart.getModel(), index);
			index++;
		}

		return clone;
	}

	@Override
	protected Command createAddCommand(EditPart child, EditPart after) {
		AddCommand command = new AddCommand();
		command.setChild((LogicSubpart) child.getModel());
		command.setParent((LogicFlowContainer) getHost().getModel());
		int index = getHost().getChildren().indexOf(after);
		command.setIndex(index);
		return command;
	}

	/**
	 * @see org.eclipse.gef.editpolicies.LayoutEditPolicy#createChildEditPolicy(org.eclipse.gef.EditPart)
	 */
	@Override
	protected EditPolicy createChildEditPolicy(EditPart child) {
		LogicResizableEditPolicy policy = new LogicResizableEditPolicy();
		policy.setResizeDirections(0);
		return policy;
	}

	@Override
	protected Command createMoveChildCommand(EditPart child, EditPart after) {
		LogicSubpart childModel = (LogicSubpart) child.getModel();
		LogicDiagram parentModel = (LogicDiagram) getHost().getModel();
		int oldIndex = getHost().getChildren().indexOf(child);
		int newIndex = getHost().getChildren().indexOf(after);
		if (newIndex > oldIndex) {
			newIndex--;
		}
		return new ReorderPartCommand(childModel, parentModel, newIndex);
	}

	@Override
	protected Command getCreateCommand(CreateRequest request) {
		CreateCommand command = new CreateCommand();
		EditPart after = getInsertionReference(request);
		command.setChild((LogicSubpart) request.getNewObject());
		command.setParent((LogicFlowContainer) getHost().getModel());
		int index = getHost().getChildren().indexOf(after);
		command.setIndex(index);
		return command;
	}

}
