/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.InlineContainer;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class ApplyBooleanStyle
extends MiniEdit {
    private TextRun begin;
    private int beginOffset;
    private Container container;
    private int endOffset;
    String[] keys;
    private TextRun middle;
    private Container parent;
    private TextRun right;
    Object[] values;

    public ApplyBooleanStyle(ModelLocation start, ModelLocation end, String[] keys, Object[] values) {
        this.begin = (TextRun)start.model;
        this.parent = this.begin.getContainer();
        this.beginOffset = start.offset;
        this.endOffset = end.offset;
        this.keys = keys;
        this.values = values;
    }

    @Override
    public void apply() {
        this.right = this.begin.subdivideRun(this.endOffset);
        if (this.right.getText().length() == 0) {
            this.right = null;
        }
        this.middle = this.begin.subdivideRun(this.beginOffset);
        this.container = new InlineContainer(6);
        int i = 0;
        while (i < this.keys.length) {
            String key = this.keys[i];
            if (key.equals("bold")) {
                this.container.getStyle().setBold((Boolean)this.values[i]);
            } else if (key.equals("fontSize")) {
                this.container.getStyle().setFontHeight((Integer)this.values[i]);
            } else if (key.equals("italics")) {
                this.container.getStyle().setItalic((Boolean)this.values[i]);
            } else if (key.equals("underline")) {
                this.container.getStyle().setUnderline((Boolean)this.values[i]);
            } else if (key.equals("font")) {
                this.container.getStyle().setFontFamily((String)this.values[i]);
            }
            ++i;
        }
        this.container.add(this.middle);
        int index = this.begin.getContainer().getChildren().indexOf(this.begin) + 1;
        if (this.right != null) {
            this.parent.add(this.right, index);
        }
        this.parent.add(this.container, index);
        if (this.begin.getText().length() == 0) {
            this.parent.remove(this.begin);
        }
    }

    @Override
    public boolean canApply() {
        return true;
    }

    @Override
    public ModelLocation getResultingLocation() {
        return new ModelLocation(this.middle, this.middle.size());
    }

    @Override
    public void rollback() {
        int index = this.parent.getChildren().indexOf(this.container);
        this.parent.remove(this.container);
        if (this.right != null) {
            this.parent.remove(this.right);
        }
        if (this.begin.getContainer() == null) {
            this.parent.add(this.begin, index);
        }
        this.begin.insertText(this.middle.getText(), this.begin.size());
        if (this.right != null) {
            this.begin.insertText(this.right.getText(), this.begin.size());
        }
    }
}

