/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class OrphanChildCommand
extends Command {
    private Point oldLocation;
    private LogicDiagram diagram;
    private LogicSubpart child;
    private int index;

    public OrphanChildCommand() {
        super(LogicMessages.OrphanChildCommand_Label);
    }

    public void execute() {
        List<LogicElement> children = this.diagram.getChildren();
        this.index = children.indexOf(this.child);
        this.oldLocation = this.child.getLocation();
        this.diagram.removeChild(this.child);
    }

    public void redo() {
        this.diagram.removeChild(this.child);
    }

    public void setChild(LogicSubpart child) {
        this.child = child;
    }

    public void setParent(LogicDiagram parent) {
        this.diagram = parent;
    }

    public void undo() {
        this.child.setLocation(this.oldLocation);
        this.diagram.addChild(this.child, this.index);
    }
}

