/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.examples.layouts;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.zest.core.widgets.DAGExpandCollapseManager;
import org.eclipse.zest.core.widgets.DefaultSubgraph;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.SubgraphFactory;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.interfaces.ExpandCollapseManager;

public class TreeLayoutExample {
    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        d = new Display();
        shell = new Shell(d);
        shell.setText("TreeLayoutExample");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 10;
        shell.setLayout((Layout)gridLayout);
        shell.setSize(600, 500);
        g = new Graph((Composite)shell, 0);
        algorithm = new TreeLayoutAlgorithm();
        g.setSubgraphFactory((SubgraphFactory)new DefaultSubgraph.PrunedSuccessorsSubgraphFactory());
        g.setLayoutAlgorithm((LayoutAlgorithm)algorithm, false);
        g.setExpandCollapseManager((ExpandCollapseManager)new DAGExpandCollapseManager());
        g.setLayoutData((Object)new GridData(4, 4, true, true, 10, 10));
        g.setSize(500, 500);
        root = new GraphNode((IContainer)g, 0, "Root");
        lastNode = null;
        i = 0;
        while (i < 3) {
            n = new GraphNode((IContainer)g, 0, "1 - " + i);
            if (lastNode != null) {
                new GraphConnection(g, 0, n, lastNode).setDirected(true);
            }
            j = 0;
            while (j < 1) {
                n2 = new GraphNode((IContainer)g, 0, "2 - " + j);
                c = new GraphConnection(g, 0, n, n2);
                c.setWeight(-1.0);
                c.setDirected(true);
                lastNode = n2;
                ++j;
            }
            new GraphConnection(g, 0, root, n).setDirected(true);
            ++i;
        }
        TreeLayoutExample.hookMenu(g);
        buttonTopDown = new Button((Composite)shell, 0x800000);
        buttonTopDown.setText("TOP_DOWN");
        buttonBottomUp = new Button((Composite)shell, 0x800000);
        buttonBottomUp.setText("BOTTOM_UP");
        buttonBottomUp.setLayoutData((Object)new GridData());
        buttonLeftRight = new Button((Composite)shell, 0x800000);
        buttonLeftRight.setText("LEFT_RIGHT");
        buttonRightLeft = new Button((Composite)shell, 0x800000);
        buttonRightLeft.setText("RIGHT_LEFT");
        buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == buttonTopDown) {
                    algorithm.setDirection(1);
                }
                if (e.widget == buttonBottomUp) {
                    algorithm.setDirection(2);
                }
                if (e.widget == buttonLeftRight) {
                    algorithm.setDirection(3);
                }
                if (e.widget == buttonRightLeft) {
                    algorithm.setDirection(4);
                }
                g.applyLayout();
            }
        };
        buttonTopDown.addSelectionListener((SelectionListener)buttonListener);
        buttonBottomUp.addSelectionListener((SelectionListener)buttonListener);
        buttonLeftRight.addSelectionListener((SelectionListener)buttonListener);
        buttonRightLeft.addSelectionListener((SelectionListener)buttonListener);
        resizeButton = new Button((Composite)shell, 32);
        resizeButton.setText("Resize");
        resizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                algorithm.setResizing(resizeButton.getSelection());
            }
        });
        nodeSpaceButton = new Button((Composite)shell, 32);
        nodeSpaceButton.setText("Set node space");
        nodeSpaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                algorithm.setNodeSpace(nodeSpaceButton.getSelection() ? new Dimension(100, 100) : null);
            }
        });
        shell.open();
        ** GOTO lbl61
        {
            d.sleep();
            do {
                if (!d.readAndDispatch()) continue block2;
lbl61:
                // 2 sources

            } while (!shell.isDisposed());
        }
    }

    private static void hookMenu(final Graph g) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Action expandAction = new Action(){

            public void run() {
                List selection = g.getSelection();
                if (!selection.isEmpty()) {
                    GraphNode selected = (GraphNode)selection.get(0);
                    g.setExpanded(selected, true);
                }
            }
        };
        expandAction.setText("expand");
        menuMgr.add((IAction)expandAction);
        Action collapseAction = new Action(){

            public void run() {
                List selection = g.getSelection();
                if (!selection.isEmpty()) {
                    GraphItem selected = (GraphItem)selection.get(0);
                    g.setExpanded((GraphNode)selected, false);
                }
            }
        };
        collapseAction.setText("collapse");
        menuMgr.add((IAction)collapseAction);
        g.setMenu(menuMgr.createContextMenu((Control)g));
    }
}

