/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.ras;

import java.lang.reflect.Field;
import java.util.LinkedList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.eclipse.contribution.xref.ras.FFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

@Aspect
public abstract class PluginFFDC
extends FFDC {
    protected abstract String getPluginId();

    protected abstract void log(IStatus var1);

    protected void processStaticFFDC(Throwable th, String sourceId) {
        this.logException(th, sourceId, null);
    }

    protected void processNonStaticFFDC(Throwable th, Object obj, String sourceId) {
        this.logException(th, sourceId, obj);
    }

    public void logException(Throwable th, String sourceId, Object obj) {
        IStatus status = null;
        if (th instanceof CoreException) {
            status = ((CoreException)th).getStatus();
        } else {
            try {
                IStatus[] children;
                Status sourceChild = new Status(4, this.getPluginId(), 0, sourceId, null);
                String message = th.getMessage();
                if (message == null) {
                    message = th.toString();
                }
                if (obj == null) {
                    children = new IStatus[]{sourceChild};
                } else {
                    IStatus objectChild = this.introspect(obj);
                    children = new IStatus[]{sourceChild, objectChild};
                }
                status = new MultiStatus(this.getPluginId(), 0, children, message, th);
            }
            catch (Exception exception) {
                status = new Status(4, this.getClass().getName(), 0, sourceId, th);
            }
        }
        this.log(status);
    }

    private IStatus introspect(Object obj) {
        IStatus[] fieldValuesArray;
        String message;
        Class<JoinPoint.StaticPart> sjpClass = JoinPoint.StaticPart.class;
        LinkedList<Status> fieldValues = new LinkedList<Status>();
        try {
            message = obj.toString();
        }
        catch (Exception exception) {
            message = PluginFFDC.safeToString(obj);
        }
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                field.setAccessible(true);
                if (!sjpClass.isAssignableFrom(field.getType())) {
                    Object value = field.get(obj);
                    String fieldMessage = String.valueOf(field.getName()) + "=" + PluginFFDC.safeToString(value);
                    fieldValues.add(new Status(1, this.getPluginId(), 0, fieldMessage, null));
                }
                ++i;
            }
            fieldValuesArray = new IStatus[fieldValues.size()];
            fieldValues.toArray(fieldValuesArray);
        }
        catch (Exception exception) {
            fieldValuesArray = new IStatus[]{};
        }
        MultiStatus result = new MultiStatus(this.getPluginId(), 1, fieldValuesArray, message, null);
        return result;
    }

    private static String safeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return "\"" + obj.toString() + "\"";
        }
        return obj.getClass() + "@" + obj.hashCode();
    }
}

