/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.debug.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.debug.ui.actions.BreakpointLocationVerifierJob;
import org.eclipse.ajdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public ToggleBreakpointAdapter() {
        ActionDelegateHelper.getDefault();
    }

    protected void report(final String message, final IWorkbenchPart part) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
                }
            }
        });
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            JavaModelException e = javaModelException;
            JDIDebugUIPlugin.log((Throwable)e);
        }
        return type;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, false);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection, final boolean bestMatch) {
        Job job = new Job("Toggle Line Breakpoint"){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                CoreException coreException3;
                block18: {
                    CoreException coreException22;
                    block22: {
                        HashMap attributes;
                        IResource resource;
                        String typeName;
                        int offset;
                        int lineNumber;
                        IDocument document;
                        IType type;
                        IEditorPart editorPart;
                        block20: {
                            block19: {
                                block21: {
                                    AJCompilationUnit ajcu;
                                    int end;
                                    int begin;
                                    block17: {
                                        if (!(selection instanceof ITextSelection)) return Status.OK_STATUS;
                                        if (monitor.isCanceled()) {
                                            return Status.CANCEL_STATUS;
                                        }
                                        ToggleBreakpointAdapter.this.report(null, part);
                                        editorPart = (IEditorPart)part;
                                        ITextSelection textSelection = (ITextSelection)selection;
                                        type = ToggleBreakpointAdapter.this.getType(textSelection);
                                        IEditorInput editorInput = editorPart.getEditorInput();
                                        IDocumentProvider documentProvider = ((ITextEditor)editorPart).getDocumentProvider();
                                        if (documentProvider == null) {
                                            return Status.CANCEL_STATUS;
                                        }
                                        document = documentProvider.getDocument((Object)editorInput);
                                        lineNumber = textSelection.getStartLine() + 1;
                                        offset = textSelection.getOffset();
                                        try {
                                            IClassFile classFile;
                                            if (type != null || (classFile = (IClassFile)editorInput.getAdapter(IClassFile.class)) == null || (type = classFile.getType()).getDeclaringType() == null) break block17;
                                            ISourceRange sourceRange = type.getSourceRange();
                                            int start = sourceRange.getOffset();
                                            int end2 = start + sourceRange.getLength();
                                            if (offset < start || offset > end2) {
                                                IStatusLineManager statusLine = editorPart.getEditorSite().getActionBars().getStatusLineManager();
                                                statusLine.setErrorMessage(NLS.bind((String)UIMessages.ManageBreakpointRulerAction_Breakpoints_can_only_be_created_within_the_type_associated_with_the_editor___0___1, (Object[])new String[]{type.getTypeQualifiedName()}));
                                                Display.getCurrent().beep();
                                                return Status.OK_STATUS;
                                            }
                                        }
                                        catch (CoreException coreException3) {
                                            // empty catch block
                                            break block18;
                                        }
                                    }
                                    typeName = null;
                                    resource = null;
                                    attributes = new HashMap(10);
                                    if (type != null) break block21;
                                    resource = ToggleBreakpointAdapter.getResource(editorPart);
                                    if (editorPart instanceof ITextEditor) {
                                        CompilationUnit unit = ToggleBreakpointAdapter.this.parseCompilationUnit((ITextEditor)editorPart);
                                        for (TypeDeclaration declaration : unit.types()) {
                                            begin = declaration.getStartPosition();
                                            end = begin + declaration.getLength();
                                            if (offset < begin || offset > end || declaration.isInterface()) continue;
                                            typeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)declaration);
                                            break;
                                        }
                                    }
                                    if (typeName == null && (ajcu = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit((IFile)resource)) != null) {
                                        IType[] types = ajcu.getAllTypes();
                                        int i = 0;
                                        while (i < types.length) {
                                            begin = types[i].getSourceRange().getOffset();
                                            end = begin + types[i].getSourceRange().getLength();
                                            if (offset >= begin && offset <= end && !types[i].isInterface()) {
                                                typeName = String.valueOf(types[i].getPackageFragment().getElementName()) + "." + types[i].getTypeQualifiedName();
                                                break block19;
                                            }
                                            ++i;
                                        }
                                    }
                                    break block19;
                                }
                                typeName = type.getFullyQualifiedName();
                                int index = typeName.indexOf(36);
                                if (index >= 0) {
                                    typeName = typeName.substring(0, index);
                                }
                                resource = BreakpointUtils.getBreakpointResource((IMember)type);
                                try {
                                    IRegion line = document.getLineInformation(lineNumber - 1);
                                    int start = line.getOffset();
                                    int end = start + line.getLength() - 1;
                                    BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, (int)start, (int)end);
                                }
                                catch (BadLocationException badLocationException) {
                                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(badLocationException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                                    BadLocationException ble = badLocationException;
                                    JDIDebugUIPlugin.log((Throwable)ble);
                                }
                            }
                            if (typeName == null) return Status.OK_STATUS;
                            if (resource == null) return Status.OK_STATUS;
                            IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((IResource)resource, (String)typeName, (int)lineNumber);
                            if (existingBreakpoint == null) break block20;
                            ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                            return Status.OK_STATUS;
                        }
                        ToggleBreakpointAdapter.this.createLineBreakpoint(resource, typeName, offset, lineNumber, -1, -1, 0, true, attributes, document, bestMatch, type, editorPart);
                        return Status.OK_STATUS;
                        catch (CoreException coreException4) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException4, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                            CoreException coreException5 = coreException4;
                        }
                        break block22;
                        catch (CoreException coreException22) {
                            // empty catch block
                        }
                    }
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException22, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException coreException6 = coreException22;
                }
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_1);
                CoreException ce = coreException3;
                return ce.getStatus();
            }

            static {
                2.ajc$preClinit();
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("ToggleBreakpointAdapter.java", 2.class);
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.debug.ui.actions.ToggleBreakpointAdapter$2", "org.eclipse.jface.text.BadLocationException", "ble"), 207);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "run", "org.eclipse.ajdt.internal.debug.ui.actions.ToggleBreakpointAdapter$2", "org.eclipse.core.runtime.IProgressMonitor", "monitor", "", "org.eclipse.core.runtime.IStatus"), 123);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.debug.ui.actions.ToggleBreakpointAdapter$2", "org.eclipse.core.runtime.CoreException", "ce"), 219);
                ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.debug.ui.actions.ToggleBreakpointAdapter$2", "org.eclipse.core.runtime.CoreException", "ce"), 219);
                ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.debug.ui.actions.ToggleBreakpointAdapter$2", "org.eclipse.core.runtime.CoreException", "ce"), 219);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void createLineBreakpoint(IResource resource, String typeName, int offset, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes, IDocument document, boolean bestMatch, IType type, IEditorPart editorPart) throws CoreException {
        IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)typeName, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
        new BreakpointLocationVerifierJob(document, breakpoint, offset, lineNumber, typeName, type, resource, editorPart).schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection finalSelection) {
    }

    private void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, delete);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    protected CompilationUnit parseCompilationUnit(ITextEditor editor) throws CoreException {
        IEditorInput editorInput = editor.getEditorInput();
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(document.get().toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection finalSelection) {
    }

    protected static IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IResource resource = (IResource)editorInput.getAdapter(IFile.class);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, true);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    static {
        ToggleBreakpointAdapter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ToggleBreakpointAdapter.java", ToggleBreakpointAdapter.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.debug.ui.actions.ToggleBreakpointAdapter", "org.eclipse.jdt.core.JavaModelException", "e"), 105);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "getType", "org.eclipse.ajdt.internal.debug.ui.actions.ToggleBreakpointAdapter", "org.eclipse.jface.text.ITextSelection", "selection", "", "org.eclipse.jdt.core.IType"), 90);
    }
}

