/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.search;

import java.util.List;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.dom.AnyWithAnnotationTypePattern;
import org.aspectj.org.eclipse.jdt.core.dom.DeclareAnnotationDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.IdentifierTypePattern;
import org.aspectj.org.eclipse.jdt.core.dom.PatternNode;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.TypeCategoryTypePattern;
import org.aspectj.org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.javaelements.PointcutUtilities;
import org.eclipse.ajdt.internal.core.search.AbstractExtraReferenceFinder;
import org.eclipse.ajdt.internal.core.search.IExtraMatchFinder;
import org.eclipse.ajdt.internal.core.search.TargetTypeUtils;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraTypeReferenceFinder
extends AbstractExtraReferenceFinder<TypeReferencePattern>
implements IExtraMatchFinder<TypeReferencePattern> {
    @Override
    protected SearchMatch createITDMatch(IntertypeElement itd, SearchParticipant participant) throws JavaModelException {
        ISourceRange range = itd.getTargetTypeSourceRange();
        return new TypeReferenceMatch((IJavaElement)itd, 0, range.getOffset(), range.getLength(), false, participant, itd.getResource());
    }

    @Override
    protected boolean isMatch(IntertypeElement itd, TypeReferencePattern pattern) throws JavaModelException {
        char[] targetTypeName = TargetTypeUtils.getName(pattern);
        IType targetType = itd.findTargetType();
        if (targetType != null) {
            return CharOperation.equals((char[])targetTypeName, (char[])targetType.getFullyQualifiedName().toCharArray());
        }
        return false;
    }

    @Override
    protected AbstractExtraReferenceFinder.DeclareVisitor createDeclareVisitor(char[] contents, DeclareElement decl, SearchParticipant participant, TypeReferencePattern pattern) throws JavaModelException {
        return new TypeReferenceDeclareVisitor(participant, TargetTypeUtils.getSimpleNameStr(pattern), TargetTypeUtils.getQualNameStr(pattern), decl, contents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypeReferenceDeclareVisitor
    extends AbstractExtraReferenceFinder.DeclareVisitor {
        private final String searchTypeSimpleName;
        private final String searchQualifier;
        private final String dotSearchTypeSimpleName;
        private final String atSearchTypeSimpleName;
        private final String atSearchTypeQualName;

        public TypeReferenceDeclareVisitor(SearchParticipant participant, String searchTypeSimpleName, String searchQualifier, DeclareElement decl, char[] fileContents) throws JavaModelException {
            super(participant, decl, fileContents);
            this.searchTypeSimpleName = searchTypeSimpleName;
            this.searchQualifier = searchQualifier == null ? "" : searchQualifier;
            this.dotSearchTypeSimpleName = "." + searchTypeSimpleName;
            this.atSearchTypeSimpleName = "@" + searchTypeSimpleName;
            this.atSearchTypeQualName = "@" + (this.searchQualifier.length() > 0 ? String.valueOf(this.searchQualifier) + "." : "") + searchTypeSimpleName;
        }

        public boolean visit(IdentifierTypePattern node) {
            this.findMatchInTypePattern((TypePattern)node);
            return super.visit(node);
        }

        public boolean visit(AnyWithAnnotationTypePattern node) {
            this.findMatchInTypePattern((TypePattern)node);
            return true;
        }

        public boolean visit(TypeCategoryTypePattern node) {
            this.findMatchInTypePattern((TypePattern)node);
            return true;
        }

        protected void findMatchInTypePattern(TypePattern node) {
            String detail = node.getTypePatternExpression();
            if (detail != null) {
                if (this.isSimpleMatch(detail)) {
                    int actualStart = node.getStartPosition() + this.offset;
                    this.acceptMatch((SearchMatch)new TypeReferenceMatch((IJavaElement)this.decl, 0, actualStart, node.getLength(), false, this.participant, this.decl.getResource()));
                } else if (this.isComplexTypePattern(detail)) {
                    this.findMatchesInComplexPattern((PatternNode)node);
                }
            }
        }

        public boolean visit(SimpleName node) {
            String name;
            if (node.getParent() instanceof DeclareAnnotationDeclaration && ((name = node.toString()).equals(this.atSearchTypeSimpleName) || name.equals(this.atSearchTypeQualName))) {
                int actualStart = node.getStartPosition() + 1 + this.offset;
                int actualLength = name.length() - 1;
                this.acceptMatch((SearchMatch)new TypeReferenceMatch((IJavaElement)this.decl, 0, actualStart, actualLength, false, this.participant, this.decl.getResource()));
            }
            return super.visit(node);
        }

        protected boolean isSimpleMatch(String detail) {
            return this.searchTypeSimpleName.equals(detail) || detail.endsWith(this.dotSearchTypeSimpleName);
        }

        @Override
        protected void findMatchesInComplexPattern(PatternNode node) {
            String actualPatternText = this.getActualText(node);
            Map<String, List<Integer>> matches = PointcutUtilities.findAllIdentifiers(actualPatternText);
            List<Integer> matchLocs = matches.get(this.searchTypeSimpleName);
            if (matchLocs != null) {
                for (Integer matchLoc : matchLocs) {
                    boolean isQualified;
                    if (matchLoc > 0 && actualPatternText.charAt(matchLoc - 1) == '.') {
                        String foundQualifier = this.findQualifier(actualPatternText, matchLoc);
                        if (!foundQualifier.equals(this.searchQualifier)) continue;
                        matchLoc = matchLoc - (foundQualifier.length() + 1);
                        isQualified = true;
                    } else {
                        isQualified = false;
                    }
                    int length = isQualified ? this.searchQualifier.length() + ".".length() + this.searchTypeSimpleName.length() : this.searchTypeSimpleName.length();
                    int start = matchLoc + node.getStartPosition() + this.offset;
                    this.acceptMatch((SearchMatch)new TypeReferenceMatch((IJavaElement)this.decl, 1, start, length, false, this.participant, this.decl.getResource()));
                }
            }
        }
    }
}

