/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.tracing;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ajdt.internal.ui.tracing.AJDTEventTraceConsolePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class AJDTEventTraceConsole
extends TextConsole {
    public static final String CONSOLE_TYPE = "ajdtEventTraceConsole";
    static final String BUILD_CLASSPATH = ":BC: ";
    static final String BUILDER = ":B:  ";
    static final String COMPILER = ":C:  ";
    static final Token COMPILER_TOKEN = new Token((Object)":C:  ");
    static final Token BUILDER_TOKEN = new Token((Object)":B:  ");
    static final Token BUILD_CLASSPATH_TOKEN = new Token((Object)":BC: ");
    static final RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
    private AJDTEventTraceConsolePartitioner partitioner;
    private IPropertyChangeListener propertyListener;

    public void clearConsole() {
        super.clearConsole();
        ((AJDTEventTraceConsolePartitioner)this.getPartitioner()).clear();
    }

    public AJDTEventTraceConsole() {
        super("AJDT Event Trace Console", CONSOLE_TYPE, null, true);
        scanner.setPredicateRules(new IPredicateRule[]{new SingleLineRule(COMPILER, "", (IToken)COMPILER_TOKEN), new SingleLineRule(BUILDER, "", (IToken)BUILDER_TOKEN), new SingleLineRule(BUILD_CLASSPATH, "", (IToken)BUILD_CLASSPATH_TOKEN)});
        this.partitioner = new AJDTEventTraceConsolePartitioner();
        this.propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("org.eclipse.debug.ui.consoleFont")) {
                    AJDTEventTraceConsole.this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
                }
            }
        };
        Font font = JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont");
        this.setFont(font);
        this.partitioner.connect(this.getDocument());
    }

    protected void init() {
        JFaceResources.getFontRegistry().addListener(this.propertyListener);
    }

    protected void dispose() {
        JFaceResources.getFontRegistry().removeListener(this.propertyListener);
        super.dispose();
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new AJDTEventTraceConsolePage(this, view);
    }

    public String getHelpContextId() {
        return "org.eclipse.ajdt.ui.event_trace_view_context";
    }

    class AJDTEventTraceConsolePartitioner
    extends FastPartitioner
    implements IConsoleDocumentPartitioner {
        Set styles;

        public AJDTEventTraceConsolePartitioner() {
            super((IPartitionTokenScanner)scanner, new String[]{AJDTEventTraceConsole.COMPILER, AJDTEventTraceConsole.BUILDER, AJDTEventTraceConsole.BUILD_CLASSPATH});
            this.styles = new HashSet();
            AJDTEventTraceConsole.this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this);
        }

        public boolean isReadOnly(int offset) {
            return true;
        }

        public StyleRange[] getStyleRanges(int offset, int length) {
            ITypedRegion[] regions = this.computePartitioning(offset, length);
            StyleRange[] styles = new StyleRange[regions.length];
            int i = 0;
            while (i < regions.length) {
                styles[i] = AJDTEventTraceConsole.COMPILER.equals(regions[i].getType()) ? new StyleRange(offset, length, Display.getDefault().getSystemColor(6), null) : (AJDTEventTraceConsole.BUILDER.equals(regions[i].getType()) ? new StyleRange(offset, length, Display.getDefault().getSystemColor(10), null) : (AJDTEventTraceConsole.BUILD_CLASSPATH.equals(regions[i].getType()) ? new StyleRange(offset, length, Display.getDefault().getSystemColor(4), null) : new StyleRange(offset, length, null, null)));
                ++i;
            }
            return styles;
        }

        void addStyle(StyleRange style) {
            this.styles.add(style);
        }

        void clear() {
            this.styles.clear();
        }
    }
}

