/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.text.VisualiserMessages;

public class Stripe
implements Comparable {
    private List kinds = new ArrayList();
    private int offset;
    private int depth;

    public boolean equals(Object that) {
        if (!(that instanceof Stripe)) {
            return false;
        }
        Stripe stripe = (Stripe)that;
        if (this.depth != stripe.depth) {
            return false;
        }
        if (this.offset != stripe.offset) {
            return false;
        }
        return this.stringifyKinds().equals(stripe.stringifyKinds());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.depth;
        result = 37 * result + this.offset;
        result = 37 * result + this.stringifyKinds().hashCode();
        return result;
    }

    public Stripe() {
    }

    public Stripe(IMarkupKind k, int i) {
        this.kinds.add(k);
        this.offset = i;
        this.depth = 1;
    }

    public Stripe(IMarkupKind k, int o, int d) {
        this.kinds.add(k);
        this.offset = o;
        this.depth = d;
    }

    public Stripe(List ks, int o, int d) {
        this.kinds.addAll(ks);
        this.offset = o;
        this.depth = d;
    }

    public List getKinds() {
        return this.kinds;
    }

    public void addKinds(List list) {
        if (list != null) {
            this.kinds.addAll(list);
        }
    }

    public void setKinds(List list) {
        this.kinds = new ArrayList();
        this.kinds.addAll(list);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return String.valueOf(VisualiserMessages.Stripe) + ": [" + this.offset + ":" + this.depth + ":" + (this.offset + this.depth) + ":" + this.stringifyKinds() + "]";
    }

    public String stringifyKinds() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.kinds.size()) {
            sb.append(" " + this.kinds.get(i) + " ");
            ++i;
        }
        return sb.toString();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setDepth(int i) {
        this.depth = i;
    }

    public String getToolTip() {
        return this.stringifyKinds();
    }

    public boolean hasKind(IMarkupKind kind) {
        int found = -1;
        int i = 0;
        while (i < this.kinds.size() && found == -1) {
            IMarkupKind element = (IMarkupKind)this.kinds.get(i);
            if (element.equals(kind)) {
                found = i;
            }
            ++i;
        }
        return found != -1;
    }

    public int compareTo(Object other) {
        if (this.getOffset() < ((Stripe)other).getOffset()) {
            return -1;
        }
        if (this.getOffset() > ((Stripe)other).getOffset()) {
            return 1;
        }
        return 0;
    }
}

