/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.preferences;

import org.eclipse.contribution.jdt.preferences.WeavableProjectListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.util.Util;

public class ReindexingJob
extends WorkspaceJob {
    public ReindexingJob() {
        super("Reindexing for JDT Weaving");
    }

    public ReindexingJob(int nothing) {
        this();
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IndexManager indexer = JavaModelManager.getIndexManager();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (WeavableProjectListener.getInstance().isWeavableProject(projects[i])) {
                projects[i].accept((IResourceVisitor)new TouchJavaLikeResourceVisitor(monitor));
                indexer.indexAll(projects[i]);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    private class TouchJavaLikeResourceVisitor
    implements IResourceVisitor {
        IProgressMonitor monitor;

        TouchJavaLikeResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && Util.isJavaLikeFileName((String)resource.getName())) {
                resource.touch(this.monitor);
            }
            return true;
        }
    }
}

