/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.exports;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.exports.AJAntScript;
import org.eclipse.ajdt.core.exports.AJBuildDirector;
import org.eclipse.ajdt.core.exports.AJCTask;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.ITask;
import org.eclipse.pde.internal.build.ant.JavacTask;
import org.eclipse.pde.internal.build.builder.ClasspathComputer2_1;
import org.eclipse.pde.internal.build.builder.ClasspathComputer3_0;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.pde.internal.build.site.compatibility.FeatureEntry;
import org.osgi.framework.Bundle;

public class AJModelBuildScriptGenerator
extends ModelBuildScriptGenerator {
    public static final String SRC_ZIP = "src.zip";
    public static final String EXPANDED_DOT = "@dot";
    public static final String DOT = ".";
    public static final String PROPERTY_INPATH = "inpath";
    public static final String PROPERTY_ASPECTPATH = "aspectpath";
    protected List aspectpath;
    protected List inpath;
    protected BundleDescription model;
    private FeatureEntry associatedEntry;
    protected String fullName;
    protected String pluginZipDestination;
    protected String pluginUpdateJarDestination;
    private AJBuildDirector featureGenerator;
    protected final String PLUGIN_DESTINATION = Utils.getPropertyFormat((String)"plugin.destination");
    private Properties permissionProperties;
    private String propertiesFileName = "build.properties";
    private String buildScriptFileName = "build.xml";
    private String customBuildCallbacks = null;
    private String customCallbacksBuildpath = null;
    private String customCallbacksFailOnError = null;
    private String customCallbacksInheritAll = null;
    private ArrayList compiledJarNames;
    private boolean dotOnTheClasspath = false;
    private boolean binaryPlugin = false;
    private boolean signJars = false;
    private List addedBundles;
    private String buildConfig;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_16;

    public void openScript(String scriptLocation, String scriptName) throws CoreException {
        if (this.script != null) {
            return;
        }
        try {
            BufferedOutputStream scriptStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(scriptLocation) + '/' + scriptName));
            try {
                this.script = new AJAntScript(scriptStream);
            }
            catch (IOException iOException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                IOException e = iOException;
                try {
                    ((OutputStream)scriptStream).close();
                    String message = NLS.bind((String)Messages.exception_writingFile, (Object)(String.valueOf(scriptLocation) + '/' + scriptName));
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
                catch (IOException iOException2) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException2, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(fileNotFoundException, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
            FileNotFoundException e = fileNotFoundException;
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)(String.valueOf(scriptLocation) + '/' + scriptName));
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    public void setBuildConfig(String config) {
        this.buildConfig = config;
    }

    public void generate() throws CoreException {
        String custom;
        if (this.binaryPlugin) {
            return;
        }
        if (this.model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, Messages.error_missingElement, null));
        }
        if (!AbstractScriptGenerator.isBuildingOSGi()) {
            this.checkBootAndRuntime();
        }
        this.initializeVariables();
        if (BundleHelper.getDefault().isDebugging()) {
            AspectJPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.ajdt.core", "Generating plugin " + this.model.getSymbolicName()));
        }
        if ((custom = (String)this.getBuildProperties().get("custom")) != null && custom.equalsIgnoreCase("true")) {
            this.updateExistingScript();
            return;
        }
        this.openScript(this.getLocation(this.model), this.buildScriptFileName);
        try {
            this.generateBuildScript();
        }
        finally {
            this.closeScript();
        }
    }

    private void checkBootAndRuntime() throws CoreException {
        if (this.getSite(false).getRegistry().getResolvedBundle("org.eclipse.core.boot") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, NLS.bind((String)Messages.exception_missingPlugin, (Object)"org.eclipse.core.boot"), null);
            throw new CoreException((IStatus)status);
        }
        if (this.getSite(false).getRegistry().getResolvedBundle("org.eclipse.core.runtime") == null) {
            Status status = new Status(4, "org.eclipse.pde.build", 5, NLS.bind((String)Messages.exception_missingPlugin, (Object)"org.eclipse.core.runtime"), null);
            throw new CoreException((IStatus)status);
        }
    }

    public static String getNormalizedName(BundleDescription bundle) {
        return String.valueOf(bundle.getSymbolicName()) + '_' + bundle.getVersion();
    }

    private void initializeVariables() throws CoreException {
        String aspectpathProp;
        this.fullName = AJModelBuildScriptGenerator.getNormalizedName(this.model);
        this.pluginZipDestination = String.valueOf(this.PLUGIN_DESTINATION) + '/' + this.fullName + ".zip";
        this.pluginUpdateJarDestination = String.valueOf(this.PLUGIN_DESTINATION) + '/' + this.fullName + ".jar";
        String[] classpathInfo = this.getClasspathEntries(this.model);
        this.dotOnTheClasspath = AJModelBuildScriptGenerator.specialDotProcessing(this.getBuildProperties(), classpathInfo);
        Properties bundleProperties = (Properties)this.model.getUserObject();
        bundleProperties.put("withDot", (Object)this.dotOnTheClasspath);
        Properties properties = this.getBuildProperties();
        this.customBuildCallbacks = properties.getProperty("customBuildCallbacks");
        if ("true".equalsIgnoreCase(this.customBuildCallbacks)) {
            this.customBuildCallbacks = "customBuildCallbacks.xml";
        } else if ("false".equalsIgnoreCase(this.customBuildCallbacks)) {
            this.customBuildCallbacks = null;
        }
        this.customCallbacksBuildpath = properties.getProperty("customBuildCallbacks.buildpath", DOT);
        this.customCallbacksFailOnError = properties.getProperty("customBuildCallbacks.failonerror", "false");
        this.customCallbacksInheritAll = properties.getProperty("customBuildCallbacks.inheritall");
        String inpathProp = this.getBuildProperties().getProperty(PROPERTY_INPATH);
        if (inpathProp != null) {
            this.inpath = new ArrayList();
            this.inpath.add(inpathProp);
        }
        if ((aspectpathProp = this.getBuildProperties().getProperty(PROPERTY_ASPECTPATH)) != null) {
            this.aspectpath = new ArrayList();
            this.aspectpath.add(aspectpathProp);
        }
    }

    protected static boolean findAndReplaceDot(String[] classpathInfo) {
        int i = 0;
        while (i < classpathInfo.length) {
            if (DOT.equals(classpathInfo[i])) {
                classpathInfo[i] = EXPANDED_DOT;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean specialDotProcessing(Properties properties, String[] classpathInfo) {
        String sourceFolder;
        AJModelBuildScriptGenerator.findAndReplaceDot(classpathInfo);
        String outputValue = properties.getProperty("output..");
        if (outputValue != null) {
            properties.setProperty("output.@dot", outputValue);
            properties.remove("output..");
        }
        if ((sourceFolder = properties.getProperty("source..")) != null) {
            String includeString;
            String extraEntries;
            String buildOrder;
            properties.setProperty("source.@dot", sourceFolder);
            properties.remove("source..");
            String excludedFromJar = properties.getProperty("exclude..");
            if (excludedFromJar != null) {
                properties.setProperty("exclude.@dot", excludedFromJar);
                properties.remove("exclude..");
            }
            if ((buildOrder = properties.getProperty("jars.compile.order")) != null) {
                String[] order = Utils.getArrayFromString((String)buildOrder);
                int i = 0;
                while (i < order.length) {
                    if (order[i].equals(DOT)) {
                        order[i] = EXPANDED_DOT;
                    }
                    ++i;
                }
                properties.setProperty("jars.compile.order", Utils.getStringFromArray((String[])order, (String)","));
            }
            if ((extraEntries = properties.getProperty("extra..")) != null) {
                properties.setProperty("extra.@dot", extraEntries);
            }
            if ((includeString = properties.getProperty("bin.includes")) != null) {
                String[] includes = Utils.getArrayFromString((String)includeString);
                int i = 0;
                while (i < includes.length) {
                    if (includes[i].equals(DOT)) {
                        includes[i] = "@dot/";
                    }
                    ++i;
                }
                properties.setProperty("bin.includes", Utils.getStringFromArray((String[])includes, (String)","));
            }
            return true;
        }
        return false;
    }

    private void generateBuildScript() throws CoreException {
        this.generatePrologue();
        this.generateBuildUpdateJarTarget();
        if (this.getBuildProperties().getProperty("sourcePlugin", null) == null) {
            this.generateBuildJarsTarget(this.model);
        } else {
            this.generateBuildJarsTargetForSourceGathering();
            this.generateEmptyBuildSourcesTarget();
        }
        this.generateGatherBinPartsTarget();
        this.generateBuildZipsTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherIndividualSourcesTarget();
        this.generateCopySourcesTarget();
        this.generateGatherLogTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateZipPluginTarget();
        this.generateEpilogue();
    }

    private void generateEmptyBuildSourcesTarget() {
        this.script.printTargetDeclaration("build.sources", null, null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTargetForSourceGathering() {
        this.script.printTargetDeclaration("build.jars", null, null, null, null);
        this.compiledJarNames = new ArrayList(0);
        Set pluginsToGatherSourceFrom = (Set)this.featureGenerator.getSourceToGather().getElementEntries().get(this.model.getSymbolicName());
        if (pluginsToGatherSourceFrom != null) {
            for (BundleDescription plugin : pluginsToGatherSourceFrom) {
                if (plugin.getSymbolicName().equals(this.model.getSymbolicName())) continue;
                IPath location = Utils.makeRelative((IPath)new Path(this.getLocation(plugin)), (IPath)new Path(this.getLocation(this.model)));
                if (Utils.isSourceBundle((BundleDescription)this.model)) continue;
                this.script.printAntTask("build.xml", location.toOSString(), "build.sources", null, null, null);
                HashMap<String, String> params = new HashMap<String, String>(1);
                params.put("destination.temp.folder", String.valueOf(Utils.getPropertyFormat((String)"basedir")) + "/src");
                this.script.printAntTask("build.xml", location.toOSString(), "gather.sources", null, null, params);
            }
        }
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() throws CoreException {
        this.script.println();
        Properties properties = this.getBuildProperties();
        ModelBuildScriptGenerator.CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        this.script.printTargetDeclaration("clean", "init", null, null, NLS.bind((String)Messages.build_plugin_clean, (Object)this.model.getSymbolicName()));
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(3);
            params.put("plugin.destination", this.PLUGIN_DESTINATION);
            params.put("temp.folder", Utils.getPropertyFormat((String)"temp.folder"));
            params.put("build.result.folder", Utils.getPropertyFormat((String)"build.result.folder"));
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "pre.clean", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        int i = 0;
        while (i < availableJars.length) {
            String jarName = ((CompiledEntry)availableJars[i]).getName(true);
            String jarLocation = this.getJARLocation(jarName);
            if (!(jarLocation.equals("") || jarLocation.startsWith("..") || jarLocation.equals(Utils.getPropertyFormat((String)"build.result.folder")))) {
                if (((CompiledEntry)availableJars[i]).type == 0) {
                    this.script.printDeleteTask(null, jarLocation, null);
                } else {
                    this.script.printDeleteTask(jarLocation, null, null);
                }
                this.script.printDeleteTask(null, this.getSRCLocation(jarName), null);
            }
            ++i;
        }
        this.script.printDeleteTask(null, this.pluginUpdateJarDestination, null);
        this.script.printDeleteTask(null, this.pluginZipDestination, null);
        this.script.printDeleteTask(Utils.getPropertyFormat((String)"temp.folder"), null, null);
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post.clean", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        this.script.printTargetEnd();
    }

    private void generateGatherLogTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(Utils.getPropertyFormat((String)"destination.temp.folder"));
        baseDestination = baseDestination.append(this.fullName);
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(1);
            params.put("destination.temp.folder", baseDestination.toString());
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "pre.gather.logs", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties();
        ModelBuildScriptGenerator.CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        int i = 0;
        while (i < availableJars.length) {
            String name = ((CompiledEntry)availableJars[i]).getName(true);
            IPath destination = baseDestination.append(name).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                this.script.printMkdirTask(destination.toString());
                destinations.add(destination);
            }
            Path logPath = new Path(String.valueOf(this.getTempJARFolderLocation(name)) + Utils.getPropertyFormat((String)"logExtension"));
            FileSet logSet = new FileSet(logPath.removeLastSegments(1).toString(), null, logPath.lastSegment(), null, null, null, null);
            this.script.printCopyTask(null, destination.toString(), new FileSet[]{logSet}, false, false);
            ++i;
        }
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post.gather.logs", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String zipName, String source) {
        this.script.println();
        this.script.printTargetDeclaration(zipName, "init", null, null, null);
        Path root = new Path(Utils.getPropertyFormat((String)"basedir"));
        this.script.printZipTask(root.append(zipName).toString(), root.append(source).toString(), false, false, null);
        this.script.printTargetEnd();
    }

    private void generateGatherSourcesTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.sources", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(Utils.getPropertyFormat((String)"destination.temp.folder"));
        baseDestination = baseDestination.append(this.fullName);
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(1);
            params.put("target.folder", baseDestination.toString());
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "pre.gather.sources", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties();
        ModelBuildScriptGenerator.CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        int i = 0;
        while (i < availableJars.length) {
            String jar = ((CompiledEntry)availableJars[i]).getName(true);
            IPath destination = baseDestination.append(jar).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                this.script.printMkdirTask(destination.toString());
                destinations.add(destination);
            }
            this.script.printCopyTask(this.getSRCLocation(jar), destination.toString(), null, false, false);
            ++i;
        }
        Properties copyParams = new Properties();
        copyParams.put("source.destination.folder", baseDestination.toString());
        this.script.printAntCallTask("copy.src.includes", true, (Map)copyParams);
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post.gather.sources", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        this.script.printTargetEnd();
    }

    private void generateGatherIndividualSourcesTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.individual.sources", "init", null, null, null);
        Path baseDestination = new Path(Utils.getPropertyFormat((String)"destination.temp.folder"));
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(1);
            params.put("target.folder", baseDestination.toString());
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "pre.gather.sources", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        Properties copyParams = new Properties();
        copyParams.put("source.destination.folder", baseDestination.toString());
        Properties properties = this.getBuildProperties();
        ModelBuildScriptGenerator.CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        int i = 0;
        while (i < availableJars.length) {
            String jar = ((CompiledEntry)availableJars[i]).getName(true);
            String srcName = AJModelBuildScriptGenerator.getSRCName(jar);
            this.script.printAntCallTask("copy." + srcName, true, (Map)copyParams);
            ++i;
        }
        this.script.printAntCallTask("copy.src.includes", true, (Map)copyParams);
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post.gather.sources", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        this.script.printTargetEnd();
    }

    private void generateCopySourcesTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("copy.src.includes", "init", null, null, null);
        Path baseDestination = new Path(Utils.getPropertyFormat((String)"source.destination.folder"));
        String include = (String)this.getBuildProperties().get("src.includes");
        String exclude = (String)this.getBuildProperties().get("src.excludes");
        if (include != null || exclude != null) {
            FileSet fileSet = new FileSet(Utils.getPropertyFormat((String)"basedir"), null, include, null, exclude, null, null);
            this.script.printCopyTask(null, baseDestination.toString(), new FileSet[]{fileSet}, false, false);
        }
        this.script.printTargetEnd();
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        Set pluginsToGatherSourceFrom;
        String includeSet;
        FileSet fileSet;
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "destination.temp.folder", null, null);
        Path destination = new Path(Utils.getPropertyFormat((String)"destination.temp.folder"));
        destination = destination.append(this.fullName);
        String root = destination.toString();
        this.script.printMkdirTask(root);
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(3);
            params.put("target.folder", root);
            params.put("build.result.folder", Utils.getPropertyFormat((String)"build.result.folder"));
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "pre.gather.bin.parts", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        ArrayList<Path> destinations = new ArrayList<Path>(5);
        destinations.add(destination);
        String include = (String)this.getBuildProperties().get("bin.includes");
        String exclude = (String)this.getBuildProperties().get("bin.excludes");
        String[] splitIncludes = Utils.getArrayFromString((String)include);
        String[] fileSetValues = new String[this.compiledJarNames.size()];
        int count = 0;
        boolean dotIncluded = false;
        int pos = Utils.isStringIn((String[])splitIncludes, (String)"@dot/");
        if (pos != -1) {
            splitIncludes[pos] = null;
            dotIncluded = true;
        }
        for (CompiledEntry entry : this.compiledJarNames) {
            String formatedName = String.valueOf(entry.getName(false)) + (entry.getType() == 1 ? "/" : "");
            if (this.dotOnTheClasspath && formatedName.startsWith(EXPANDED_DOT)) {
                dotIncluded &= true;
                continue;
            }
            fileSetValues[count++] = formatedName;
        }
        if (count != 0) {
            fileSet = new FileSet(Utils.getPropertyFormat((String)"build.result.folder"), null, Utils.getStringFromArray((String[])fileSetValues, (String)","), null, AJModelBuildScriptGenerator.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true, false);
        }
        if (dotIncluded) {
            fileSet = new FileSet(String.valueOf(Utils.getPropertyFormat((String)"build.result.folder")) + '/' + EXPANDED_DOT, null, "**", null, AJModelBuildScriptGenerator.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true, false);
        }
        if ((include != null || exclude != null) && (includeSet = AJModelBuildScriptGenerator.replaceVariables(Utils.getStringFromArray((String[])splitIncludes, (String)","), true)) != null && includeSet.length() > 0) {
            FileSet fileSet2 = new FileSet(Utils.getPropertyFormat((String)"basedir"), null, includeSet, null, AJModelBuildScriptGenerator.replaceVariables(exclude, true), null, null);
            this.script.printCopyTask(null, root, new FileSet[]{fileSet2}, true, false);
        }
        if (Utils.isSourceBundle((BundleDescription)this.model) && (pluginsToGatherSourceFrom = (Set)this.featureGenerator.getSourceToGather().getElementEntries().get(this.model.getSymbolicName())) != null) {
            for (BundleDescription plugin : pluginsToGatherSourceFrom) {
                IPath location = Utils.makeRelative((IPath)new Path(this.getLocation(plugin)), (IPath)new Path(this.getLocation(this.model)));
                HashMap<String, String> taskParams = new HashMap<String, String>(1);
                taskParams.put("destination.temp.folder", root);
                this.script.printAntTask("build.xml", location.toOSString(), "gather.individual.sources", null, null, taskParams);
            }
        }
        this.generatePermissionProperties(root);
        this.genarateIdReplacementCall(destination.toString());
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post.gather.bin.parts", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        this.script.printTargetEnd();
    }

    private void genarateIdReplacementCall(String location) {
        Properties bundleProperties = (Properties)this.model.getUserObject();
        if (bundleProperties == null) {
            return;
        }
        String qualifier = bundleProperties.getProperty("qualifier");
        if (qualifier == null) {
            return;
        }
        this.script.println("<eclipse.versionReplacer path=\"" + AntScript.getEscaped((String)location) + "\" version=\"" + this.model.getVersion() + "\"/>");
    }

    private void generatePermissionProperties(String directory) throws CoreException {
        this.getPermissionProperties();
        for (Map.Entry<Object, Object> permission : this.permissionProperties.entrySet()) {
            String instruction = (String)permission.getKey();
            String parameters = (String)permission.getValue();
            int index = instruction.indexOf("permissions");
            if (index != -1) {
                this.generateChmodInstruction(directory, instruction.substring(index + "permissions".length() + 1), parameters);
                continue;
            }
            if (!instruction.startsWith("link")) continue;
            this.generateLinkInstruction(directory, parameters);
        }
    }

    private void generateChmodInstruction(String dir, String rights, String files) {
        if (rights.equals("executable")) {
            rights = "755";
        }
        this.script.printChmod(dir, rights, files);
    }

    private void generateLinkInstruction(String dir, String files) {
        String[] links = Utils.getArrayFromString((String)files, (String)",");
        ArrayList<String> arguments = new ArrayList<String>(2);
        int i = 0;
        while (i < links.length) {
            arguments.add(links[i]);
            arguments.add(links[i + 1]);
            this.script.printExecTask("ln -s", dir, arguments, "Linux");
            arguments.clear();
            i += 2;
        }
    }

    protected Properties getPermissionProperties() throws CoreException {
        if (this.permissionProperties == null) {
            this.permissionProperties = AJModelBuildScriptGenerator.readProperties((String)this.getLocation(this.model), (String)"permissions.properties", (int)1);
        }
        return this.permissionProperties;
    }

    private void generateZipPluginTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.plugin", "init", null, null, NLS.bind((String)Messages.build_plugin_zipPlugin, (Object)this.model.getSymbolicName()));
        this.script.printDeleteTask(Utils.getPropertyFormat((String)"temp.folder"), null, null);
        this.script.printMkdirTask(Utils.getPropertyFormat((String)"temp.folder"));
        this.script.printAntCallTask("build.jars", true, null);
        this.script.printAntCallTask("build.sources", true, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", String.valueOf(Utils.getPropertyFormat((String)"temp.folder")) + '/');
        this.script.printAntCallTask("gather.bin.parts", true, params);
        this.script.printAntCallTask("gather.sources", true, params);
        FileSet fileSet = new FileSet(Utils.getPropertyFormat((String)"temp.folder"), null, "**/*.bin" + Utils.getPropertyFormat((String)"logExtension"), null, null, null, null);
        this.script.printDeleteTask(null, null, new FileSet[]{fileSet});
        this.script.printZipTask(this.pluginZipDestination, Utils.getPropertyFormat((String)"temp.folder"), true, false, null);
        this.script.printDeleteTask(Utils.getPropertyFormat((String)"temp.folder"), null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, NLS.bind((String)Messages.build_plugin_buildUpdateJar, (Object)this.model.getSymbolicName()));
        this.script.printDeleteTask(Utils.getPropertyFormat((String)"temp.folder"), null, null);
        this.script.printMkdirTask(Utils.getPropertyFormat((String)"temp.folder"));
        this.script.printAntCallTask("build.jars", true, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", String.valueOf(Utils.getPropertyFormat((String)"temp.folder")) + '/');
        this.script.printAntCallTask("gather.bin.parts", true, params);
        this.script.printJarTask(this.pluginUpdateJarDestination, String.valueOf(Utils.getPropertyFormat((String)"temp.folder")) + '/' + this.fullName, null, "merge");
        this.script.printDeleteTask(Utils.getPropertyFormat((String)"temp.folder"), null, null);
        if (this.signJars) {
            this.script.println("<eclipse.jarProcessor sign=\"" + Utils.getPropertyFormat((String)"jarProcessor.sign") + "\" pack=\"" + Utils.getPropertyFormat((String)"jarProcessor.pack200") + "\" unsign=\"" + Utils.getPropertyFormat((String)"jarProcessor.unsign") + "\" jar=\"" + AntScript.getEscaped((String)this.pluginUpdateJarDestination) + "\" alias=\"" + Utils.getPropertyFormat((String)"sign.alias") + "\" keystore=\"" + Utils.getPropertyFormat((String)"sign.keystore") + "\" storepass=\"" + Utils.getPropertyFormat((String)"sign.storepass") + "\"/>");
        }
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, Messages.build_plugin_refresh);
        this.script.printConvertPathTask(new Path(this.getLocation(this.model)).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(Utils.getPropertyFormat((String)"resourcePath"), "infinite");
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.model.getSymbolicName(), "build.jars", DOT);
        this.script.println();
        this.script.printProperty("basews", Utils.getPropertyFormat((String)"ws"));
        this.script.printProperty("baseos", Utils.getPropertyFormat((String)"os"));
        this.script.printProperty("basearch", Utils.getPropertyFormat((String)"arch"));
        this.script.printProperty("basenl", Utils.getPropertyFormat((String)"nl"));
        this.script.printProperty("bundleId", this.model.getSymbolicName());
        this.script.printProperty("bundleVersion", this.model.getVersion().toString());
        this.script.println();
        if (this.customBuildCallbacks != null && !this.customBuildCallbacks.equals("false")) {
            this.script.printAvailableTask("customBuildCallbacks", String.valueOf(this.customCallbacksBuildpath) + '/' + this.customBuildCallbacks, this.customBuildCallbacks);
            this.script.println();
        }
        this.generateCompilerSettings();
        this.script.printTargetDeclaration("init", "properties", null, null, null);
        this.script.printConditionIsSet("pluginTemp", String.valueOf(Utils.getPropertyFormat((String)"buildTempFolder")) + '/' + "plugins", "buildTempFolder");
        this.script.printProperty("pluginTemp", Utils.getPropertyFormat((String)"basedir"));
        this.script.printConditionIsSet("build.result.folder", String.valueOf(Utils.getPropertyFormat((String)"pluginTemp")) + '/' + this.model.getSymbolicName() + '_' + this.model.getVersion(), "buildTempFolder");
        this.script.printProperty("build.result.folder", Utils.getPropertyFormat((String)"basedir"));
        this.script.printProperty("temp.folder", String.valueOf(Utils.getPropertyFormat((String)"basedir")) + '/' + "temp.folder");
        this.script.printProperty("plugin.destination", Utils.getPropertyFormat((String)"basedir"));
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("properties", null, "eclipse.running", null, null);
        this.script.printProperty("build.compiler", "org.eclipse.jdt.core.JDTCompilerAdapter");
        this.script.println();
        this.script.printTargetEnd();
    }

    private void generateCompilerSettings() {
        String javacSource = null;
        String javacTarget = null;
        String bootClasspath = null;
        String jreProfile = null;
        try {
            Properties properties = this.getBuildProperties();
            javacSource = properties.getProperty("javacSource");
            javacTarget = properties.getProperty("javacTarget");
            bootClasspath = properties.getProperty("bootClasspath");
            jreProfile = properties.getProperty("jre.compilation.profile");
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        this.script.printComment(Messages.build_compilerSetting);
        this.script.printProperty("javacFailOnError", "false");
        this.script.printProperty("javacDebugInfo", "on");
        this.script.printProperty("javacVerbose", "false");
        this.script.printProperty("logExtension", ".log");
        this.script.printProperty("compilerArg", "");
        if (javacSource == null) {
            this.script.printProperty("javacSource", "1.3");
        }
        if (javacTarget == null) {
            this.script.printProperty("javacTarget", "1.2");
        }
        if (bootClasspath == null) {
            this.script.println("<condition property=\"dir_bootclasspath\" value=\"${java.home}/../Classes\">");
            this.script.println("\t<os family=\"mac\"/>");
            this.script.println("</condition>");
            this.script.println("<property name=\"dir_bootclasspath\" value=\"${java.home}/lib\"/>");
            this.script.println("<path id=\"path_bootclasspath\">");
            this.script.println("\t<fileset dir=\"${dir_bootclasspath}\">");
            this.script.println("\t\t<include name=\"*.jar\"/>");
            this.script.println("\t</fileset>");
            this.script.println("</path>");
            this.script.printPropertyRefid("bootclasspath", "path_bootclasspath");
        }
        Properties environmentMappings = AJModelBuildScriptGenerator.getExecutionEnvironmentMappings();
        if (jreProfile != null && !environmentMappings.containsKey(String.valueOf(jreProfile) + '.' + "javacSource")) {
            if (this.reportResolutionErrors) {
                Status status = new Status(4, this.model.getSymbolicName(), 4, NLS.bind((String)Messages.build_plugin_unrecognizedJRE, (Object)jreProfile), null);
                BundleHelper.getDefault().getLog().log((IStatus)status);
            }
            jreProfile = null;
        }
        if (javacSource != null) {
            this.script.printProperty("bundleJavacSource", javacSource);
        }
        if (javacTarget != null) {
            this.script.printProperty("bundleJavacTarget", javacTarget);
        }
        if (bootClasspath != null) {
            this.script.printProperty("bundleBootClasspath", bootClasspath);
        }
        String target = null;
        String[] modelEnvironments = this.model.getExecutionEnvironments();
        String[] environments = null;
        if (jreProfile != null) {
            environments = new String[modelEnvironments.length + 1];
            environments[0] = jreProfile;
            System.arraycopy(modelEnvironments, 0, environments, 1, modelEnvironments.length);
        } else {
            environments = modelEnvironments;
        }
        int i = 0;
        while (i < environments.length) {
            if (bootClasspath == null) {
                this.script.printConditionIsSet("bundleBootClasspath", Utils.getPropertyFormat((String)environments[i]), environments[i]);
            }
            String source = (String)environmentMappings.get(String.valueOf(environments[i]) + '.' + "javacSource");
            target = (String)environmentMappings.get(String.valueOf(environments[i]) + '.' + "javacTarget");
            if (javacSource == null && source != null) {
                this.script.printConditionIsSet("bundleJavacSource", source, environments[i]);
            }
            if (javacTarget == null && target != null) {
                this.script.printConditionIsSet("bundleJavacTarget", target, environments[i]);
            }
            ++i;
        }
        if (javacSource == null) {
            this.script.printProperty("bundleJavacSource", Utils.getPropertyFormat((String)"javacSource"));
        }
        if (javacTarget == null) {
            this.script.printProperty("bundleJavacTarget", Utils.getPropertyFormat((String)"javacTarget"));
        }
        if (bootClasspath == null) {
            this.script.printProperty("bundleBootClasspath", Utils.getPropertyFormat((String)"bootclasspath"));
        }
        this.script.println();
    }

    public void setModel(BundleDescription model) throws CoreException {
        if (model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, Messages.error_missingElement, null));
        }
        this.model = model = this.getSite(false).getRegistry().getVersionReplacement(model);
        if (this.getBuildProperties() == AbstractScriptGenerator.MissingProperties.getInstance()) {
            this.binaryPlugin = true;
        } else {
            this.getCompiledElements().add(model.getSymbolicName());
        }
        Properties bundleProperties = (Properties)model.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            model.setUserObject((Object)bundleProperties);
        }
        bundleProperties.put("isCompiler", this.binaryPlugin ? Boolean.FALSE : Boolean.TRUE);
    }

    public void setModelId(String modelId, String modelVersion) throws CoreException {
        BundleDescription newModel = this.getModel(modelId, modelVersion);
        if (newModel == null) {
            String message = NLS.bind((String)Messages.exception_missingElement, (Object)modelId);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, message, (Throwable)new NullPointerException()));
        }
        this.setModel(newModel);
    }

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(zipName, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + zips.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    public void setFeatureGenerator(AJBuildDirector featureGenerator) {
        this.featureGenerator = featureGenerator;
    }

    private void generateBuildJarsTarget(BundleDescription pluginModel) throws CoreException {
        Properties properties = this.getBuildProperties();
        ModelBuildScriptGenerator.CompiledEntry[] availableJars = this.extractEntriesToCompile(properties);
        this.compiledJarNames = new ArrayList(availableJars.length);
        HashMap<String, ModelBuildScriptGenerator.CompiledEntry> jars = new HashMap<String, ModelBuildScriptGenerator.CompiledEntry>(availableJars.length);
        int i = 0;
        while (i < availableJars.length) {
            jars.put(((CompiledEntry)availableJars[i]).getName(false), availableJars[i]);
            ++i;
        }
        String jarOrder = (String)this.getBuildProperties().get("jars.compile.order");
        Object classpath = AbstractScriptGenerator.isBuildingOSGi() ? new ClasspathComputer3_0((ModelBuildScriptGenerator)this) : new ClasspathComputer2_1((ModelBuildScriptGenerator)this);
        if (jarOrder != null) {
            String[] order = Utils.getArrayFromString((String)jarOrder);
            int i2 = 0;
            while (i2 < order.length) {
                CompiledEntry jar = (CompiledEntry)((Object)jars.get(order[i2]));
                if (jar != null) {
                    this.compiledJarNames.add(jar);
                    this.generateCompilationTarget(classpath.getClasspath(pluginModel, (ModelBuildScriptGenerator.CompiledEntry)jar), jar);
                    this.generateSRCTarget(jar);
                    jars.remove(order[i2]);
                }
                ++i2;
            }
        }
        for (CompiledEntry jar : jars.values()) {
            this.compiledJarNames.add(jar);
            this.generateCompilationTarget(classpath.getClasspath(pluginModel, (ModelBuildScriptGenerator.CompiledEntry)jar), jar);
            this.generateSRCTarget(jar);
        }
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, NLS.bind((String)Messages.build_plugin_buildJars, (Object)pluginModel.getSymbolicName()));
        HashMap<String, String> params = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(1);
            params.put("build.result.folder", Utils.getPropertyFormat((String)"build.result.folder"));
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "pre.build.jars", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        Iterator iter = this.compiledJarNames.iterator();
        while (iter.hasNext()) {
            String name = ((CompiledEntry)((Object)iter.next())).getName(false);
            this.script.printAvailableTask(name, AJModelBuildScriptGenerator.replaceVariables(this.getJARLocation(name), true));
            this.script.printAntCallTask(name, true, null);
        }
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post.build.jars", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "pre.build.sources", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        iter = this.compiledJarNames.iterator();
        while (iter.hasNext()) {
            String jarName = ((CompiledEntry)((Object)iter.next())).getName(false);
            String srcName = AJModelBuildScriptGenerator.getSRCName(jarName);
            this.script.printAvailableTask(srcName, this.getSRCLocation(jarName));
            this.script.printAntCallTask(srcName, true, null);
        }
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post.build.sources", this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, null);
        }
        this.script.printTargetEnd();
    }

    private void generateCompilerSettings(JavacTask javac, CompiledEntry entry, List classpath) {
        boolean res;
        String defaultEncodingVal;
        Properties properties = null;
        try {
            properties = this.getBuildProperties();
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            return;
        }
        if (properties == null && classpath.size() == 0) {
            return;
        }
        String name = entry.getName(false);
        if (name.equals(EXPANDED_DOT)) {
            name = DOT;
        }
        if ((defaultEncodingVal = properties.getProperty("javacDefaultEncoding." + name)) != null) {
            javac.setEncoding(defaultEncodingVal);
        }
        String customEncodingsVal = properties.getProperty("javacCustomEncodings." + name);
        String warningLevels = properties.getProperty("javacWarnings." + name);
        if (customEncodingsVal == null && warningLevels == null && classpath.size() == 0) {
            return;
        }
        String root = this.getLocation(this.model);
        File file = new File(root, "javaCompiler." + name.replaceAll("[\\\\/]", "_") + ".args");
        if (file.exists() && !(res = file.delete())) {
            AspectJPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ajdt.core", "Could not delete file " + file));
        }
        Writer writer = null;
        try {
            try {
                Properties data;
                String[] encodings;
                if (warningLevels != null || customEncodingsVal != null) {
                    writer = new BufferedWriter(new FileWriter(file));
                }
                if (warningLevels != null) {
                    writer.write("-warn:" + warningLevels + "\n");
                }
                if (customEncodingsVal != null && (encodings = customEncodingsVal.split(",")).length > 0) {
                    int i = 0;
                    while (i < encodings.length) {
                        writer.write("#ADAPTER#ENCODING#" + encodings[i] + "\n");
                        ++i;
                    }
                }
                if (((data = (Properties)this.model.getUserObject()) == null || !data.containsKey("convertedManifest")) && classpath.size() > 0 && classpath.get(0) instanceof ClasspathComputer3_0.ClasspathElement) {
                    for (ClasspathComputer3_0.ClasspathElement element : classpath) {
                        if (element.getPath() == null || element.getPath().length() <= 0 || element.getAccessRules().length() <= 0) continue;
                        String path = element.getPath();
                        if (path.startsWith(Utils.getPropertyFormat((String)"build.result.folder"))) {
                            path = path.substring(Utils.getPropertyFormat((String)"build.result.folder").length() + 1);
                        }
                        path = path.replaceFirst("^(\\.\\.[\\\\/])*", "");
                        if (writer == null) {
                            writer = new BufferedWriter(new FileWriter(file));
                        }
                        writer.write("#ADAPTER#ACCESS#" + path + element.getAccessRules() + "\n");
                    }
                }
                if (writer != null) {
                    javac.setCompileArgsFile(String.valueOf(Utils.getPropertyFormat((String)"basedir")) + "/" + file.getName());
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException iOException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_7);
        }
    }

    private void generateCompilationTarget(List classpath, CompiledEntry entry) {
        this.script.println();
        String name = entry.getName(false);
        this.script.printTargetDeclaration(name, "init", null, entry.getName(true), NLS.bind((String)Messages.build_plugin_jar, (Object)(String.valueOf(this.model.getSymbolicName()) + ' ' + name)));
        String destdir = this.getTempJARFolderLocation(entry.getName(true));
        this.script.printDeleteTask(destdir, null, null);
        this.script.printMkdirTask(destdir);
        this.script.printPathStructure("path", String.valueOf(name) + ".classpath", classpath);
        String[] sources = entry.getSource();
        HashMap<String, String> params = null;
        HashMap<String, Object> references = null;
        if (this.customBuildCallbacks != null) {
            params = new HashMap<String, String>(2);
            params.put("target.folder", destdir);
            int i = 1;
            while (i <= sources.length) {
                params.put("source.folder" + i, sources[i - 1]);
                ++i;
            }
            references = new HashMap<String, Object>(1);
            references.put(String.valueOf(name) + ".classpath", null);
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "pre." + name, this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, references);
        }
        this.script.printComment("compile the source code");
        String[] ajdeClasspath = null;
        try {
            this.addedBundles = new ArrayList();
            try {
                BundleDescription ajdeBundle = this.getModel("org.aspectj.ajde", null);
                if (ajdeBundle == null) {
                    ajdeBundle = this.addBundleAndRequired("org.aspectj.ajde");
                }
                ajdeClasspath = this.bundleToCP(ajdeBundle);
            }
            catch (NullPointerException nullPointerException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(nullPointerException, (Object)this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_10);
            }
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_11, (JoinPoint.StaticPart)ajc$tjp_10);
        }
        AJCTask javac = new AJCTask(this.buildConfig, ajdeClasspath);
        javac.setAspectpath(this.aspectpath);
        javac.setInpath(this.inpath);
        javac.setClasspathId(String.valueOf(name) + ".classpath");
        javac.setBootClasspath(Utils.getPropertyFormat((String)"bundleBootClasspath"));
        javac.setDestdir(destdir);
        javac.setFailOnError(Utils.getPropertyFormat((String)"javacFailOnError"));
        javac.setDebug(Utils.getPropertyFormat((String)"javacDebugInfo"));
        javac.setVerbose(Utils.getPropertyFormat((String)"javacVerbose"));
        javac.setIncludeAntRuntime("no");
        javac.setSource(Utils.getPropertyFormat((String)"bundleJavacSource"));
        javac.setTarget(Utils.getPropertyFormat((String)"bundleJavacTarget"));
        javac.setCompileArgs(Utils.getPropertyFormat((String)"compilerArg"));
        javac.setSrcdir(sources);
        javac.setLogExtension(Utils.getPropertyFormat((String)"logExtension"));
        this.generateCompilerSettings(javac, entry, classpath);
        this.script.print((ITask)javac);
        this.script.printComment("Copy necessary resources");
        FileSet[] fileSets = new FileSet[sources.length];
        int i = 0;
        while (i < sources.length) {
            String excludes = "**/*.aj, **/*.java, **/package.htm*";
            String excludedFromJar = entry.getExcludedFromJar();
            if (excludedFromJar != null) {
                excludes = String.valueOf(excludes) + ',' + excludedFromJar;
            }
            fileSets[i] = new FileSet(sources[i], null, null, null, excludes, null, null);
            ++i;
        }
        this.script.printCopyTask(null, destdir, fileSets, true, false);
        if (this.customBuildCallbacks != null) {
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post.compile." + name, this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, references);
        }
        String jarLocation = this.getJARLocation(entry.getName(true));
        this.script.printMkdirTask(new Path(jarLocation).removeLastSegments(1).toString());
        if (entry.getType() == 1) {
            FileSet[] binFolder = new FileSet[]{new FileSet(destdir, null, null, null, null, null, null)};
            this.script.printCopyTask(null, jarLocation, binFolder, true, false);
        } else {
            this.script.printJarTask(jarLocation, destdir, this.getEmbeddedManifestFile(entry, destdir));
        }
        this.script.printDeleteTask(destdir, null, null);
        if (this.customBuildCallbacks != null) {
            params.clear();
            params.put("jar.Location", jarLocation);
            this.script.printSubantTask(Utils.getPropertyFormat((String)"customBuildCallbacks"), "post." + name, this.customCallbacksBuildpath, this.customCallbacksFailOnError, this.customCallbacksInheritAll, params, references);
        }
        this.script.printTargetEnd();
    }

    private BundleDescription addBundleAndRequired(String bundleName) throws CoreException {
        PDEState state = this.getSite(false).getRegistry();
        BundleDescription realBundle = state.getBundle(bundleName, null, false);
        if (realBundle == null) {
            Location installLocation;
            int fileIndex;
            Bundle tempBundle = Platform.getBundle((String)bundleName);
            String location = tempBundle.getLocation();
            int refIndex = location.indexOf("reference:");
            if (refIndex != -1) {
                location = location.substring(refIndex + "reference:".length());
            }
            if ((fileIndex = location.indexOf("file:")) != -1) {
                location = location.substring(fileIndex + "file:".length());
            }
            if (!location.startsWith("/") && (installLocation = Platform.getInstallLocation()) != null) {
                location = String.valueOf(installLocation.getURL().getPath()) + location;
            }
            state.addBundle(new File(location));
            realBundle = state.getBundle(bundleName, null, false);
            BundleSpecification[] requiredBundles = realBundle.getRequiredBundles();
            int i = 0;
            while (i < requiredBundles.length) {
                this.addBundleAndRequired(requiredBundles[i].getName());
                ++i;
            }
        }
        return realBundle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEmbeddedManifestFile(CompiledEntry jarEntry, String destdir) {
        CoreException coreException2;
        block5: {
            String manifestName;
            try {
                manifestName = this.getBuildProperties().getProperty("manifest." + jarEntry.getName(true));
                if (manifestName == null) {
                    return null;
                }
            }
            catch (CoreException coreException2) {
                // empty catch block
                break block5;
            }
            try {
                return String.valueOf(destdir) + '/' + manifestName;
            }
            catch (CoreException coreException3) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_13);
                CoreException coreException4 = coreException3;
            }
        }
        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_13);
        return null;
    }

    protected ModelBuildScriptGenerator.CompiledEntry[] extractEntriesToCompile(Properties properties) throws CoreException {
        return AJModelBuildScriptGenerator.extractEntriesToCompile(properties, this.model);
    }

    public static ModelBuildScriptGenerator.CompiledEntry[] extractEntriesToCompile(Properties properties, BundleDescription model) throws CoreException {
        ArrayList<CompiledEntry> result = new ArrayList<CompiledEntry>(5);
        int prefixLength = "source.".length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("source.")) continue;
            key = key.substring(prefixLength);
            String[] source = Utils.getArrayFromString((String)((String)entry.getValue()));
            if (source.length == 0) {
                String message = NLS.bind((String)Messages.error_missingSourceFolder, (Object)model.getSymbolicName(), (Object)entry.getKey());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 16, message, null));
            }
            String[] output = Utils.getArrayFromString((String)properties.getProperty("output." + key));
            String[] extraClasspath = Utils.getArrayFromString((String)properties.getProperty("extra." + key));
            String excludedFromJar = properties.getProperty("exclude." + key);
            CompiledEntry newEntry = new CompiledEntry(key, source, output, extraClasspath, excludedFromJar, key.endsWith(".jar") ? (byte)0 : 1);
            result.add(newEntry);
        }
        return result.toArray(new CompiledEntry[result.size()]);
    }

    private void generateSRCTarget(CompiledEntry jar) {
        this.script.println();
        String name = jar.getName(false);
        String srcName = AJModelBuildScriptGenerator.getSRCName(name);
        this.script.printTargetDeclaration(srcName, "init", null, srcName, null);
        String[] sources = jar.getSource();
        this.filterNonExistingSourceFolders(sources);
        FileSet[] fileSets = new FileSet[sources.length];
        int count = 0;
        int i = 0;
        while (i < sources.length) {
            if (sources[i] != null) {
                fileSets[count++] = new FileSet(sources[i], null, "**/*.aj, **/*.java", null, null, null, null);
            }
            ++i;
        }
        String srcLocation = this.getSRCLocation(name);
        String srcParent = new Path(srcLocation).removeLastSegments(1).toString();
        this.script.printMkdirTask(srcParent);
        this.script.printAntCallTask("zip." + srcName, true, null);
        this.script.printTargetEnd();
        this.script.printTargetDeclaration("zip." + srcName, null, null, null, null);
        if (count != 0) {
            this.script.printZipTask(srcLocation, null, false, false, fileSets);
        }
        this.script.printTargetEnd();
        this.script.printTargetDeclaration("copy." + srcName, null, null, null, null);
        if (count != 0) {
            String dest = null;
            dest = srcName.equals(SRC_ZIP) ? new Path(srcName).removeLastSegments(1).toString() : srcName.substring(0, srcName.length() - 4);
            String toDir = String.valueOf(Utils.getPropertyFormat((String)"source.destination.folder")) + '/' + dest;
            this.script.printCopyTask(null, toDir, fileSets, true, true);
        }
        this.script.printTargetEnd();
    }

    private void filterNonExistingSourceFolders(String[] sources) {
        File pluginRoot = new File(this.getLocation(this.model));
        int i = 0;
        while (i < sources.length) {
            File file = new File(pluginRoot, sources[i]);
            if (!file.exists()) {
                sources[i] = null;
                Status status = new Status(2, "org.eclipse.pde.build", 11, NLS.bind((String)Messages.warning_cannotLocateSource, (Object)file.getAbsolutePath()), null);
                BundleHelper.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    protected String getSRCLocation(String jarName) {
        return this.getJARLocation(AJModelBuildScriptGenerator.getSRCName(jarName));
    }

    protected String getTempJARFolderLocation(String jarName) {
        Path destination = new Path(Utils.getPropertyFormat((String)"temp.folder"));
        destination = destination.append(String.valueOf(jarName) + ".bin");
        return destination.toString();
    }

    protected String getJARLocation(String jarName) {
        return new Path(Utils.getPropertyFormat((String)"build.result.folder")).append(jarName).toString();
    }

    protected String[] getClasspathEntries(BundleDescription lookedUpModel) throws CoreException {
        return (String[])this.getSite(false).getRegistry().getExtraData().get(new Long(lookedUpModel.getBundleId()));
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = AJModelBuildScriptGenerator.readProperties((String)this.model.getLocation(), (String)this.propertiesFileName, (int)(this.isIgnoreMissingPropertiesFile() ? 0 : 2));
            return this.buildProperties;
        }
        return this.buildProperties;
    }

    public static String getSRCName(String jarName) {
        if (jarName.endsWith(".jar")) {
            return String.valueOf(jarName.substring(0, jarName.length() - 4)) + SRC_ZIP;
        }
        if (jarName.equals(EXPANDED_DOT) || jarName.equals(DOT)) {
            return SRC_ZIP;
        }
        return String.valueOf(jarName.replace('/', '.')) + SRC_ZIP;
    }

    private void updateExistingScript() throws CoreException {
        String root = this.getLocation(this.model);
        File buildFile = new File(root, this.buildScriptFileName);
        if (!buildFile.exists()) {
            String message = NLS.bind((String)Messages.error_missingCustomBuildFile, (Object)buildFile);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, null));
        }
        try {
            Utils.updateVersion((File)buildFile, (String)"version.suffix", (String)this.model.getVersion().toString());
        }
        catch (IOException iOException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_15, (JoinPoint.StaticPart)ajc$tjp_16);
            IOException e = iOException;
            String message = NLS.bind((String)Messages.exception_writeScript, (Object)buildFile);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, (Throwable)e));
        }
    }

    protected static String replaceVariables(String sourceString, boolean compiledElement) {
        if (sourceString == null) {
            return null;
        }
        int i = -1;
        String result = sourceString;
        while ((i = result.indexOf("$ws$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "ws/" + Utils.getPropertyFormat((String)(compiledElement ? "ws" : "basews")) + result.substring(i + "$ws$".length());
        }
        while ((i = result.indexOf("$os$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "os/" + Utils.getPropertyFormat((String)(compiledElement ? "os" : "baseos")) + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$arch$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "arch/" + Utils.getPropertyFormat((String)(compiledElement ? "arch" : "basearch")) + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$nl$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "nl/" + Utils.getPropertyFormat((String)(compiledElement ? "nl" : "basenl")) + result.substring(i + "$nl$".length());
        }
        return result;
    }

    public BundleDescription getModel() {
        return this.model;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String propertyFileName) {
        this.propertiesFileName = propertyFileName;
    }

    public String getBuildScriptFileName() {
        return this.buildScriptFileName;
    }

    public void setBuildScriptFileName(String buildScriptFileName) {
        this.buildScriptFileName = buildScriptFileName;
    }

    public void setSignJars(boolean value) {
        this.signJars = value;
    }

    protected BundleDescription getModel(String modelId, String modelVersion) throws CoreException {
        if (modelVersion == null) {
            return this.getSite(false).getRegistry().getResolvedBundle(modelId);
        }
        return this.getSite(false).getRegistry().getResolvedBundle(modelId, modelVersion);
    }

    public FeatureEntry getAssociatedEntry() {
        return this.associatedEntry;
    }

    public void setAssociatedEntry(FeatureEntry associatedEntry) {
        this.associatedEntry = associatedEntry;
    }

    public void setAspectpath(List aspectpath) {
        this.aspectpath = aspectpath;
    }

    public void setInpath(List inpath) {
        this.inpath = inpath;
    }

    private String[] bundleToCP(BundleDescription bundle) throws CoreException {
        int i;
        if (this.addedBundles.contains(bundle)) {
            return new String[0];
        }
        this.addedBundles.add(bundle);
        if (bundle.getSymbolicName() != null && bundle.getSymbolicName().equals("org.apache.ant")) {
            return new String[0];
        }
        ArrayList<String> pathList = new ArrayList<String>();
        String loc = bundle.getLocation();
        Path absPath = new Path(loc);
        IPath basePath = Utils.makeRelative((IPath)absPath, (IPath)new Path(this.getLocation(this.model)));
        if ("jar".equalsIgnoreCase(basePath.getFileExtension())) {
            pathList.add(basePath.toString());
        } else {
            String[] cpe = this.getClasspathEntries(bundle);
            if (cpe != null) {
                i = 0;
                while (i < cpe.length) {
                    pathList.add(basePath.append(cpe[i]).toString());
                    ++i;
                }
            }
        }
        BundleDescription[] prereqs = bundle.getResolvedRequires();
        i = 0;
        while (i < prereqs.length) {
            String[] pcp = this.bundleToCP(prereqs[i]);
            pathList.addAll((Collection)Arrays.asList(pcp));
            ++i;
        }
        String[] path = new String[pathList.size()];
        pathList.toArray(path);
        return path;
    }

    static {
        Factory factory = new Factory("AJModelBuildScriptGenerator.java", Class.forName("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "java.io.IOException:", "<missing>:"), 192);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "openScript", "org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "java.lang.String:java.lang.String:", "scriptLocation:scriptName:", "org.eclipse.core.runtime.CoreException:", "void"), 184);
        ajc$tjp_10 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "generateCompilationTarget", "org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "java.util.List:org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator$CompiledEntry:", "classpath:entry:", "", "void"), 1183);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1225);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1337);
        ajc$tjp_13 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getEmbeddedManifestFile", "org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator$CompiledEntry:java.lang.String:", "jarEntry:destdir:", "", "java.lang.String"), 1331);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1337);
        ajc$tjp_15 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "java.io.IOException:", "e:"), 1511);
        ajc$tjp_16 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "updateExistingScript", "org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "", "", "org.eclipse.core.runtime.CoreException:", "void"), 1502);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "java.io.IOException:", "<missing>:"), 197);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "java.io.FileNotFoundException:", "e:"), 201);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 859);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "generateCompilerSettings", "org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "", "", "", "void"), 848);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 1095);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "generateCompilerSettings", "org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "org.eclipse.pde.internal.build.ant.JavacTask:org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator$CompiledEntry:java.util.List:", "javac:entry:classpath:", "", "void"), 1088);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "java.io.IOException:", "<missing>:"), 1171);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator", "java.lang.NullPointerException:", "<missing>:"), 1221);
    }

    protected static class CompiledEntry
    extends ModelBuildScriptGenerator.CompiledEntry {
        static final byte JAR = 0;
        static final byte FOLDER = 1;
        private String name;
        private String resolvedName;
        private String[] source;
        private String[] output;
        private String[] extraClasspath;
        private String excludedFromJar;
        byte type;

        protected CompiledEntry(String entryName, String[] entrySource, String[] entryOutput, String[] entryExtraClasspath, String excludedFromJar, byte entryType) {
            super(entryName, entrySource, entryOutput, entryExtraClasspath, excludedFromJar, entryType);
            this.name = entryName;
            this.source = entrySource;
            this.output = entryOutput;
            this.extraClasspath = entryExtraClasspath;
            this.type = entryType;
            this.excludedFromJar = excludedFromJar;
        }

        public String getName(boolean resolved) {
            if (!resolved) {
                return this.name;
            }
            if (this.resolvedName == null) {
                this.resolvedName = AJModelBuildScriptGenerator.replaceVariables(this.name, true);
            }
            return this.resolvedName;
        }

        protected String[] getSource() {
            return this.source;
        }

        public String[] getOutput() {
            return this.output;
        }

        public String[] getExtraClasspath() {
            return this.extraClasspath;
        }

        public byte getType() {
            return this.type;
        }

        public String getExcludedFromJar() {
            return this.excludedFromJar;
        }
    }
}

