/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.utils;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titanium.error.ConsoleErrorHandler;
import org.eclipse.titanium.graph.generators.ComponentGraphGenerator;
import org.eclipse.titanium.graph.generators.ModuleGraphGenerator;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.titanium.markers.export.BaseProblemExporter;
import org.eclipse.titanium.markers.export.SingleCsvProblemExporter;
import org.eclipse.titanium.metrics.MetricData;
import org.eclipse.titanium.sonar.metrics.SonarMetricsExporter;
import org.eclipse.titanium.utils.ProjectStructureExporter;

public class SonarDataExporter {
    private static final String SONAR_PROJECT_PROPERTIES_FILE = "sonar-project.properties";
    private final IProject project;

    public SonarDataExporter(IProject project) {
        this.project = project;
    }

    public void exportDataForProject() throws IOException {
        URI projectLocation = this.project.getLocationURI();
        if (projectLocation == null) {
            ErrorReporter.logError((String)"Error while getting project uri");
            return;
        }
        URI exportDir = URIUtil.append((URI)projectLocation, (String)".sonar_titanium");
        System.out.println("Export dir is: " + exportDir.getPath());
        File file = new File(exportDir);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot create output directory: " + exportDir);
        }
        try {
            this.createSonarPropertiesFile();
            this.createSrcDirIfMissing();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while creating Sonar properties file", (Throwable)e);
        }
        this.exportProjectStructure(exportDir);
        this.exportCodeSmells(exportDir);
        this.exportMetrics(exportDir);
        this.exportModuleDot(exportDir);
        this.exportComponentDot(exportDir);
        this.exportProjectStructure(exportDir);
    }

    private void createSrcDirIfMissing() {
        URI srcDir = URIUtil.append((URI)this.project.getLocationURI(), (String)"src");
        File srcDirFile = new File(srcDir);
        if (!srcDirFile.exists()) {
            srcDirFile.mkdirs();
        }
    }

    private void exportMetrics(URI exportDir) throws IOException {
        URI filePath = URIUtil.append((URI)exportDir, (String)"metrics.xml");
        File file = new File(filePath);
        FileUtils.delete((File)file);
        SonarMetricsExporter exporter = new SonarMetricsExporter();
        try {
            exporter.export(MetricData.measure(this.project), file);
        }
        catch (Exception e) {
            new ConsoleErrorHandler().reportException("Error while exporting the project metrics", e);
        }
    }

    private void exportProjectStructure(URI exportDir) throws IOException {
        URI filePath = URIUtil.append((URI)exportDir, (String)"project_structure.csv");
        File file = new File(filePath);
        FileUtils.delete((File)file);
        ProjectStructureExporter exporter = new ProjectStructureExporter(this.project);
        exporter.saveTo(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSonarPropertiesFile() throws IOException {
        URI projectLocation = this.project.getLocationURI();
        URI propertiesFileLocaiton = URIUtil.append((URI)projectLocation, (String)SONAR_PROJECT_PROPERTIES_FILE);
        File propertiesFile = new File(propertiesFileLocaiton);
        if (propertiesFile.exists()) {
            return;
        }
        String propertyFileTemplate = "/resources/sonar-project.properties";
        InputStream stream = SonarDataExporter.class.getResourceAsStream("/resources/sonar-project.properties");
        if (stream == null) {
            ErrorReporter.logError((String)"Cannot find the resource /resources/sonar-project.properties");
            return;
        }
        try {
            String content = IOUtils.inputStreamToString((InputStream)stream);
            content = content.replaceAll(Pattern.quote("___PROJECT_KEY___"), this.project.getName());
            content = content.replaceAll(Pattern.quote("___PROJECT_NAME___"), this.project.getName());
            IOUtils.writeStringToFile((File)new File(propertiesFileLocaiton), (String)content);
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    private void exportCodeSmells(URI exportDir) throws IOException {
        URI filePath = URIUtil.append((URI)exportDir, (String)"code_smells.csv");
        File file = new File(filePath);
        FileUtils.delete((File)file);
        SingleCsvProblemExporter exporter = new SingleCsvProblemExporter(this.project);
        ((BaseProblemExporter)exporter).exportMarkers((IProgressMonitor)new NullProgressMonitor(), filePath.getPath(), Calendar.getInstance().getTime());
    }

    private void exportModuleDot(URI exportDir) {
        URI filePath = URIUtil.append((URI)exportDir, (String)"module_graph.dot");
        ConsoleErrorHandler errorHandler = new ConsoleErrorHandler();
        ModuleGraphGenerator generator = new ModuleGraphGenerator(this.project, errorHandler);
        try {
            generator.generateGraph();
            GraphHandler.saveGraphToDot(generator.getGraph(), filePath.getPath(), this.project.getName());
        }
        catch (Exception e) {
            errorHandler.reportException("Error while exporting the module graph", e);
        }
    }

    private void exportComponentDot(URI exportDir) {
        URI filePath = URIUtil.append((URI)exportDir, (String)"component_graph.dot");
        ConsoleErrorHandler errorHandler = new ConsoleErrorHandler();
        ComponentGraphGenerator generator = new ComponentGraphGenerator(this.project, errorHandler);
        try {
            generator.generateGraph();
            GraphHandler.saveGraphToDot(generator.getGraph(), filePath.getPath(), this.project.getName());
        }
        catch (Exception e) {
            errorHandler.reportException("Error while exporting the component graph", e);
        }
    }
}

