/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titanium.actions.OrganizeImportsOp;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public final class OrganizeFromBrowser
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        this.doOrganizeFromBrowser();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doOrganizeFromBrowser();
        return null;
    }

    private void doOrganizeFromBrowser() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        if (structSelection.isEmpty()) {
            return;
        }
        ArrayList<IFile> files = new ArrayList<IFile>();
        LinkedList<IResource> res = new LinkedList<IResource>();
        for (Object o : structSelection.toList()) {
            if (!(o instanceof IResource)) continue;
            res.add((IResource)o);
        }
        while (!res.isEmpty()) {
            IFile file;
            String extension;
            IResource resource = (IResource)res.pollFirst();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                try {
                    for (IResource r2 : project.members()) {
                        res.addLast(r2);
                    }
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("Error while collecting members of project " + project.getName()), (Throwable)e);
                }
            }
            if (resource instanceof IFolder) {
                try {
                    IResource[] folder;
                    for (IResource r2 : folder = ((IFolder)resource).members()) {
                        res.addLast(r2);
                    }
                    continue;
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("Error while collecting members of folder " + resource.getName()), (Throwable)e);
                    continue;
                }
            }
            if (!(resource instanceof IFile) || !"ttcn".equals(extension = (file = (IFile)resource).getFileExtension()) && !"ttcn3".equals(extension)) continue;
            files.add((IFile)resource);
        }
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (reportDebugInformation) {
            TITANDebugConsole.println((String[])new String[]{"These files will be organized: " + ((Object)files).toString()});
        }
        OrganizeImportsOp operation = new OrganizeImportsOp(files);
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        try {
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while organizing imports", (Throwable)e);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while organizing imports", (Throwable)e);
            return;
        }
    }
}

