/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers;

import java.util.StringTokenizer;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyser;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.EventType;

class EventObjectFactory {
    EventObjectFactory() {
    }

    public EventObject createEventObject(EventType type, LogRecord logRecord, MessageAnalyser messageAnalyser1, int timeStampConstant) {
        EventObject eventObject = new EventObject(type);
        if (logRecord != null) {
            if (timeStampConstant == 27) {
                String timestamp = logRecord.getTimestamp();
                eventObject.setTime(EventObjectFactory.getTimeStamp(timestamp));
            } else {
                eventObject.setTime(logRecord.getTimestamp());
            }
            eventObject.setEventType(logRecord.getEventType());
            eventObject.setRecordOffset(logRecord.getRecordOffset());
            eventObject.setRecordLength(logRecord.getRecordLength());
            eventObject.setRecordNumber(logRecord.getRecordNumber());
            if (logRecord.getComponentReference() != null && logRecord.getComponentReference().trim().length() > 0) {
                eventObject.setReference(logRecord.getComponentReference());
            }
        }
        switch (type) {
            case SYSTEM_CREATE: 
            case SYSTEM_TERMINATE: {
                eventObject.setReference("system");
                break;
            }
            case MTC_CREATE: 
            case MTC_TERMINATE: {
                eventObject.setName("Main Test Component");
                eventObject.setReference("mtc");
                break;
            }
            case HC_CREATE: 
            case HC_TERMINATE: {
                eventObject.setName("Host Controller");
                eventObject.setReference("hc");
                break;
            }
            case PTC_CREATE: {
                eventObject.setReference(messageAnalyser1.getComponentCreationReference());
                eventObject.setName(messageAnalyser1.getComponentCreationName());
                break;
            }
            case PTC_DONE: {
                eventObject.setName("done");
                eventObject.setReference(messageAnalyser1.getComponentDoneReference());
                eventObject.setTarget("mtc");
                break;
            }
            case TC_START: {
                String tcName = messageAnalyser1.getTestcaseName();
                eventObject.setName(tcName);
                break;
            }
            case TC_END: {
                eventObject.setName(messageAnalyser1.getTestcaseVerdict());
                break;
            }
            case SEND: {
                String sendSource = messageAnalyser1.getSendSource();
                eventObject.setReference(sendSource);
                eventObject.setPort(sendSource);
                break;
            }
            case SILENT_EVENT: {
                if (logRecord == null) break;
                eventObject.setTarget(logRecord.getComponentReference());
                break;
            }
        }
        return eventObject;
    }

    private static String getTimeStamp(String timestamp) {
        StringTokenizer tokenizer = new StringTokenizer(timestamp, " ");
        if (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        return "";
    }
}

