/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titanium.refactoring.function.Param;

final class TextReplaceItem
implements Comparator<TextReplaceItem>,
Comparable<TextReplaceItem> {
    private static final char SEMICOLON = ';';
    private final boolean ref;
    private final ISubReference subref;
    private final Definition def;
    private final Param param;
    private final String source;
    private final int sourceOffset;
    private final int startOffset;
    private final int endOffset;

    TextReplaceItem(ISubReference subref, Param param, String sourceText, int sourceOffset) {
        this.ref = true;
        this.subref = subref;
        this.def = null;
        this.param = param;
        this.source = sourceText;
        this.sourceOffset = sourceOffset;
        this.startOffset = this.calculateStartOffset();
        this.endOffset = this.calculateEndOffset();
    }

    TextReplaceItem(Definition def, Param param, String sourceText, int sourceOffset) {
        this.ref = false;
        this.def = def;
        this.subref = null;
        this.param = param;
        this.source = sourceText;
        this.sourceOffset = sourceOffset;
        this.startOffset = this.calculateStartOffset();
        this.endOffset = this.calculateEndOffset();
    }

    private int calculateStartOffset() {
        return this.getLocation().getOffset() - this.sourceOffset;
    }

    private int calculateEndOffset() {
        int lastInd;
        int end = this.getLocation().getEndOffset() - this.sourceOffset;
        if (this.ref) {
            return end;
        }
        if (end > this.source.length()) {
            end = this.source.length();
        }
        if ((lastInd = end - 1) >= 0 && this.source.charAt(lastInd) == ';') {
            return end;
        }
        if (lastInd + 1 < this.source.length() && this.source.charAt(lastInd + 1) == ';') {
            return end + 1;
        }
        return end;
    }

    public boolean isReference() {
        return this.ref;
    }

    public StringBuilder getNewParamName() {
        return this.param.getName();
    }

    public Location getLocation() {
        if (this.ref) {
            return this.subref == null ? null : this.subref.getLocation();
        }
        return this.def == null ? null : this.def.getLocation();
    }

    public StringBuilder createText() {
        return new StringBuilder(this.source.substring(this.startOffset, this.endOffset));
    }

    public StringBuilder createBeginningText() {
        return new StringBuilder(this.source.substring(0, this.startOffset));
    }

    public StringBuilder createEndingText() {
        return new StringBuilder(this.source.substring(this.endOffset));
    }

    public StringBuilder createIntermediateText(TextReplaceItem till) {
        return new StringBuilder(this.source.substring(this.endOffset, till.startOffset));
    }

    public StringBuilder createPreDeclarationText() {
        if (this.ref) {
            return new StringBuilder();
        }
        if (this.def instanceof Def_Timer) {
            return this.createText();
        }
        if (this.def.getLocation().getEndOffset() == this.def.getIdentifier().getLocation().getEndOffset()) {
            return this.createText();
        }
        StringBuilder sb = new StringBuilder();
        int end = this.def.getIdentifier().getLocation().getEndOffset() - this.sourceOffset;
        sb.append(this.source.substring(this.startOffset, end));
        return sb;
    }

    public List<StringBuilder> createInitOnlyText() {
        ArrayList<StringBuilder> ret = new ArrayList<StringBuilder>();
        if (this.ref || this.def instanceof Def_Timer) {
            ret.add(new StringBuilder());
            return ret;
        }
        if (this.def.getLocation().getEndOffset() == this.def.getIdentifier().getLocation().getEndOffset()) {
            ret.add(new StringBuilder());
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        ret.add(this.param.getName());
        int idEnd = this.def.getIdentifier().getLocation().getEndOffset() - this.sourceOffset;
        sb.append(this.source.substring(idEnd, this.endOffset));
        ret.add(sb);
        return ret;
    }

    @Override
    public int compare(TextReplaceItem arg0, TextReplaceItem arg1) {
        int comp1;
        int o1;
        IResource f1;
        if (arg0 == arg1) {
            return 0;
        }
        if (arg0 == null) {
            return -1;
        }
        if (arg1 == null) {
            return 1;
        }
        IResource f0 = arg0.getLocation().getFile();
        if (!f0.equals((Object)(f1 = arg1.getLocation().getFile()))) {
            ErrorReporter.logError((String)"TextReplaceItem::compare(): Files differ! ");
            return f0.getFullPath().toString().compareTo(f1.getFullPath().toString());
        }
        int o0 = arg0.getLocation().getOffset();
        int n = o0 < (o1 = arg1.getLocation().getOffset()) ? -1 : (comp1 = o0 == o1 ? 0 : 1);
        if (comp1 != 0) {
            return comp1;
        }
        o0 = arg0.getLocation().getEndOffset();
        return o0 < (o1 = arg1.getLocation().getEndOffset()) ? -1 : (o0 == o1 ? 0 : 1);
    }

    @Override
    public int compareTo(TextReplaceItem arg0) {
        return this.compare(this, arg0);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof TextReplaceItem)) {
            return false;
        }
        return this.compare(this, (TextReplaceItem)arg0) == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getLocation().getFile().getFullPath().toString().hashCode();
        result = 31 * result + this.getLocation().getOffset();
        result = 31 * result + this.getLocation().getEndOffset();
        return result;
    }
}

