/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.Identifier;

public final class ProjectStructureDataCollector {
    public Map<String, Identifier> knownModules = new HashMap<String, Identifier>();
    public Map<String, Identifier> missingModules = new HashMap<String, Identifier>();
    public Map<String, List<String>> importations = new HashMap<String, List<String>>();

    public void addKnownModule(Identifier name) {
        this.knownModules.put(name.getName(), name);
        if (this.importations.containsKey(name.getName())) {
            this.importations.remove(name.getName());
        }
    }

    public void removeKnownModule(String name) {
        this.knownModules.remove(name);
        if (this.importations.containsKey(name)) {
            this.importations.remove(name);
        }
    }

    public void addImportation(Identifier from, Identifier where) {
        if (this.importations.containsKey(from.getName())) {
            List<String> importedModules = this.importations.get(from.getName());
            importedModules.add(where.getName());
        } else {
            ArrayList<String> importedModules = new ArrayList<String>();
            importedModules.add(where.getName());
            this.importations.put(from.getName(), importedModules);
        }
    }

    public void evaulateMissingModules() {
        this.missingModules.clear();
        for (List<String> importation : this.importations.values()) {
            for (String name : importation) {
                if (this.knownModules.containsKey(name)) continue;
                this.missingModules.put(name, new Identifier(Identifier.Identifier_type.ID_NAME, name));
            }
        }
    }
}

