"use strict";
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTreeContainer = void 0;
const inversify_1 = require("inversify");
const tree_widget_1 = require("./tree-widget");
const tree_model_1 = require("./tree-model");
const tree_1 = require("./tree");
const tree_selection_1 = require("./tree-selection");
const tree_selection_impl_1 = require("./tree-selection-impl");
const tree_expansion_1 = require("./tree-expansion");
const tree_navigation_1 = require("./tree-navigation");
const tree_decorator_1 = require("./tree-decorator");
const tree_search_1 = require("./tree-search");
const fuzzy_search_1 = require("./fuzzy-search");
const search_box_1 = require("./search-box");
const search_box_debounce_1 = require("./search-box-debounce");
function isTreeServices(candidate) {
    if (candidate) {
        const maybeServices = candidate;
        for (const key of Object.keys(maybeServices)) {
            if (key in defaultImplementations) {
                return true;
            }
        }
    }
    return false;
}
function createTreeContainer(parent, props) {
    const child = new inversify_1.Container({ defaultScope: 'Singleton' });
    child.parent = parent;
    const overrideServices = isTreeServices(props) ? props : {};
    for (const key of Object.keys(serviceIdentifiers)) {
        if (key === 'props') {
            const { service, identifier } = getServiceAndIdentifier(key, overrideServices);
            child.bind(identifier).toConstantValue(Object.assign(Object.assign({}, defaultImplementations.props), service));
        }
        else if (key === 'searchBoxFactory') {
            const { service, identifier } = getServiceAndIdentifier(key, overrideServices);
            child.bind(identifier).toFactory(context => service(context));
        }
        else {
            const { service, identifier } = getServiceAndIdentifier(key, overrideServices);
            child.bind(service).toSelf().inSingletonScope();
            if (identifier !== service) {
                child.bind(identifier).toService(service);
            }
        }
    }
    return child;
}
exports.createTreeContainer = createTreeContainer;
function getServiceAndIdentifier(key, overrides) {
    const override = overrides[key];
    const service = override !== null && override !== void 0 ? override : defaultImplementations[key];
    return {
        service,
        identifier: serviceIdentifiers[key]
    };
}
const defaultSearchBoxFactoryFactory = () => options => {
    const debounce = new search_box_debounce_1.SearchBoxDebounce(options);
    return new search_box_1.SearchBox(options, debounce);
};
const defaultImplementations = {
    tree: tree_1.TreeImpl,
    selectionService: tree_selection_impl_1.TreeSelectionServiceImpl,
    expansionService: tree_expansion_1.TreeExpansionServiceImpl,
    navigationService: tree_navigation_1.TreeNavigationService,
    model: tree_model_1.TreeModelImpl,
    widget: tree_widget_1.TreeWidget,
    search: tree_search_1.TreeSearch,
    fuzzy: fuzzy_search_1.FuzzySearch,
    decoratorService: tree_decorator_1.NoopTreeDecoratorService,
    props: tree_widget_1.defaultTreeProps,
    searchBoxFactory: defaultSearchBoxFactoryFactory,
};
const serviceIdentifiers = {
    tree: tree_1.Tree,
    selectionService: tree_selection_1.TreeSelectionService,
    expansionService: tree_expansion_1.TreeExpansionService,
    navigationService: tree_navigation_1.TreeNavigationService,
    model: tree_model_1.TreeModel,
    widget: tree_widget_1.TreeWidget,
    props: tree_widget_1.TreeProps,
    search: tree_search_1.TreeSearch,
    fuzzy: fuzzy_search_1.FuzzySearch,
    searchBoxFactory: search_box_1.SearchBoxFactory,
    decoratorService: tree_decorator_1.TreeDecoratorService,
};
//# sourceMappingURL=tree-container.js.map