/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.ls.core.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.ls.core.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.ls.core.internal.corrections.ASTResolving;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractFieldRefactoring
extends Refactoring {
    public static final int INITIALIZE_IN_FIELD = 0;
    public static final int INITIALIZE_IN_METHOD = 1;
    public static final int INITIALIZE_IN_CONSTRUCTOR = 2;
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    private CompilationUnit fCompilationUnitNode;
    private String[] fGuessedFieldNames;
    private LinkedProposalModelCore fLinkedProposalModel;
    private IExpressionFragment fSelectedExpression;
    private String[] fExcludedVariableNames;
    private String[] fExcludedFieldNames;
    private CompilationUnitRewrite fCURewrite;
    private boolean fDeclareFinal;
    private String fFieldName;
    private int fVisibility;
    private int fInitializeIn;
    private Map fFormatterOptions;
    private boolean fInitializerUsesLocalTypes;
    private boolean fDeclareStatic;
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";

    public ExtractFieldRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fCompilationUnitNode = null;
        this.fFieldName = "";
        this.fLinkedProposalModel = null;
        this.fVisibility = 2;
        this.fDeclareFinal = false;
        this.fDeclareStatic = false;
        this.fInitializeIn = 1;
    }

    public ExtractFieldRefactoring(CompilationUnit astRoot, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(astRoot.getTypeRoot() instanceof ICompilationUnit));
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = (ICompilationUnit)astRoot.getTypeRoot();
        this.fCompilationUnitNode = astRoot;
        this.fDeclareFinal = false;
        this.fDeclareStatic = false;
        this.fFieldName = "";
        this.fLinkedProposalModel = null;
        this.fVisibility = 2;
        this.fInitializeIn = 1;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractFieldRefactoring_name;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public int getInitializeIn() {
        return this.fInitializeIn;
    }

    public Map<String, String> getFormatterOptions() {
        return this.fFormatterOptions;
    }

    public void setInitializeIn(int initializeIn) {
        Assert.isTrue((initializeIn == 2 || initializeIn == 0 || initializeIn == 1 ? 1 : 0) != 0);
        this.fInitializeIn = initializeIn;
    }

    public void setFormatterOptions(Map<String, String> formatterOptions) {
        this.fFormatterOptions = formatterOptions;
    }

    public boolean canEnableSettingDeclareInConstructors() throws JavaModelException {
        return !this.fDeclareStatic && !this.fInitializerUsesLocalTypes && !this.getMethodDeclaration().isConstructor() && !this.isDeclaredInAnonymousClass() && !this.isDeclaredInStaticMethod();
    }

    public boolean canEnableSettingDeclareInMethod() {
        return !this.fDeclareFinal;
    }

    public boolean canEnableSettingDeclareInFieldDeclaration() {
        return !this.fInitializerUsesLocalTypes;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("", 16);
            RefactoringStatus result = Checks.validateModifiesFiles((IFile[])ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), (Object)this.getValidationContext(), (IProgressMonitor)pm);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fCompilationUnitNode == null) {
                this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, (boolean)true, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            }
            pm.worked(1);
            if (this.fCURewrite == null) {
                this.fCURewrite = new CompilationUnitRewrite(this.fCu, this.fCompilationUnitNode);
                this.fCURewrite.setFormattingOptions(this.fFormatterOptions);
                this.fCURewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new NoCommentSourceRangeComputer());
            }
            pm.worked(1);
            IExpressionFragment selectedExpression = this.getSelectedExpression();
            if (selectedExpression == null) {
                String message = RefactoringCoreMessages.ExtractTempRefactoring_select_expression;
                RefactoringStatus refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
                return refactoringStatus;
            }
            pm.worked(1);
            if (this.isUsedInExplicitConstructorCall()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_explicit_constructor);
                return refactoringStatus;
            }
            pm.worked(1);
            ASTNode associatedNode = selectedExpression.getAssociatedNode();
            if (this.getEnclosingBodyNode() == null || ASTNodes.getParent((ASTNode)associatedNode, Annotation.class) != null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_expr_in_method_or_initializer);
                return refactoringStatus;
            }
            pm.worked(1);
            if (associatedNode instanceof Name && associatedNode.getParent() instanceof ClassInstanceCreation && associatedNode.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkExpression());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkExpressionFragmentIsRValue());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            Expression associatedExpression = selectedExpression.getAssociatedExpression();
            if (ExtractFieldRefactoring.isUsedInForInitializerOrUpdater(associatedExpression)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_for_initializer_updater);
                return refactoringStatus;
            }
            pm.worked(1);
            if (ExtractFieldRefactoring.isReferringToLocalVariableFromFor(associatedExpression)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_refers_to_for_variable);
                return refactoringStatus;
            }
            pm.worked(1);
            ASTNode declaringType = this.getEnclosingTypeDeclaration();
            if (declaringType instanceof TypeDeclaration && ((TypeDeclaration)declaringType).isInterface()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractFieldRefactoring_interface_methods);
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkTempTypeForLocalTypeUsage());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            this.checkTempInitializerForLocalTypeUsage();
            this.initializeDefaults();
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 4);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkMatchingFragments());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(RefactoringCoreMessages.ExtractFieldRefactoring_creating_change, 1);
            try {
                if (this.fInitializeIn == 1) {
                    this.addInitializerToMethod();
                } else if (this.fInitializeIn == 2) {
                    this.addInitializersToConstructors(this.fCURewrite.getASTRewrite());
                }
                this.addFieldDeclaration();
                this.addReplaceExpressionWithField();
            }
            catch (CoreException exception) {
                JavaLanguageServerPlugin.logException("Problem with extract temp filed ", exception);
            }
            CompilationUnitChange compilationUnitChange = this.fCURewrite.createChange(RefactoringCoreMessages.ExtractFieldRefactoring_name, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void initializeDefaults() throws JavaModelException {
        this.fVisibility = 2;
        this.fDeclareStatic = this.isDeclaredInStaticMethod();
        this.fDeclareFinal = false;
        if (this.canEnableSettingDeclareInMethod()) {
            this.fInitializeIn = 1;
        } else if (this.canEnableSettingDeclareInFieldDeclaration()) {
            this.fInitializeIn = 0;
        } else if (this.canEnableSettingDeclareInConstructors()) {
            this.fInitializeIn = 2;
        }
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment selectedFragment = ASTFragmentFactory.createFragmentForSourceRange((ISourceRange)new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (selectedFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc((ASTNode)selectedFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)selectedFragment;
        } else if (selectedFragment != null) {
            if (selectedFragment.getAssociatedNode() instanceof ExpressionStatement) {
                ExpressionStatement exprStatement = (ExpressionStatement)selectedFragment.getAssociatedNode();
                Expression expression = exprStatement.getExpression();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
            } else if (selectedFragment.getAssociatedNode() instanceof Assignment) {
                Assignment assignment = (Assignment)selectedFragment.getAssociatedNode();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)assignment);
            }
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase((ASTNode)this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private boolean isUsedInExplicitConstructorCall() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (ASTNodes.getParent((ASTNode)selectedExpression, ConstructorInvocation.class) != null) {
            return true;
        }
        return ASTNodes.getParent((ASTNode)selectedExpression, SuperConstructorInvocation.class) != null;
    }

    private ASTNode getEnclosingBodyNode() throws JavaModelException {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        StructuralPropertyDescriptor location = null;
        while (node != null && !(node instanceof BodyDeclaration)) {
            location = node.getLocationInParent();
            if ((node = node.getParent()) instanceof LambdaExpression) break;
        }
        if (location == MethodDeclaration.BODY_PROPERTY || location == Initializer.BODY_PROPERTY || location == LambdaExpression.BODY_PROPERTY && ((LambdaExpression)node).resolveMethodBinding() != null) {
            return (ASTNode)node.getStructuralProperty(location);
        }
        return null;
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        Expression selectedExpression = this.getSelectedExpression().getAssociatedExpression();
        if (selectedExpression != null) {
            ASTNode parent = selectedExpression.getParent();
            if (selectedExpression instanceof NullLiteral) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
            }
            if (selectedExpression instanceof ArrayInitializer) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
            }
            if (selectedExpression instanceof Assignment) {
                if (parent instanceof Expression && !(parent instanceof ParenthesizedExpression)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
                }
                return null;
            }
            if (selectedExpression instanceof SimpleName) {
                if (((SimpleName)selectedExpression).isDeclaration()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
                }
                if (parent instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || parent instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
                }
            } else if (selectedExpression instanceof VariableDeclarationExpression && parent instanceof TryStatement) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_resource_in_try_with_resources);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue((Expression)this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression, null, (String)"org.eclipse.jdt.ls.core", (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_no_void, null, (String)"org.eclipse.jdt.ls.core", (int)65, null);
            }
            case 0: 
            case 3: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode parent = expression.getParent();
        if (parent instanceof ForStatement) {
            ForStatement forStmt = (ForStatement)parent;
            return forStmt.initializers().contains(expression) || forStmt.updaters().contains(expression);
        }
        return false;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        Expression current = expression;
        ASTNode parent = current.getParent();
        while (parent != null && !(parent instanceof BodyDeclaration)) {
            List initializers;
            ForStatement forStmt;
            if (parent instanceof ForStatement && ((forStmt = (ForStatement)parent).initializers().contains(current) || forStmt.updaters().contains(current) || forStmt.getExpression() == current) && (initializers = forStmt.initializers()).size() == 1 && initializers.get(0) instanceof VariableDeclarationExpression) {
                List<IVariableBinding> forInitializerVariables = ExtractFieldRefactoring.getForInitializedVariables((VariableDeclarationExpression)initializers.get(0));
                ForStatementChecker checker = new ForStatementChecker(forInitializerVariables);
                expression.accept((ASTVisitor)checker);
                if (checker.isReferringToForVariable()) {
                    return true;
                }
            }
            current = parent;
            parent = current.getParent();
        }
        return false;
    }

    private static List<IVariableBinding> getForInitializedVariables(VariableDeclarationExpression variableDeclarations) {
        ArrayList<IVariableBinding> forInitializerVariables = new ArrayList<IVariableBinding>(1);
        for (VariableDeclarationFragment fragment : variableDeclarations.fragments()) {
            IVariableBinding binding = fragment.resolveBinding();
            if (binding == null) continue;
            forInitializerVariables.add(binding);
        }
        return forInitializerVariables;
    }

    private RefactoringStatus checkTempTypeForLocalTypeUsage() throws JavaModelException {
        boolean usesLocalTypes;
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        Type resultingType = null;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        AST ast = this.fCURewrite.getAST();
        if (expression instanceof ClassInstanceCreation && (typeBinding == null || typeBinding.getTypeArguments().length == 0)) {
            resultingType = ((ClassInstanceCreation)expression).getType();
        } else if (expression instanceof CastExpression) {
            resultingType = ((CastExpression)expression).getType();
        } else {
            if (typeBinding == null) {
                typeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
            }
            if (typeBinding != null) {
                typeBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)typeBinding, (AST)ast);
                ImportRewrite importRewrite = this.fCURewrite.getImportRewrite();
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)expression, importRewrite);
                resultingType = importRewrite.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
            } else {
                resultingType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
            }
        }
        IMethodBinding declaringMethodBinding = this.getMethodDeclaration().resolveBinding();
        ITypeBinding[] methodTypeParameters = declaringMethodBinding == null ? new ITypeBinding[]{} : declaringMethodBinding.getTypeParameters();
        LocalTypeAndVariableUsageAnalyzer analyzer = new LocalTypeAndVariableUsageAnalyzer(methodTypeParameters);
        resultingType.accept((ASTVisitor)analyzer);
        boolean bl = usesLocalTypes = !analyzer.getUsageOfEnclosingNodes().isEmpty();
        if (usesLocalTypes) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractFieldRefactoring_uses_type_declared_locally);
        }
        return null;
    }

    private void checkTempInitializerForLocalTypeUsage() throws JavaModelException {
        Expression initializer = this.getSelectedExpression().getAssociatedExpression();
        IMethodBinding declaringMethodBinding = this.getMethodDeclaration().resolveBinding();
        ITypeBinding[] methodTypeParameters = declaringMethodBinding == null ? new ITypeBinding[]{} : declaringMethodBinding.getTypeParameters();
        LocalTypeAndVariableUsageAnalyzer localTypeAnalyer = new LocalTypeAndVariableUsageAnalyzer(methodTypeParameters);
        initializer.accept((ASTVisitor)localTypeAnalyer);
        this.fInitializerUsesLocalTypes = !localTypeAnalyer.getUsageOfEnclosingNodes().isEmpty();
    }

    public void setLinkedProposalModel(LinkedProposalModelCore linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    public String guessFieldName() {
        String[] proposals = this.guessFieldNames();
        if (proposals.length == 0) {
            return this.fFieldName;
        }
        return proposals[0];
    }

    public String[] guessFieldNames() {
        if (this.fGuessedFieldNames == null) {
            try {
                Expression expression = this.getSelectedExpression().getAssociatedExpression();
                if (expression != null) {
                    ITypeBinding binding = this.guessBindingForReference(expression);
                    int modifiers = this.getModifiers();
                    int variableKind = Flags.isFinal((int)modifiers) && Flags.isStatic((int)modifiers) ? 3 : (Flags.isStatic((int)modifiers) ? 1 : 2);
                    this.fGuessedFieldNames = StubUtility.getVariableNameSuggestions((int)variableKind, (IJavaProject)this.fCu.getJavaProject(), (ITypeBinding)binding, (Expression)expression, Arrays.asList(this.getExcludedFieldNames()));
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            if (this.fGuessedFieldNames == null) {
                this.fGuessedFieldNames = new String[0];
            }
        }
        return this.fGuessedFieldNames;
    }

    private ITypeBinding guessBindingForReference(Expression expression) {
        ITypeBinding binding = expression.resolveTypeBinding();
        if (binding == null) {
            binding = ASTResolving.guessBindingForReference((ASTNode)expression);
        }
        return binding;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            ArrayList<String> excludedNames = new ArrayList<String>();
            try {
                IBinding[] bindings = new ScopeAnalyzer(this.fCompilationUnitNode).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 18);
                int i = 0;
                while (i < bindings.length) {
                    excludedNames.add(bindings[i].getName());
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            this.fExcludedVariableNames = excludedNames.toArray(new String[0]);
        }
        return this.fExcludedVariableNames;
    }

    private String[] getExcludedFieldNames() {
        if (this.fExcludedFieldNames == null) {
            ArrayList<String> result = new ArrayList<String>();
            try {
                ASTNode type = this.getEnclosingTypeDeclaration();
                if (type instanceof TypeDeclaration) {
                    FieldDeclaration[] fields = ((TypeDeclaration)type).getFields();
                    int i = 0;
                    while (i < fields.length) {
                        for (VariableDeclarationFragment field : fields[i].fragments()) {
                            result.add(field.getName().getIdentifier());
                        }
                        ++i;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            this.fExcludedFieldNames = result.toArray(new String[result.size()]);
        }
        return this.fExcludedFieldNames;
    }

    public void setFieldName(String guessFieldName) {
        this.fFieldName = guessFieldName;
    }

    private boolean isStandaloneExpression() throws JavaModelException {
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        ASTNode target = selectedFragment.getAssociatedNode();
        ASTNode parent = target.getParent();
        return (parent instanceof ExpressionStatement || parent instanceof LambdaExpression) && selectedFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(target));
    }

    /*
     * Unable to fully structure code
     */
    private void addInitializerToMethod() throws CoreException {
        vds = this.createNewAssignmentStatement();
        selectedFragment = this.getSelectedExpression();
        selectedExpression = selectedFragment.getAssociatedExpression();
        target = selectedFragment.getAssociatedNode();
        rewrite = this.fCURewrite.getASTRewrite();
        ast = this.fCURewrite.getAST();
        groupDescription = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractFieldRefactoring_initialize_field);
        parent = target.getParent();
        locationInParent = target.getLocationInParent();
        if (!this.isStandaloneExpression()) ** GOTO lbl57
        if (parent instanceof LambdaExpression) {
            blockBody = ast.newBlock();
            blockBody.statements().add(vds);
            if (!Bindings.isVoidType((ITypeBinding)((LambdaExpression)parent).resolveMethodBinding().getReturnType())) {
                returnStatement = ast.newReturnStatement();
                returnStatement.setExpression((Expression)ast.newSimpleName(this.fFieldName));
                blockBody.statements().add(returnStatement);
            }
            replacement = blockBody;
        } else if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)parent.getLocationInParent())) {
            block = ast.newBlock();
            block.statements().add(vds);
            replacement = block;
        } else {
            replacement = vds;
        }
        replacee = parent instanceof LambdaExpression != false || ASTNodes.hasSemicolon((ExpressionStatement)((ExpressionStatement)parent), (ICompilationUnit)this.fCu) == false ? selectedExpression : parent;
        rewrite.replace((ASTNode)replacee, (ASTNode)replacement, groupDescription);
        return;
lbl-1000:
        // 1 sources

        {
            if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)locationInParent)) {
                replacement = rewrite.getAST().newBlock();
                replacementRewrite = rewrite.getListRewrite((ASTNode)replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst((ASTNode)vds, null);
                replacementRewrite.insertLast(rewrite.createMoveTarget(target), null);
                rewrite.replace(target, (ASTNode)replacement, groupDescription);
                return;
            }
            if (locationInParent == LambdaExpression.BODY_PROPERTY && ((LambdaExpression)parent).getBody() instanceof Expression) {
                replacement = rewrite.getAST().newBlock();
                replacementRewrite = rewrite.getListRewrite((ASTNode)replacement, Block.STATEMENTS_PROPERTY);
                replacementRewrite.insertFirst((ASTNode)vds, null);
                moveTarget = rewrite.createMoveTarget(target);
                if (Bindings.isVoidType((ITypeBinding)((LambdaExpression)parent).resolveMethodBinding().getReturnType())) {
                    expressionStatement = ast.newExpressionStatement((Expression)moveTarget);
                    moveTarget = expressionStatement;
                } else {
                    returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)moveTarget);
                    moveTarget = returnStatement;
                }
                replacementRewrite.insertLast(moveTarget, null);
                rewrite.replace(target, (ASTNode)replacement, groupDescription);
                return;
            }
            target = parent;
            parent = parent.getParent();
            locationInParent = target.getLocationInParent();
lbl57:
            // 2 sources

            ** while (locationInParent != Block.STATEMENTS_PROPERTY && locationInParent != SwitchStatement.STATEMENTS_PROPERTY)
        }
lbl58:
        // 1 sources

        listRewrite = rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)locationInParent);
        listRewrite.insertBefore((ASTNode)vds, target, groupDescription);
    }

    private void addInitializersToConstructors(ASTRewrite rewrite) throws CoreException {
        Assert.isTrue((!this.isDeclaredInAnonymousClass() ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        MethodDeclaration[] constructors = ExtractFieldRefactoring.getAllConstructors(declaration);
        if (constructors.length == 0) {
            AST ast = rewrite.getAST();
            MethodDeclaration newConstructor = ast.newMethodDeclaration();
            newConstructor.setConstructor(true);
            newConstructor.modifiers().addAll(ast.newModifiers(declaration.getModifiers() & 7));
            newConstructor.setName(ast.newSimpleName(declaration.getName().getIdentifier()));
            newConstructor.setBody(ast.newBlock());
            this.addFieldInitializationToConstructor(rewrite, newConstructor);
            int insertionIndex = this.computeInsertIndexForNewConstructor(declaration);
            rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newConstructor, insertionIndex, null);
        } else {
            int index = 0;
            while (index < constructors.length) {
                if (ExtractFieldRefactoring.shouldInsertTempInitialization(constructors[index])) {
                    this.addFieldInitializationToConstructor(rewrite, constructors[index]);
                }
                ++index;
            }
        }
    }

    private static MethodDeclaration[] getAllConstructors(AbstractTypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof TypeDeclaration) {
            MethodDeclaration[] allMethods = ((TypeDeclaration)typeDeclaration).getMethods();
            ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(Math.min(allMethods.length, 1));
            int i = 0;
            while (i < allMethods.length) {
                MethodDeclaration declaration = allMethods[i];
                if (declaration.isConstructor()) {
                    result.add(declaration);
                }
                ++i;
            }
            return result.toArray(new MethodDeclaration[result.size()]);
        }
        return new MethodDeclaration[0];
    }

    private void addFieldInitializationToConstructor(ASTRewrite rewrite, MethodDeclaration constructor) throws JavaModelException {
        if (constructor.getBody() == null) {
            constructor.setBody(this.fCURewrite.getAST().newBlock());
        }
        Statement newStatement = this.createNewAssignmentStatement();
        rewrite.getListRewrite((ASTNode)constructor.getBody(), Block.STATEMENTS_PROPERTY).insertLast((ASTNode)newStatement, null);
    }

    private int computeInsertIndexForNewConstructor(AbstractTypeDeclaration declaration) {
        List declarations = declaration.bodyDeclarations();
        if (declarations.isEmpty()) {
            return 0;
        }
        int index = this.findFirstMethodIndex(declaration);
        if (index == -1) {
            return declarations.size();
        }
        return index;
    }

    private int findFirstMethodIndex(AbstractTypeDeclaration typeDeclaration) {
        int i = 0;
        int n = typeDeclaration.bodyDeclarations().size();
        while (i < n) {
            if (typeDeclaration.bodyDeclarations().get(i) instanceof MethodDeclaration) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean shouldInsertTempInitialization(MethodDeclaration constructor) {
        Assert.isTrue((boolean)constructor.isConstructor());
        if (constructor.getBody() == null) {
            return false;
        }
        List statements = constructor.getBody().statements();
        if (statements == null) {
            return false;
        }
        return statements.size() <= 0 || !(statements.get(0) instanceof ConstructorInvocation);
    }

    private void addFieldDeclaration() throws CoreException {
        FieldDeclaration[] fields = this.getFieldDeclarations();
        ASTNode parent = this.getEnclosingTypeDeclaration();
        ChildListPropertyDescriptor descriptor = ASTNodes.getBodyDeclarationsProperty((ASTNode)parent);
        int insertIndex = fields.length == 0 ? 0 : ASTNodes.getBodyDeclarations((ASTNode)parent).indexOf(fields[fields.length - 1]) + 1;
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        FieldDeclaration declaration = this.createNewFieldDeclaration(rewrite);
        rewrite.getListRewrite(parent, descriptor).insertAt((ASTNode)declaration, insertIndex, null);
    }

    private FieldDeclaration createNewFieldDeclaration(ASTRewrite rewrite) throws CoreException {
        AST ast = this.fCURewrite.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        SimpleName variableName = ast.newSimpleName(this.fFieldName);
        fragment.setName(variableName);
        if (this.fLinkedProposalModel != null) {
            this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(rewrite.track((ASTNode)variableName), false);
        }
        if (this.fInitializeIn == 0) {
            Expression initializer = this.getSelectedExpression().createCopyTarget(this.fCURewrite.getASTRewrite(), true);
            fragment.setInitializer(initializer);
        }
        FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(fragment);
        fieldDeclaration.setType(this.createFieldType());
        fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers((AST)ast, (int)this.getModifiers()));
        return fieldDeclaration;
    }

    private FieldDeclaration[] getFieldDeclarations() throws JavaModelException {
        List bodyDeclarations = ASTNodes.getBodyDeclarations((ASTNode)this.getEnclosingTypeDeclaration());
        ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>(1);
        for (Object each : bodyDeclarations) {
            if (!(each instanceof FieldDeclaration)) continue;
            fields.add((FieldDeclaration)each);
        }
        return fields.toArray(new FieldDeclaration[fields.size()]);
    }

    private MethodDeclaration getMethodDeclaration() throws JavaModelException {
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)this.getSelectedExpression().getAssociatedNode(), MethodDeclaration.class);
    }

    private ASTNode getEnclosingTypeDeclaration() throws JavaModelException {
        if (this.isDeclaredInLambdaExpression()) {
            return ASTNodes.getParent((ASTNode)this.getSelectedExpression().getAssociatedNode(), AbstractTypeDeclaration.class);
        }
        return this.getMethodDeclaration().getParent();
    }

    private String getEnclosingTypeName() throws JavaModelException {
        ASTNode node = this.getEnclosingTypeDeclaration();
        ITypeBinding typeBinding = ASTNodes.getEnclosingType((ASTNode)node);
        return typeBinding == null ? "" : typeBinding.getName();
    }

    private boolean isDeclaredInLambdaExpression() throws JavaModelException {
        ASTNode node = this.getSelectedExpression().getAssociatedNode();
        while (node != null && !(node instanceof BodyDeclaration)) {
            if (!((node = node.getParent()) instanceof LambdaExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean isDeclaredInAnonymousClass() throws JavaModelException {
        return ASTNodes.getParent((ASTNode)this.getSelectedExpression().getAssociatedNode(), AnonymousClassDeclaration.class) != null;
    }

    private Statement createNewAssignmentStatement() throws JavaModelException {
        AST ast = this.fCURewrite.getAST();
        Assignment assignment = ast.newAssignment();
        SimpleName fieldName = ast.newSimpleName(this.fFieldName);
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        if (this.fLinkedProposalModel != null) {
            this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(rewrite.track((ASTNode)fieldName), true);
        }
        assignment.setLeftHandSide(this.wrapAsFieldAccessExpression(fieldName));
        assignment.setRightHandSide(this.getSelectedExpression().createCopyTarget(rewrite, true));
        return ast.newExpressionStatement((Expression)assignment);
    }

    private Expression wrapAsFieldAccessExpression(SimpleName fieldName) {
        AST ast = this.fCURewrite.getAST();
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        List<String> variableNames = Arrays.asList(this.getExcludedVariableNames());
        if (variableNames.contains(this.fFieldName)) {
            int modifiers = this.getModifiers();
            if (Flags.isStatic((int)modifiers)) {
                try {
                    String enclosingTypeName = this.getEnclosingTypeName();
                    SimpleName typeName = ast.newSimpleName(enclosingTypeName);
                    if (this.fLinkedProposalModel != null) {
                        this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(rewrite.track((ASTNode)typeName), false);
                    }
                    QualifiedName qualifiedName = ast.newQualifiedName((Name)typeName, fieldName);
                    return qualifiedName;
                }
                catch (JavaModelException e) {
                    return this.wrapAsFieldAccess(fieldName, ast);
                }
            }
            return this.wrapAsFieldAccess(fieldName, ast);
        }
        return fieldName;
    }

    private FieldAccess wrapAsFieldAccess(SimpleName fieldName, AST ast) {
        SimpleName qualifierName = null;
        try {
            if (this.isDeclaredInLambdaExpression()) {
                String enclosingTypeName = this.getEnclosingTypeName();
                qualifierName = ast.newSimpleName(enclosingTypeName);
            }
        }
        catch (JavaModelException enclosingTypeName) {
            // empty catch block
        }
        FieldAccess fieldAccess = ast.newFieldAccess();
        ThisExpression thisExpression = ast.newThisExpression();
        if (qualifierName != null) {
            thisExpression.setQualifier((Name)qualifierName);
        }
        fieldAccess.setExpression((Expression)thisExpression);
        fieldAccess.setName(fieldName);
        return fieldAccess;
    }

    private Type createFieldType() throws CoreException {
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        Type resultingType = null;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        AST ast = rewrite.getAST();
        if (expression instanceof ClassInstanceCreation && (typeBinding == null || typeBinding.getTypeArguments().length == 0)) {
            resultingType = (Type)rewrite.createCopyTarget((ASTNode)((ClassInstanceCreation)expression).getType());
        } else if (expression instanceof CastExpression) {
            resultingType = (Type)rewrite.createCopyTarget((ASTNode)((CastExpression)expression).getType());
        } else {
            if (typeBinding == null) {
                typeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
            }
            if (typeBinding != null) {
                typeBinding = Bindings.normalizeForDeclarationUse((ITypeBinding)typeBinding, (AST)ast);
                ImportRewrite importRewrite = this.fCURewrite.getImportRewrite();
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)expression, importRewrite);
                resultingType = importRewrite.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.LOCAL_VARIABLE);
            } else {
                resultingType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
            }
        }
        if (this.fLinkedProposalModel != null) {
            LinkedProposalPositionGroupCore typeGroup = this.fLinkedProposalModel.getPositionGroup(KEY_TYPE, true);
            typeGroup.addPosition(rewrite.track((ASTNode)resultingType), false);
            if (typeBinding != null) {
                ITypeBinding[] relaxingTypes = ASTResolving.getNarrowingTypes((AST)ast, (ITypeBinding)typeBinding);
                int i = 0;
                while (i < relaxingTypes.length) {
                    typeGroup.addProposal(relaxingTypes[i], this.fCURewrite.getCu(), relaxingTypes.length - i);
                    ++i;
                }
            }
        }
        return resultingType;
    }

    private void addReplaceExpressionWithField() throws JavaModelException {
        ASTRewrite rewrite = this.fCURewrite.getASTRewrite();
        AST ast = this.fCURewrite.getAST();
        TextEditGroup groupDescription = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractFieldRefactoring_initialize_field);
        IExpressionFragment selectedFragment = this.getSelectedExpression();
        Expression selectedExpression = selectedFragment.getAssociatedExpression();
        ASTNode target = this.getSelectedExpression().getAssociatedNode();
        ASTNode parent = target.getParent();
        if (this.isStandaloneExpression() && (this.fInitializeIn == 0 || this.fInitializeIn == 2)) {
            Expression replacee;
            Object object = replacee = parent instanceof LambdaExpression || !ASTNodes.hasSemicolon((ExpressionStatement)((ExpressionStatement)parent), (ICompilationUnit)this.fCu) ? selectedExpression : parent;
            if (parent instanceof LambdaExpression || ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)parent.getLocationInParent())) {
                SimpleName fieldName = ast.newSimpleName(this.fFieldName);
                Expression replacement = this.wrapAsFieldAccessExpression(fieldName);
                if (this.fLinkedProposalModel != null) {
                    this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(rewrite.track((ASTNode)replacement), false);
                }
                rewrite.replace((ASTNode)replacee, (ASTNode)replacement, groupDescription);
            } else {
                rewrite.remove((ASTNode)replacee, groupDescription);
            }
            return;
        }
        IASTFragment[] fragmentsToReplace = ExtractFieldRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        HashSet<IASTFragment> seen = new HashSet<IASTFragment>();
        int i = 0;
        while (i < fragmentsToReplace.length) {
            IASTFragment fragment = fragmentsToReplace[i];
            if (seen.add(fragment)) {
                SimpleName fieldName = ast.newSimpleName(this.fFieldName);
                Expression replacer = this.wrapAsFieldAccessExpression(fieldName);
                TextEditGroup description = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_replace);
                fragment.replace(rewrite, (ASTNode)replacer, description);
                if (this.fLinkedProposalModel != null) {
                    this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(rewrite.track((ASTNode)replacer), false);
                }
            }
            ++i;
        }
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] allMatches) {
        ArrayList<IASTFragment> result = new ArrayList<IASTFragment>(allMatches.length);
        int i = 0;
        while (i < allMatches.length) {
            if (ExtractFieldRefactoring.canReplace(allMatches[i])) {
                result.add(allMatches[i]);
            }
            ++i;
        }
        return result.toArray(new IASTFragment[result.size()]);
    }

    private static boolean canReplace(IASTFragment fragment) {
        VariableDeclarationFragment vdf;
        ASTNode node = fragment.getAssociatedNode();
        ASTNode parent = node.getParent();
        if (parent instanceof VariableDeclarationFragment && node.equals((Object)(vdf = (VariableDeclarationFragment)parent).getName())) {
            return false;
        }
        if (ExtractFieldRefactoring.isMethodParameter(node)) {
            return false;
        }
        if (ExtractFieldRefactoring.isThrowableInCatchBlock(node)) {
            return false;
        }
        if (parent instanceof ExpressionStatement) {
            return false;
        }
        if (parent instanceof LambdaExpression) {
            return false;
        }
        if (ExtractFieldRefactoring.isLeftValue(node)) {
            return false;
        }
        if (ExtractFieldRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
            return false;
        }
        if (ExtractFieldRefactoring.isUsedInForInitializerOrUpdater((Expression)node)) {
            return false;
        }
        return !(parent instanceof SwitchCase);
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration;
    }

    private static boolean isThrowableInCatchBlock(ASTNode node) {
        return node instanceof SimpleName && node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isLeftValue(ASTNode node) {
        Assignment assignment;
        ASTNode parent = node.getParent();
        if (parent instanceof Assignment && (assignment = (Assignment)parent).getLeftHandSide() == node) {
            return true;
        }
        if (parent instanceof PostfixExpression) {
            return true;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression.Operator op = ((PrefixExpression)parent).getOperator();
            if (op.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return op.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private IASTFragment[] getMatchingFragments() throws JavaModelException {
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private RefactoringStatus checkMatchingFragments() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IASTFragment[] matchingFragments = this.getMatchingFragments();
        int i = 0;
        while (i < matchingFragments.length) {
            ASTNode node = matchingFragments[i].getAssociatedNode();
            if (ExtractFieldRefactoring.isLeftValue(node) && !ExtractFieldRefactoring.isReferringToLocalVariableFromFor((Expression)node)) {
                String msg = RefactoringCoreMessages.ExtractTempRefactoring_assigned_to;
                result.addWarning(msg, JavaStatusContext.create((ITypeRoot)this.fCu, (ASTNode)node));
            }
            ++i;
        }
        return result;
    }

    private int getModifiers() {
        int flags = this.fVisibility;
        if (this.isDeclaredInStaticMethod()) {
            flags |= 8;
        }
        return flags;
    }

    private boolean isDeclaredInStaticMethod() {
        try {
            return Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection<IVariableBinding> fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection<IVariableBinding> forInitializerVariables) {
            Assert.isNotNull(forInitializerVariables);
            this.fForInitializerVariables = forInitializerVariables;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding != null && this.fForInitializerVariables.contains(binding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }

    private static class LocalTypeAndVariableUsageAnalyzer
    extends HierarchicalASTVisitor {
        private final List<IBinding> fLocalDefinitions = new ArrayList<IBinding>(0);
        private final List<SimpleName> fLocalReferencesToEnclosing = new ArrayList<SimpleName>(0);
        private final List<ITypeBinding> fMethodTypeVariables;
        private boolean fClassTypeVariablesUsed = false;

        public LocalTypeAndVariableUsageAnalyzer(ITypeBinding[] methodTypeVariables) {
            this.fMethodTypeVariables = Arrays.asList(methodTypeVariables);
        }

        public List<SimpleName> getUsageOfEnclosingNodes() {
            return this.fLocalReferencesToEnclosing;
        }

        public boolean getClassTypeVariablesUsed() {
            return this.fClassTypeVariablesUsed;
        }

        public boolean visit(SimpleName node) {
            IBinding binding;
            ITypeBinding typeBinding = node.resolveTypeBinding();
            if (typeBinding != null && typeBinding.isLocal()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add((IBinding)typeBinding);
                } else if (!this.fLocalDefinitions.contains(typeBinding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            if (typeBinding != null && typeBinding.isTypeVariable()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add((IBinding)typeBinding);
                } else if (!this.fLocalDefinitions.contains(typeBinding)) {
                    if (this.fMethodTypeVariables.contains(typeBinding)) {
                        this.fLocalReferencesToEnclosing.add(node);
                    } else {
                        this.fClassTypeVariablesUsed = true;
                    }
                }
            }
            if ((binding = node.resolveBinding()) != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(binding);
                } else if (!this.fLocalDefinitions.contains(binding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            return super.visit(node);
        }
    }
}

