/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.model;

import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;

public class TestItem {
    private String id;
    private String displayName;
    private String fullName;
    private List<String> children;
    private TestLevel level;
    private TestKind kind;
    private String project;
    private Location location;

    public TestItem(String displayName, String fullName, String uri, String project, Range range, TestLevel level, TestKind kind) {
        this.displayName = displayName;
        this.fullName = fullName;
        this.level = level;
        this.kind = kind;
        this.project = project;
        this.location = new Location(uri, range);
        this.id = String.format("%s@%s", project, fullName);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public List<String> getChildren() {
        return this.children;
    }

    public void setChildren(List<String> children) {
        this.children = children;
    }

    public TestLevel getLevel() {
        return this.level;
    }

    public void setLevel(TestLevel level) {
        this.level = level;
    }

    public TestKind getKind() {
        return this.kind;
    }

    public void setKind(TestKind kind) {
        this.kind = kind;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void addChild(String child) {
        if (this.children == null) {
            this.children = new ArrayList<String>();
        }
        this.children.add(child);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }
}

