/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.compiler.util.HashtableOfLong;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.util.Util;

public class MatchingNodeSet {
    SimpleLookupTable matchingNodes = new SimpleLookupTable(3);
    private final HashtableOfLong matchingNodesKeys = new HashtableOfLong(3);
    static Integer EXACT_MATCH = 0;
    static Integer POTENTIAL_MATCH = 1;
    static Integer ERASURE_MATCH = 16;
    public boolean mustResolve;
    SimpleSet possibleMatchingNodesSet = new SimpleSet(7);
    private final HashtableOfLong possibleMatchingNodesKeys = new HashtableOfLong(7);
    private Set<ASTNode> possibleASTNodes = new LinkedHashSet<ASTNode>();
    public final Map<ASTNode, Integer> trustedASTNodeLevels = new LinkedHashMap<ASTNode, Integer>();

    public MatchingNodeSet(boolean mustResolvePattern) {
        this.mustResolve = mustResolvePattern;
    }

    public int addMatch(org.eclipse.jdt.internal.compiler.ast.ASTNode node, int matchLevel) {
        int maskedLevel = matchLevel & 0xF;
        switch (maskedLevel) {
            case 1: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, (Integer)(1 + (matchLevel & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(node, POTENTIAL_MATCH);
                break;
            }
            case 2: {
                this.addPossibleMatch(node);
                break;
            }
            case 4: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, (Integer)(16 + (matchLevel & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(node, ERASURE_MATCH);
                break;
            }
            case 3: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, (Integer)(0 + (matchLevel & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(node, EXACT_MATCH);
            }
        }
        return matchLevel;
    }

    public int addMatch(ASTNode node, int matchLevel) {
        int maskedLevel = matchLevel & 0xF;
        switch (maskedLevel) {
            case 1: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, (Integer)(1 + (matchLevel & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(node, POTENTIAL_MATCH);
                break;
            }
            case 2: {
                this.addPossibleMatch(node);
                break;
            }
            case 4: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, (Integer)(16 + (matchLevel & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(node, ERASURE_MATCH);
                break;
            }
            case 3: {
                if (matchLevel != maskedLevel) {
                    this.addTrustedMatch(node, (Integer)(0 + (matchLevel & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(node, EXACT_MATCH);
            }
        }
        return matchLevel;
    }

    public void addPossibleMatch(ASTNode node) {
        this.possibleASTNodes.add(node);
    }

    public void addPossibleMatch(org.eclipse.jdt.internal.compiler.ast.ASTNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        org.eclipse.jdt.internal.compiler.ast.ASTNode existing = (org.eclipse.jdt.internal.compiler.ast.ASTNode)this.possibleMatchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.possibleMatchingNodesSet.remove((Object)existing);
        }
        this.possibleMatchingNodesSet.add((Object)node);
        this.possibleMatchingNodesKeys.put(key, (Object)node);
    }

    public void addTrustedMatch(org.eclipse.jdt.internal.compiler.ast.ASTNode node, boolean isExact) {
        this.addTrustedMatch(node, isExact ? EXACT_MATCH : POTENTIAL_MATCH);
    }

    public void addTrustedMatch(ASTNode node, boolean isExact) {
        this.addTrustedMatch(node, isExact ? EXACT_MATCH : POTENTIAL_MATCH);
    }

    void addTrustedMatch(org.eclipse.jdt.internal.compiler.ast.ASTNode node, Integer level) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        org.eclipse.jdt.internal.compiler.ast.ASTNode existing = (org.eclipse.jdt.internal.compiler.ast.ASTNode)this.matchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.matchingNodes.removeKey((Object)existing);
        }
        this.matchingNodes.put((Object)node, (Object)level);
        this.matchingNodesKeys.put(key, (Object)node);
    }

    void addTrustedMatch(ASTNode node, Integer level) {
        this.trustedASTNodeLevels.put(node, level);
    }

    protected boolean hasPossibleNodes(int start, int end) {
        org.eclipse.jdt.internal.compiler.ast.ASTNode node2;
        Object n;
        Object[] nodes;
        Object[] objectArray = nodes = this.possibleMatchingNodesSet.values;
        int n2 = nodes.length;
        int n3 = 0;
        while (n3 < n2) {
            n = objectArray[n3];
            node2 = (org.eclipse.jdt.internal.compiler.ast.ASTNode)n;
            if (node2 != null && start <= node2.sourceStart && node2.sourceEnd <= end) {
                return true;
            }
            ++n3;
        }
        objectArray = nodes = this.matchingNodes.keyTable;
        n2 = nodes.length;
        n3 = 0;
        while (n3 < n2) {
            n = objectArray[n3];
            node2 = (org.eclipse.jdt.internal.compiler.ast.ASTNode)n;
            if (node2 != null && start <= node2.sourceStart && node2.sourceEnd <= end) {
                return true;
            }
            ++n3;
        }
        return this.possibleASTNodes.stream().anyMatch(node -> start <= node.getStartPosition() && node.getStartPosition() + node.getLength() <= end) || this.trustedASTNodeLevels.keySet().stream().anyMatch(node -> start <= node.getStartPosition() && node.getStartPosition() + node.getLength() <= end);
    }

    protected org.eclipse.jdt.internal.compiler.ast.ASTNode[] matchingNodes(int start, int end) {
        Object[] keyTable;
        ArrayList<org.eclipse.jdt.internal.compiler.ast.ASTNode> nodes = null;
        Object[] objectArray = keyTable = this.matchingNodes.keyTable;
        int n = keyTable.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            org.eclipse.jdt.internal.compiler.ast.ASTNode node = (org.eclipse.jdt.internal.compiler.ast.ASTNode)o;
            if (node != null && start <= node.sourceStart && node.sourceEnd <= end) {
                if (nodes == null) {
                    nodes = new ArrayList<org.eclipse.jdt.internal.compiler.ast.ASTNode>();
                }
                nodes.add(node);
            }
            ++n2;
        }
        if (nodes == null) {
            return null;
        }
        Object[] result = (org.eclipse.jdt.internal.compiler.ast.ASTNode[])nodes.toArray(org.eclipse.jdt.internal.compiler.ast.ASTNode[]::new);
        Util.Comparer comparer = new Util.Comparer(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((org.eclipse.jdt.internal.compiler.ast.ASTNode)o1).sourceStart - ((org.eclipse.jdt.internal.compiler.ast.ASTNode)o2).sourceStart;
            }
        };
        Util.sort(result, comparer);
        return result;
    }

    public Object removePossibleMatch(org.eclipse.jdt.internal.compiler.ast.ASTNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        org.eclipse.jdt.internal.compiler.ast.ASTNode existing = (org.eclipse.jdt.internal.compiler.ast.ASTNode)this.possibleMatchingNodesKeys.get(key);
        if (existing == null) {
            return null;
        }
        this.possibleMatchingNodesKeys.put(key, null);
        return this.possibleMatchingNodesSet.remove((Object)node);
    }

    public Object removeTrustedMatch(org.eclipse.jdt.internal.compiler.ast.ASTNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        org.eclipse.jdt.internal.compiler.ast.ASTNode existing = (org.eclipse.jdt.internal.compiler.ast.ASTNode)this.matchingNodesKeys.get(key);
        if (existing == null) {
            return null;
        }
        this.matchingNodesKeys.put(key, null);
        return this.matchingNodes.removeKey((Object)node);
    }

    public String toString() {
        Object[] nodes;
        StringBuilder result = new StringBuilder();
        result.append("Exact matches:");
        Object[] keyTable = this.matchingNodes.keyTable;
        Object[] valueTable = this.matchingNodes.valueTable;
        int i = 0;
        int l = keyTable.length;
        while (i < l) {
            org.eclipse.jdt.internal.compiler.ast.ASTNode node = (org.eclipse.jdt.internal.compiler.ast.ASTNode)keyTable[i];
            if (node != null) {
                result.append("\n\t");
                switch ((Integer)valueTable[i]) {
                    case 0: {
                        result.append("ACCURATE_MATCH: ");
                        break;
                    }
                    case 1: {
                        result.append("INACCURATE_MATCH: ");
                        break;
                    }
                    case 16: {
                        result.append("ERASURE_MATCH: ");
                    }
                }
                node.print(0, result);
            }
            ++i;
        }
        result.append("\nPossible matches:");
        Object[] objectArray = nodes = this.possibleMatchingNodesSet.values;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object n3 = objectArray[n2];
            org.eclipse.jdt.internal.compiler.ast.ASTNode node = (org.eclipse.jdt.internal.compiler.ast.ASTNode)n3;
            if (node != null) {
                result.append("\nPOSSIBLE_MATCH: ");
                node.print(0, result);
            }
            ++n2;
        }
        return result.toString();
    }
}

