"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VarManager = void 0;
const var_1 = require("./mi/var");
class VarManager {
    constructor(gdb) {
        this.gdb = gdb;
        this.variableMap = new Map();
        this.gdb = gdb;
    }
    getKey(frameId, threadId, depth) {
        return `frame${frameId}_thread${threadId}_depth${depth}`;
    }
    getVars(frameId, threadId, depth) {
        return this.variableMap.get(this.getKey(frameId, threadId, depth));
    }
    getVar(frameId, threadId, depth, expression, type) {
        const vars = this.getVars(frameId, threadId, depth);
        if (vars) {
            for (const varobj of vars) {
                if (varobj.expression === expression) {
                    if (type !== 'registers') {
                        type = 'local';
                    }
                    if (type === varobj.varType) {
                        return varobj;
                    }
                }
            }
        }
        return;
    }
    getVarByName(frameId, threadId, depth, varname) {
        const vars = this.getVars(frameId, threadId, depth);
        if (vars) {
            for (const varobj of vars) {
                if (varobj.varname === varname) {
                    return varobj;
                }
            }
        }
        return;
    }
    addVar(frameId, threadId, depth, expression, isVar, isChild, varCreateResponse, type) {
        let vars = this.variableMap.get(this.getKey(frameId, threadId, depth));
        if (!vars) {
            vars = [];
            this.variableMap.set(this.getKey(frameId, threadId, depth), vars);
        }
        const varobj = {
            varname: varCreateResponse.name,
            expression,
            numchild: varCreateResponse.numchild,
            children: [],
            value: varCreateResponse.value,
            type: varCreateResponse.type,
            isVar,
            isChild,
            varType: type ? type : 'local',
        };
        vars.push(varobj);
        return varobj;
    }
    removeVar(frameId, threadId, depth, varname) {
        return __awaiter(this, void 0, void 0, function* () {
            let deleteme;
            const vars = this.variableMap.get(this.getKey(frameId, threadId, depth));
            if (vars) {
                for (const varobj of vars) {
                    if (varobj.varname === varname) {
                        deleteme = varobj;
                        break;
                    }
                }
                if (deleteme) {
                    yield (0, var_1.sendVarDelete)(this.gdb, { varname: deleteme.varname });
                    vars.splice(vars.indexOf(deleteme), 1);
                    for (const child of deleteme.children) {
                        yield this.removeVar(frameId, threadId, depth, child.varname);
                    }
                }
            }
        });
    }
    updateVar(frameId, threadId, depth, varobj) {
        return __awaiter(this, void 0, void 0, function* () {
            let returnVar = varobj;
            const vup = yield (0, var_1.sendVarUpdate)(this.gdb, { name: varobj.varname });
            const update = vup.changelist[0];
            if (update) {
                if (update.in_scope === 'true') {
                    if (update.name === varobj.varname) {
                        // don't update the parent value to a child's value
                        varobj.value = update.value;
                    }
                }
                else {
                    this.removeVar(frameId, threadId, depth, varobj.varname);
                    yield (0, var_1.sendVarDelete)(this.gdb, { varname: varobj.varname });
                    const createResponse = yield (0, var_1.sendVarCreate)(this.gdb, {
                        frame: 'current',
                        expression: varobj.expression,
                        frameId: frameId,
                        threadId: threadId,
                    });
                    returnVar = this.addVar(frameId, threadId, depth, varobj.expression, varobj.isVar, varobj.isChild, createResponse);
                }
            }
            return Promise.resolve(returnVar);
        });
    }
}
exports.VarManager = VarManager;
//# sourceMappingURL=varManager.js.map