"use strict";
/*********************************************************************
 * Copyright (c) 2019 Kichwa Coders and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const cp = require("child_process");
const path = require("path");
const utils_1 = require("./utils");
const chai_1 = require("chai");
describe('attach remote', function () {
    let dc;
    let gdbserver;
    let port;
    const emptyProgram = path.join(utils_1.testProgramsDir, 'empty');
    const emptySrc = path.join(utils_1.testProgramsDir, 'empty.c');
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            dc = yield (0, utils_1.standardBeforeEach)('debugTargetAdapter.js');
            gdbserver = cp.spawn(utils_1.gdbServerPath, [':0', emptyProgram, 'running-from-spawn'], {
                cwd: utils_1.testProgramsDir,
            });
            port = yield new Promise((resolve, reject) => {
                let accumulatedStderr = '';
                if (gdbserver.stderr) {
                    gdbserver.stderr.on('data', (data) => {
                        const line = String(data);
                        accumulatedStderr += line;
                        const LISTENING_ON_PORT = 'Listening on port ';
                        const index = accumulatedStderr.indexOf(LISTENING_ON_PORT);
                        if (index >= 0) {
                            const portStr = accumulatedStderr
                                .substr(index + LISTENING_ON_PORT.length, 6)
                                .trim();
                            resolve(parseInt(portStr, 10));
                        }
                    });
                }
                else {
                    reject(new Error('Missing stderr on spawned gdbserver'));
                }
            });
        });
    });
    afterEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            yield gdbserver.kill();
            yield dc.stop();
        });
    });
    it('can attach remote and hit a breakpoint', function () {
        return __awaiter(this, void 0, void 0, function* () {
            const attachArgs = (0, utils_1.fillDefaults)(this.test, {
                program: emptyProgram,
                target: {
                    type: 'remote',
                    parameters: [`localhost:${port}`],
                },
            });
            yield dc.attachHitBreakpoint(attachArgs, { line: 3, path: emptySrc });
            (0, chai_1.expect)(yield dc.evaluate('argv[1]')).to.contain('running-from-spawn');
        });
    });
});
//# sourceMappingURL=attachRemote.spec.js.map