/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.shareproject;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.operation.local.management.ShareProjectOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.extension.impl.ISelectProjectNamePageData;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.verifier.AbstractValidationManagerProxy;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.team.svn.ui.wizard.shareproject.SelectProjectNamePageSimpleModeComposite;
import org.eclipse.team.svn.ui.wizard.shareproject.ShareProjectNameAdvancedModeComposite;
import org.eclipse.ui.PlatformUI;

public class SelectProjectNamePage
extends AbstractVerifiedWizardPage {
    protected boolean isSimpleMode = SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "simpleShare");
    protected Button simpleModeRadionButton;
    protected Button advancedModeRadionButton;
    protected SelectProjectNamePageSimpleModeComposite simpleModeComposite;
    protected ShareProjectNameAdvancedModeComposite advancedModeComposite;

    public SelectProjectNamePage() {
        super(SelectProjectNamePage.class.getName(), "", SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
    }

    public IRepositoryLocation getLocation() {
        return this.getActivePageData().getRepositoryLocation();
    }

    public boolean isSimpleMode() {
        return this.isSimpleMode;
    }

    public void setProjectsAndLocation(IProject[] projects, IRepositoryLocation location) {
        boolean multiProject = projects.length > 1;
        this.setTitle(SVNUIMessages.SelectProjectNamePage_Title);
        this.setDescription(SVNUIMessages.SelectProjectNamePage_Description);
        this.simpleModeComposite.setProjectsAndLocation(projects, location, multiProject);
        this.advancedModeComposite.setProjectsAndLocation(projects, location, multiProject);
    }

    public boolean isManagementFoldersEnabled() {
        return this.getActivePageData().isManagementFoldersEnabled();
    }

    public int getLayoutType() {
        return this.getActivePageData().getLayoutType();
    }

    public ShareProjectOperation.IFolderNameMapper getSelectedNames() {
        return this.getActivePageData().getSelectedNames();
    }

    public String getRootProjectName() {
        return this.getActivePageData().getRootProjectName();
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ModeListener modeListener = new ModeListener();
        this.simpleModeRadionButton = new Button(composite, 16);
        this.simpleModeRadionButton.setText(SVNUIMessages.SelectProjectNamePage_SimpleModeButton);
        this.simpleModeRadionButton.setSelection(this.isSimpleMode);
        this.simpleModeRadionButton.addSelectionListener((SelectionListener)modeListener);
        SelectProjectNamePageValidationManager simpleModeValidationManager = new SelectProjectNamePageValidationManager(this, true);
        this.simpleModeComposite = new SelectProjectNamePageSimpleModeComposite(composite, 0, simpleModeValidationManager);
        layout = (GridLayout)this.simpleModeComposite.getLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData gridData = (GridData)this.simpleModeComposite.getLayoutData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Label label = new Label(composite, 258);
        gridData = new GridData(768);
        gridData.verticalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.advancedModeRadionButton = new Button(composite, 16);
        this.advancedModeRadionButton.setText(SVNUIMessages.SelectProjectNamePage_AdvancedModeButton);
        this.advancedModeRadionButton.setSelection(!this.isSimpleMode);
        layout = new GridLayout();
        gridData = new GridData();
        gridData.verticalIndent = 5;
        this.advancedModeRadionButton.setLayoutData((Object)gridData);
        this.advancedModeRadionButton.addSelectionListener((SelectionListener)modeListener);
        SelectProjectNamePageValidationManager advancedModeValidationManager = new SelectProjectNamePageValidationManager(this, false);
        this.advancedModeComposite = new ShareProjectNameAdvancedModeComposite(composite, 0, advancedModeValidationManager);
        layout = (GridLayout)this.advancedModeComposite.getLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        gridData = (GridData)this.advancedModeComposite.getLayoutData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.enableControlsArea();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.projectNameContext");
        return composite;
    }

    protected void enableControlsArea() {
        if (this.isSimpleMode) {
            this.simpleModeComposite.setEnabled(true);
            this.advancedModeComposite.setEnabled(false);
        } else {
            this.simpleModeComposite.setEnabled(false);
            this.advancedModeComposite.setEnabled(true);
        }
        this.simpleModeComposite.validateContent();
        this.advancedModeComposite.validateContent();
    }

    protected ISelectProjectNamePageData getActivePageData() {
        return this.isSimpleMode ? this.simpleModeComposite : this.advancedModeComposite;
    }

    public IWizardPage getNextPage() {
        this.getActivePageData().save();
        SVNTeamPreferences.setRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "simpleShare", this.isSimpleMode);
        return super.getNextPage();
    }

    protected class ModeListener
    extends SelectionAdapter {
        protected ModeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button modeButton = (Button)e.widget;
            if (SelectProjectNamePage.this.simpleModeRadionButton == modeButton && !SelectProjectNamePage.this.isSimpleMode) {
                SelectProjectNamePage.this.isSimpleMode = true;
                SelectProjectNamePage.this.enableControlsArea();
            } else if (SelectProjectNamePage.this.advancedModeRadionButton == modeButton && SelectProjectNamePage.this.isSimpleMode) {
                SelectProjectNamePage.this.isSimpleMode = false;
                SelectProjectNamePage.this.enableControlsArea();
            }
        }
    }

    protected class SelectProjectNamePageValidationManager
    extends AbstractValidationManagerProxy {
        protected boolean isSimpleValidationManager;

        public SelectProjectNamePageValidationManager(IValidationManager validationManager, boolean isSimpleValidationManager) {
            super(validationManager);
            this.isSimpleValidationManager = isSimpleValidationManager;
        }

        @Override
        protected boolean isVerificationEnabled(Control input) {
            return SelectProjectNamePage.this.isSimpleMode == this.isSimpleValidationManager;
        }
    }
}

