/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.repository.RepositoriesView;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.model.IDataTreeNode;

public class RefreshRemoteResourcesOperation
extends AbstractRepositoryOperation {
    public RefreshRemoteResourcesOperation(IRepositoryResource[] resources) {
        super("Operation_RefreshRemote", SVNUIMessages.class, resources);
    }

    public RefreshRemoteResourcesOperation(IRepositoryResourceProvider provider) {
        super("Operation_RefreshRemote", SVNUIMessages.class, provider);
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources;
        IRepositoryResource[] iRepositoryResourceArray = resources = this.operableData();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource current = iRepositoryResourceArray[n2];
            this.protectStep(monitor1 -> {
                if (current instanceof IRepositoryRoot && ((IRepositoryRoot)current).getKind() == 0) {
                    RepositoriesView.refresh(current.getRepositoryLocation(), new RefreshVisitor());
                } else {
                    RepositoriesView.refresh(current, new RefreshVisitor());
                }
            }, monitor, resources.length);
            ++n2;
        }
    }

    protected class RefreshVisitor
    implements RepositoryTreeViewer.IRefreshVisitor {
        protected RefreshVisitor() {
        }

        @Override
        public void visit(Object element) {
            if (element instanceof IDataTreeNode) {
                ((IDataTreeNode)element).refresh();
            }
        }
    }
}

