/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local.management;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.UpgradeWorkingCopyOperation;
import org.eclipse.team.svn.ui.action.AbstractLocalTeamAction;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class UpgradeProjectsAction
extends AbstractLocalTeamAction {
    @Override
    public void runImpl(IAction action) {
        IProject[] projects = this.getProjectsToUpgrade();
        UIMonitorUtility.doTaskScheduledWorkspaceModify((IActionOperation)new UpgradeWorkingCopyOperation((IResource[])projects));
    }

    protected IProject[] getProjectsToUpgrade() {
        HashSet<IProject> projects = new HashSet<IProject>(Arrays.asList(this.getSelectedProjects()));
        Iterator<IProject> it = projects.iterator();
        while (it.hasNext()) {
            IProject project = it.next();
            if (project.isAccessible() && SVNTeamProvider.requiresUpgrade((IProject)project)) continue;
            it.remove();
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    @Override
    public boolean isEnabled() {
        IProject[] projects;
        IProject[] iProjectArray = projects = this.getSelectedProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && SVNTeamProvider.requiresUpgrade((IProject)project)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

