/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.eclipse.team.svn.ui.action.local.UpdateAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.local.UpdateToRevisionPanel;
import org.eclipse.team.svn.ui.utility.UnacceptableOperationNotificator;

public class UpdateToRevisionAction
extends AbstractRecursiveTeamAction {
    @Override
    public void runImpl(IAction action) {
        IResource[] shrinkedResources;
        IResource[] missing;
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(this.getShell(), this.getSelectedResources(IStateFilter.SF_ONREPOSITORY));
        if (resources == null || resources.length == 0) {
            return;
        }
        if (this.checkForResourcesPresenceRecursive(IStateFilter.SF_REVERTABLE) && (missing = this.getSelectedResourcesRecursive(UpdateAction.SF_MISSING_RESOURCES)).length > 0 && !UpdateAction.updateMissing(this.getShell(), missing)) {
            return;
        }
        Object resourceForRevisionSelection = resources.length > 1 ? ((shrinkedResources = FileUtility.shrinkChildNodes((IResource[])resources)).length > 1 ? shrinkedResources[0].getProject() : shrinkedResources[0]) : resources[0];
        boolean canShowUpdateDepthPath = resources.length == 1;
        IRepositoryResource repositoryResource = SVNRemoteStorage.instance().asRepositoryResource(resourceForRevisionSelection);
        UpdateToRevisionPanel panel = new UpdateToRevisionPanel(repositoryResource, canShowUpdateDepthPath);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            this.runScheduled((IActionOperation)UpdateAction.getUpdateOperation(resources, panel.getRevision(), panel.getDepth(), panel.isStickyDepth(), panel.getUpdateDepthPath()));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

