/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui;

import java.net.URI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.svn.core.SVNTeamProjectSetCapability;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.ui.IScmUrlImportWizardPage;
import org.eclipse.ui.PlatformUI;

public class SVNScmUrlImportWizardPage
extends WizardPage
implements IScmUrlImportWizardPage {
    private ScmUrlImportDescription[] descriptions;
    private Label counterLabel;
    private TableViewer bundlesViewer;
    private Button useHead;
    private static final String SVN_PAGE_USE_HEAD = "org.eclipse.team.svn.ui.import.page.head";

    public SVNScmUrlImportWizardPage() {
        super("svn", SVNUIMessages.SVNScmUrlImportWizardPage_Title, null);
        this.setDescription(SVNUIMessages.SVNScmUrlImportWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTUtils.createHVFillComposite((Composite)parent, (int)0, (int)1);
        Composite group = SWTUtils.createHFillComposite((Composite)comp, (int)0, (int)1);
        Button versions = SWTUtils.createRadioButton((Composite)group, (String)SVNUIMessages.SVNScmUrlImportWizardPage_ImportVersion);
        this.useHead = SWTUtils.createRadioButton((Composite)group, (String)SVNUIMessages.SVNScmUrlImportWizardPage_ImportHEAD);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNScmUrlImportWizardPage.this.bundlesViewer.refresh(true);
            }
        };
        versions.addSelectionListener((SelectionListener)listener);
        this.useHead.addSelectionListener((SelectionListener)listener);
        Table table = new Table(comp, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.bundlesViewer = new TableViewer(table);
        this.bundlesViewer.setLabelProvider((IBaseLabelProvider)new SvnLabelProvider());
        this.bundlesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.bundlesViewer.setComparator(new ViewerComparator());
        this.counterLabel = new Label(comp, 0);
        this.counterLabel.setLayoutData((Object)new GridData(768));
        this.setControl((Control)comp);
        this.setPageComplete(true);
        this.useHead.setSelection(true);
        versions.setEnabled(false);
        if (this.descriptions != null) {
            this.bundlesViewer.setInput((Object)this.descriptions);
            this.updateCount();
        }
    }

    public boolean finish() {
        boolean head = false;
        if (this.getControl() != null) {
            head = this.useHead.getSelection();
            settings = this.getWizard().getDialogSettings();
            if (settings != null) {
                settings.put(SVN_PAGE_USE_HEAD, head);
            }
        } else {
            settings = this.getWizard().getDialogSettings();
            if (settings != null) {
                head = settings.getBoolean(SVN_PAGE_USE_HEAD);
            }
        }
        if (head && this.descriptions != null) {
            ScmUrlImportDescription[] scmUrlImportDescriptionArray = this.descriptions;
            int n = this.descriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ScmUrlImportDescription description = scmUrlImportDescriptionArray[n2];
                URI scmUri = description.getUri();
                description.setUrl(SVNScmUrlImportWizardPage.removeTag(scmUri));
                ++n2;
            }
        }
        return true;
    }

    public ScmUrlImportDescription[] getSelection() {
        return this.descriptions;
    }

    public void setSelection(ScmUrlImportDescription[] descriptions) {
        this.descriptions = descriptions;
        if (this.bundlesViewer != null) {
            this.bundlesViewer.setInput((Object)descriptions);
            this.updateCount();
        }
    }

    private void updateCount() {
        this.counterLabel.setText(NLS.bind((String)SVNUIMessages.SVNScmUrlImportWizardPage_Counter, (Object)this.descriptions.length));
        this.counterLabel.getParent().layout();
    }

    private static String getTag(URI scmUri) {
        return SVNScmUrlImportWizardPage.splitTagPart(scmUri.toString())[1];
    }

    private static String removeTag(URI scmUri) {
        return SVNScmUrlImportWizardPage.splitTagPart(scmUri.toString())[0];
    }

    private static String getServer(URI scmUri) {
        return SVNScmUrlImportWizardPage.splitTagPart(SVNTeamProjectSetCapability.getSingleSchemeUrl((URI)scmUri))[0];
    }

    private static String[] splitTagPart(String url) {
        String[] stringArray;
        int i = url.lastIndexOf(47);
        if (i < 0) {
            return new String[]{url, ""};
        }
        String lastUrlPart = url.substring(i);
        int j = lastUrlPart.lastIndexOf(64);
        if (j < 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = url;
            stringArray = stringArray2;
            stringArray2[1] = "";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = url.substring(0, i) + lastUrlPart.substring(0, j);
            stringArray = stringArray3;
            stringArray3[1] = lastUrlPart.substring(j);
        }
        return stringArray;
    }

    private class SvnLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        private SvnLabelProvider() {
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public void update(ViewerCell cell) {
            StyledString string = this.getStyledText(cell.getElement());
            cell.setText(string.getString());
            cell.setStyleRanges(string.getStyleRanges());
            cell.setImage(this.getImage(cell.getElement()));
            super.update(cell);
        }

        private StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof ScmUrlImportDescription) {
                ScmUrlImportDescription description = (ScmUrlImportDescription)element;
                String project = description.getProject();
                URI scmUrl = description.getUri();
                String version = SVNScmUrlImportWizardPage.getTag(scmUrl);
                String host = SVNScmUrlImportWizardPage.getServer(scmUrl);
                styledString.append(project);
                if (version != null) {
                    styledString.append(' ');
                    styledString.append(version, StyledString.DECORATIONS_STYLER);
                }
                styledString.append(' ');
                styledString.append('[', StyledString.DECORATIONS_STYLER);
                styledString.append(host, StyledString.DECORATIONS_STYLER);
                styledString.append(']', StyledString.DECORATIONS_STYLER);
                return styledString;
            }
            styledString.append(element.toString());
            return styledString;
        }
    }
}

