/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.shareproject;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.operation.local.management.ShareProjectOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.CommentComposite;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class EditCommentPage
extends AbstractVerifiedWizardPage {
    protected String commitComment;
    protected IRepositoryLocation location;
    protected CommentComposite commentComposite;
    protected IResourceProvider provider;
    protected boolean showCommitDialog;

    public EditCommentPage(IResourceProvider provider) {
        super(EditCommentPage.class.getName(), SVNUIMessages.EditCommentPage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.EditCommentPage_Description);
        this.provider = provider;
    }

    public boolean isShowCommitDialog() {
        return this.showCommitDialog;
    }

    public String getCommitComment() {
        this.commentComposite.saveChanges();
        return this.commentComposite.getMessage();
    }

    public void setSelectedRepositoryLocation(IRepositoryLocation location) {
        this.location = location;
    }

    public void setDefaultCommitMessage() {
        IProject[] projects;
        this.commitComment = "";
        IProject[] iProjectArray = projects = this.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            String commentPart = ShareProjectOperation.getDefaultComment((IProject)project, (IRepositoryResource)this.location.getRoot());
            this.commitComment = String.valueOf(this.commitComment) + (String)(this.commitComment.length() == 0 ? commentPart : "\n" + commentPart);
            ++n2;
        }
        this.commentComposite.setMessage(this.commitComment);
    }

    protected IProject[] getProjects() {
        return (IProject[])this.provider.getResources();
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.commentComposite = new CommentComposite(composite, this.commitComment, this, null, null);
        GridData data = new GridData(1808);
        this.commentComposite.setLayoutData(data);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setVisible(false);
        Button showComment = new Button(composite, 32);
        showComment.setText(SVNUIMessages.EditCommentPage_LaunchCommit);
        this.showCommitDialog = true;
        showComment.setSelection(true);
        showComment.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditCommentPage.this.showCommitDialog = ((Button)e.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.editCommentContext");
        return composite;
    }
}

